/*
 * Decompiled with CFR 0.152.
 */
package coil.drawable;

import android.content.res.ColorStateList;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import coil.decode.DecodeUtils;
import coil.size.Scale;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 U2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001UB9\b\u0017\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fBA\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001f\u001a\u00020 H\u0016J!\u0010!\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010\t2\b\u0010#\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\tH\u0017J\n\u0010)\u001a\u0004\u0018\u00010*H\u0017J\b\u0010+\u001a\u00020\tH\u0016J\b\u0010,\u001a\u00020\tH\u0016J\b\u0010-\u001a\u00020\tH\u0016J\u0010\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u00020\u0001H\u0016J\b\u00100\u001a\u00020\u000bH\u0016J\b\u00101\u001a\u00020 H\u0002J\u0010\u00102\u001a\u00020 2\u0006\u00103\u001a\u000204H\u0014J\u0010\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\tH\u0014J\u0010\u00107\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u000208H\u0014J\u0010\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020\u0011H\u0016J \u0010;\u001a\u00020 2\u0006\u0010/\u001a\u00020\u00012\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001dH\u0016J\u0010\u0010?\u001a\u00020 2\u0006\u0010@\u001a\u00020\tH\u0016J\u0012\u0010A\u001a\u00020 2\b\u0010B\u001a\u0004\u0018\u00010*H\u0017J\u0010\u0010C\u001a\u00020 2\u0006\u0010D\u001a\u00020\tH\u0017J\u0012\u0010E\u001a\u00020 2\b\u0010F\u001a\u0004\u0018\u00010GH\u0017J\u0012\u0010H\u001a\u00020 2\b\u0010I\u001a\u0004\u0018\u00010JH\u0017J\u0012\u0010K\u001a\u00020 2\b\u0010L\u001a\u0004\u0018\u00010MH\u0017J\b\u0010\u0004\u001a\u00020 H\u0016J\b\u0010N\u001a\u00020 H\u0016J\u0010\u0010O\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020\u0011H\u0016J\u0018\u0010P\u001a\u00020 2\u0006\u0010/\u001a\u00020\u00012\u0006\u0010<\u001a\u00020=H\u0016J\u001d\u0010Q\u001a\u00020 2\u0006\u0010R\u001a\u00020\u00012\u0006\u0010S\u001a\u000204H\u0001\u00a2\u0006\u0002\bTR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcoil/drawable/CrossfadeDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Drawable$Callback;", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat;", "start", "end", "scale", "Lcoil/size/Scale;", "durationMillis", "", "fadeStart", "", "(Landroid/graphics/drawable/Drawable;Landroid/graphics/drawable/Drawable;Lcoil/size/Scale;IZ)V", "preferExactIntrinsicSize", "(Landroid/graphics/drawable/Drawable;Landroid/graphics/drawable/Drawable;Lcoil/size/Scale;IZZ)V", "callbacks", "", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat$AnimationCallback;", "getDurationMillis", "()I", "getFadeStart", "()Z", "intrinsicHeight", "intrinsicWidth", "maxAlpha", "getPreferExactIntrinsicSize", "getScale", "()Lcoil/size/Scale;", "startTimeMillis", "", "state", "clearAnimationCallbacks", "", "computeIntrinsicDimension", "startSize", "endSize", "(Ljava/lang/Integer;Ljava/lang/Integer;)I", "draw", "canvas", "Landroid/graphics/Canvas;", "getAlpha", "getColorFilter", "Landroid/graphics/ColorFilter;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "invalidateDrawable", "who", "isRunning", "markDone", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "onLevelChange", "level", "onStateChange", "", "registerAnimationCallback", "callback", "scheduleDrawable", "what", "Ljava/lang/Runnable;", "when", "setAlpha", "alpha", "setColorFilter", "colorFilter", "setTint", "tintColor", "setTintBlendMode", "blendMode", "Landroid/graphics/BlendMode;", "setTintList", "tint", "Landroid/content/res/ColorStateList;", "setTintMode", "tintMode", "Landroid/graphics/PorterDuff$Mode;", "stop", "unregisterAnimationCallback", "unscheduleDrawable", "updateBounds", "drawable", "targetBounds", "updateBounds$coil_base_release", "Companion", "coil-base_release"})
public final class CrossfadeDrawable
extends Drawable
implements Drawable.Callback,
Animatable2Compat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Scale scale;
    private final int durationMillis;
    private final boolean fadeStart;
    private final boolean preferExactIntrinsicSize;
    @NotNull
    private final List<Animatable2Compat.AnimationCallback> callbacks;
    private final int intrinsicWidth;
    private final int intrinsicHeight;
    @Nullable
    private Drawable start;
    @Nullable
    private final Drawable end;
    private long startTimeMillis;
    private int maxAlpha;
    private int state;
    private static final int STATE_START = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_DONE = 2;
    public static final int DEFAULT_DURATION = 100;

    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end, @NotNull Scale scale, int durationMillis, boolean fadeStart, boolean preferExactIntrinsicSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        this.scale = scale;
        this.durationMillis = durationMillis;
        this.fadeStart = fadeStart;
        this.preferExactIntrinsicSize = preferExactIntrinsicSize;
        boolean bl = false;
        this.callbacks = new ArrayList();
        Drawable drawable = start;
        Integer n = drawable == null ? null : Integer.valueOf(drawable.getIntrinsicWidth());
        drawable = end;
        this.intrinsicWidth = this.computeIntrinsicDimension(n, drawable == null ? null : Integer.valueOf(drawable.getIntrinsicWidth()));
        drawable = start;
        Integer n2 = drawable == null ? null : Integer.valueOf(drawable.getIntrinsicHeight());
        drawable = end;
        this.intrinsicHeight = this.computeIntrinsicDimension(n2, drawable == null ? null : Integer.valueOf(drawable.getIntrinsicHeight()));
        drawable = start;
        this.start = drawable == null ? null : drawable.mutate();
        drawable = end;
        this.end = drawable == null ? null : drawable.mutate();
        this.maxAlpha = 255;
        boolean bl2 = this.durationMillis > 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "durationMillis must be > 0.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Drawable drawable2 = this.start;
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
        }
        drawable2 = this.end;
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
        }
    }

    public /* synthetic */ CrossfadeDrawable(Drawable drawable, Drawable drawable2, Scale scale, int n, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            scale = Scale.FIT;
        }
        if ((n2 & 8) != 0) {
            n = 100;
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        this(drawable, drawable2, scale, n, bl, bl2);
    }

    @NotNull
    public final Scale getScale() {
        return this.scale;
    }

    public final int getDurationMillis() {
        return this.durationMillis;
    }

    public final boolean getFadeStart() {
        return this.fadeStart;
    }

    public final boolean getPreferExactIntrinsicSize() {
        return this.preferExactIntrinsicSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NotNull Canvas canvas) {
        int checkpoint$iv;
        boolean $i$f$withSave;
        Canvas $this$withSave$iv;
        boolean bl;
        boolean bl2;
        Drawable drawable;
        Drawable drawable2;
        boolean isDone;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.state == 0) {
            Drawable drawable3 = this.start;
            if (drawable3 != null) {
                Drawable drawable4 = drawable3;
                boolean bl3 = false;
                boolean bl4 = false;
                Drawable $this$draw_u24lambda_u2d2 = drawable4;
                boolean bl5 = false;
                $this$draw_u24lambda_u2d2.setAlpha(this.maxAlpha);
                Canvas $this$withSave$iv2 = canvas;
                boolean $i$f$withSave2 = false;
                int checkpoint$iv2 = $this$withSave$iv2.save();
                try {
                    Canvas $this$draw_u24lambda_u2d2_u24lambda_u2d1 = $this$withSave$iv2;
                    boolean bl6 = false;
                    $this$draw_u24lambda_u2d2.draw(canvas);
                }
                finally {
                    $this$withSave$iv2.restoreToCount(checkpoint$iv2);
                }
            }
            return;
        }
        if (this.state == 2) {
            Drawable drawable5 = this.end;
            if (drawable5 != null) {
                Drawable drawable6 = drawable5;
                boolean bl7 = false;
                boolean bl8 = false;
                Drawable $this$draw_u24lambda_u2d4 = drawable6;
                boolean bl9 = false;
                $this$draw_u24lambda_u2d4.setAlpha(this.maxAlpha);
                Canvas $this$withSave$iv3 = canvas;
                boolean $i$f$withSave3 = false;
                int checkpoint$iv3 = $this$withSave$iv3.save();
                try {
                    Canvas $this$draw_u24lambda_u2d4_u24lambda_u2d3 = $this$withSave$iv3;
                    boolean bl10 = false;
                    $this$draw_u24lambda_u2d4.draw(canvas);
                }
                finally {
                    $this$withSave$iv3.restoreToCount(checkpoint$iv3);
                }
            }
            return;
        }
        double percent = (double)(SystemClock.uptimeMillis() - this.startTimeMillis) / (double)this.durationMillis;
        int endAlpha = (int)(RangesKt.coerceIn((double)percent, (double)0.0, (double)1.0) * (double)this.maxAlpha);
        int startAlpha = this.fadeStart ? this.maxAlpha - endAlpha : this.maxAlpha;
        boolean bl11 = isDone = percent >= 1.0;
        if (!isDone && (drawable2 = this.start) != null) {
            drawable = drawable2;
            bl2 = false;
            bl = false;
            Drawable $this$draw_u24lambda_u2d6 = drawable;
            boolean bl12 = false;
            $this$draw_u24lambda_u2d6.setAlpha(startAlpha);
            $this$withSave$iv = canvas;
            $i$f$withSave = false;
            checkpoint$iv = $this$withSave$iv.save();
            try {
                Canvas $this$draw_u24lambda_u2d6_u24lambda_u2d5 = $this$withSave$iv;
                boolean bl13 = false;
                $this$draw_u24lambda_u2d6.draw(canvas);
            }
            finally {
                $this$withSave$iv.restoreToCount(checkpoint$iv);
            }
        }
        if ((drawable2 = this.end) != null) {
            drawable = drawable2;
            bl2 = false;
            bl = false;
            Drawable $this$draw_u24lambda_u2d8 = drawable;
            boolean bl14 = false;
            $this$draw_u24lambda_u2d8.setAlpha(endAlpha);
            $this$withSave$iv = canvas;
            $i$f$withSave = false;
            checkpoint$iv = $this$withSave$iv.save();
            try {
                Canvas $this$draw_u24lambda_u2d8_u24lambda_u2d7 = $this$withSave$iv;
                boolean bl15 = false;
                $this$draw_u24lambda_u2d8.draw(canvas);
            }
            finally {
                $this$withSave$iv.restoreToCount(checkpoint$iv);
            }
        }
        if (isDone) {
            this.markDone();
        } else {
            this.invalidateSelf();
        }
    }

    @RequiresApi(value=19)
    public int getAlpha() {
        return this.maxAlpha;
    }

    public void setAlpha(int alpha) {
        boolean bl = 0 <= alpha ? alpha <= 255 : false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Invalid alpha: ", (Object)alpha);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.maxAlpha = alpha;
    }

    public int getOpacity() {
        Drawable start = this.start;
        Drawable end = this.end;
        if (this.state == 0) {
            int n;
            Drawable drawable = start;
            return drawable == null ? -2 : (n = drawable.getOpacity());
        }
        if (this.state == 2) {
            int n;
            Drawable drawable = end;
            return drawable == null ? -2 : (n = drawable.getOpacity());
        }
        return start != null && end != null ? Drawable.resolveOpacity((int)start.getOpacity(), (int)end.getOpacity()) : (start != null ? start.getOpacity() : (end != null ? end.getOpacity() : -2));
    }

    @RequiresApi(value=21)
    @Nullable
    public ColorFilter getColorFilter() {
        ColorFilter colorFilter;
        int n = this.state;
        switch (n) {
            case 0: {
                Drawable drawable = this.start;
                if (drawable == null) {
                    colorFilter = null;
                    break;
                }
                colorFilter = drawable.getColorFilter();
                break;
            }
            case 1: {
                ColorFilter colorFilter2;
                Drawable drawable = this.end;
                ColorFilter colorFilter3 = colorFilter2 = drawable == null ? null : drawable.getColorFilter();
                if (colorFilter2 == null) {
                    drawable = this.start;
                    if (drawable == null) {
                        colorFilter = null;
                        break;
                    }
                    colorFilter = drawable.getColorFilter();
                    break;
                }
                colorFilter = colorFilter2;
                break;
            }
            case 2: {
                Drawable drawable = this.end;
                if (drawable == null) {
                    colorFilter = null;
                    break;
                }
                colorFilter = drawable.getColorFilter();
                break;
            }
            default: {
                colorFilter = null;
            }
        }
        return colorFilter;
    }

    @RequiresApi(value=21)
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setColorFilter(colorFilter);
        }
        drawable = this.end;
        if (drawable != null) {
            drawable.setColorFilter(colorFilter);
        }
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Drawable it;
        boolean bl;
        boolean bl2;
        Drawable drawable;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Drawable drawable2 = this.start;
        if (drawable2 != null) {
            drawable = drawable2;
            bl2 = false;
            bl = false;
            it = drawable;
            boolean bl3 = false;
            this.updateBounds$coil_base_release(it, bounds);
        }
        drawable2 = this.end;
        if (drawable2 != null) {
            drawable = drawable2;
            bl2 = false;
            bl = false;
            it = drawable;
            boolean bl4 = false;
            this.updateBounds$coil_base_release(it, bounds);
        }
    }

    protected boolean onLevelChange(int level) {
        boolean bl;
        boolean bl2;
        Drawable drawable = this.start;
        boolean startChanged = drawable == null ? false : (bl2 = drawable.setLevel(level));
        Drawable drawable2 = this.end;
        boolean endChanged = drawable2 == null ? false : (bl = drawable2.setLevel(level));
        return startChanged || endChanged;
    }

    protected boolean onStateChange(@NotNull int[] state) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Drawable drawable = this.start;
        boolean startChanged = drawable == null ? false : (bl2 = drawable.setState(state));
        Drawable drawable2 = this.end;
        boolean endChanged = drawable2 == null ? false : (bl = drawable2.setState(state));
        return startChanged || endChanged;
    }

    public int getIntrinsicWidth() {
        return this.intrinsicWidth;
    }

    public int getIntrinsicHeight() {
        return this.intrinsicHeight;
    }

    public void unscheduleDrawable(@NotNull Drawable who, @NotNull Runnable what) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        this.unscheduleSelf(what);
    }

    public void invalidateDrawable(@NotNull Drawable who) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        this.invalidateSelf();
    }

    public void scheduleDrawable(@NotNull Drawable who, @NotNull Runnable what, long when) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        this.scheduleSelf(what, when);
    }

    @RequiresApi(value=21)
    public void setTint(int tintColor) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setTint(tintColor);
        }
        drawable = this.end;
        if (drawable != null) {
            drawable.setTint(tintColor);
        }
    }

    @RequiresApi(value=21)
    public void setTintList(@Nullable ColorStateList tint) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setTintList(tint);
        }
        drawable = this.end;
        if (drawable != null) {
            drawable.setTintList(tint);
        }
    }

    @RequiresApi(value=21)
    public void setTintMode(@Nullable PorterDuff.Mode tintMode) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setTintMode(tintMode);
        }
        drawable = this.end;
        if (drawable != null) {
            drawable.setTintMode(tintMode);
        }
    }

    @RequiresApi(value=29)
    public void setTintBlendMode(@Nullable BlendMode blendMode) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setTintBlendMode(blendMode);
        }
        drawable = this.end;
        if (drawable != null) {
            drawable.setTintBlendMode(blendMode);
        }
    }

    public boolean isRunning() {
        return this.state == 1;
    }

    public void start() {
        Animatable animatable;
        Drawable drawable = this.start;
        Animatable animatable2 = animatable = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable != null) {
            animatable.start();
        }
        drawable = this.end;
        Animatable animatable3 = animatable = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable != null) {
            animatable.start();
        }
        if (this.state != 0) {
            return;
        }
        this.state = 1;
        this.startTimeMillis = SystemClock.uptimeMillis();
        List<Animatable2Compat.AnimationCallback> $this$forEachIndices$iv = this.callbacks;
        boolean $i$f$forEachIndices = false;
        int n = 0;
        int n2 = $this$forEachIndices$iv.size() + -1;
        if (n <= n2) {
            do {
                int i$iv = n++;
                Animatable2Compat.AnimationCallback it = $this$forEachIndices$iv.get(i$iv);
                boolean bl = false;
                it.onAnimationStart((Drawable)this);
            } while (n <= n2);
        }
        this.invalidateSelf();
    }

    public void stop() {
        Animatable animatable;
        Drawable drawable = this.start;
        Animatable animatable2 = animatable = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable != null) {
            animatable.stop();
        }
        drawable = this.end;
        Animatable animatable3 = animatable = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable != null) {
            animatable.stop();
        }
        if (this.state != 2) {
            this.markDone();
        }
    }

    public void registerAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacks.add(callback);
    }

    public boolean unregisterAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return this.callbacks.remove(callback);
    }

    public void clearAnimationCallbacks() {
        this.callbacks.clear();
    }

    @VisibleForTesting
    public final void updateBounds$coil_base_release(@NotNull Drawable drawable, @NotNull Rect targetBounds) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)targetBounds, (String)"targetBounds");
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        if (width <= 0 || height <= 0) {
            drawable.setBounds(targetBounds);
            return;
        }
        int targetWidth = targetBounds.width();
        int targetHeight = targetBounds.height();
        double multiplier = DecodeUtils.computeSizeMultiplier(width, height, targetWidth, targetHeight, this.scale);
        int dx = MathKt.roundToInt((double)(((double)targetWidth - multiplier * (double)width) / (double)2));
        int dy = MathKt.roundToInt((double)(((double)targetHeight - multiplier * (double)height) / (double)2));
        int left = targetBounds.left + dx;
        int top = targetBounds.top + dy;
        int right = targetBounds.right - dx;
        int bottom = targetBounds.bottom - dy;
        drawable.setBounds(left, top, right, bottom);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int computeIntrinsicDimension(Integer startSize, Integer endSize) {
        Integer n;
        if (!this.preferExactIntrinsicSize) {
            Integer n2 = startSize;
            int n3 = -1;
            if (n2 != null) {
                if (n2 == n3) return -1;
            }
            Integer n4 = endSize;
            n3 = -1;
            if (n4 != null && n4 == n3) {
                return -1;
            }
        }
        int n5 = (n = startSize) == null ? -1 : n;
        Integer n6 = endSize;
        int n7 = n6 == null ? -1 : n6;
        boolean bl = false;
        int n8 = Math.max(n5, n7);
        return n8;
    }

    private final void markDone() {
        this.state = 2;
        this.start = null;
        List<Animatable2Compat.AnimationCallback> $this$forEachIndices$iv = this.callbacks;
        boolean $i$f$forEachIndices = false;
        int n = 0;
        int n2 = $this$forEachIndices$iv.size() + -1;
        if (n <= n2) {
            do {
                int i$iv = n++;
                Animatable2Compat.AnimationCallback it = $this$forEachIndices$iv.get(i$iv);
                boolean bl = false;
                it.onAnimationEnd((Drawable)this);
            } while (n <= n2);
        }
    }

    @JvmOverloads
    @SinceKotlin(version="999.9")
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end, @NotNull Scale scale, int durationMillis, boolean fadeStart) {
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        this(start, end, scale, durationMillis, fadeStart, false, 32, null);
    }

    public /* synthetic */ CrossfadeDrawable(Drawable drawable, Drawable drawable2, Scale scale, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            scale = Scale.FIT;
        }
        if ((n2 & 8) != 0) {
            n = 100;
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        this(drawable, drawable2, scale, n, bl);
    }

    @JvmOverloads
    @SinceKotlin(version="999.9")
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end, @NotNull Scale scale, int durationMillis) {
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        this(start, end, scale, durationMillis, false, 16, null);
    }

    @JvmOverloads
    @SinceKotlin(version="999.9")
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end, @NotNull Scale scale) {
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        this(start, end, scale, 0, false, 24, null);
    }

    @JvmOverloads
    @SinceKotlin(version="999.9")
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end) {
        this(start, end, null, 0, false, 28, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcoil/drawable/CrossfadeDrawable$Companion;", "", "()V", "DEFAULT_DURATION", "", "STATE_DONE", "STATE_RUNNING", "STATE_START", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

