/*
 * Decompiled with CFR 0.152.
 */
package coil;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import coil.ComponentRegistry;
import coil.EventListener;
import coil.RealImageLoader;
import coil.annotation.ExperimentalCoilApi;
import coil.bitmap.BitmapPool;
import coil.bitmap.BitmapReferenceCounter;
import coil.bitmap.EmptyBitmapPool;
import coil.bitmap.EmptyBitmapReferenceCounter;
import coil.bitmap.RealBitmapPool;
import coil.bitmap.RealBitmapReferenceCounter;
import coil.memory.EmptyWeakMemoryCache;
import coil.memory.MemoryCache;
import coil.memory.RealMemoryCache;
import coil.memory.RealWeakMemoryCache;
import coil.memory.StrongMemoryCache;
import coil.memory.WeakMemoryCache;
import coil.request.CachePolicy;
import coil.request.DefaultRequestOptions;
import coil.request.Disposable;
import coil.request.ImageRequest;
import coil.request.ImageResult;
import coil.size.Precision;
import coil.transition.CrossfadeTransition;
import coil.transition.Transition;
import coil.util.-Contexts;
import coil.util.-Extensions;
import coil.util.CoilUtils;
import coil.util.ImageLoaderOptions;
import coil.util.Logger;
import coil.util.Utils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0019\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H&J\b\u0010\u0017\u001a\u00020\u0018H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lcoil/ImageLoader;", "", "bitmapPool", "Lcoil/bitmap/BitmapPool;", "getBitmapPool", "()Lcoil/bitmap/BitmapPool;", "defaults", "Lcoil/request/DefaultRequestOptions;", "getDefaults", "()Lcoil/request/DefaultRequestOptions;", "memoryCache", "Lcoil/memory/MemoryCache;", "getMemoryCache", "()Lcoil/memory/MemoryCache;", "enqueue", "Lcoil/request/Disposable;", "request", "Lcoil/request/ImageRequest;", "execute", "Lcoil/request/ImageResult;", "(Lcoil/request/ImageRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "newBuilder", "Lcoil/ImageLoader$Builder;", "shutdown", "", "Builder", "Companion", "coil-base_release"})
public interface ImageLoader {
    @NotNull
    public static final Companion Companion = coil.ImageLoader$Companion.$$INSTANCE;

    @NotNull
    public DefaultRequestOptions getDefaults();

    @NotNull
    public MemoryCache getMemoryCache();

    @NotNull
    public BitmapPool getBitmapPool();

    @NotNull
    public Disposable enqueue(@NotNull ImageRequest var1);

    @Nullable
    public Object execute(@NotNull ImageRequest var1, @NotNull Continuation<? super ImageResult> var2);

    public void shutdown();

    @NotNull
    public Builder newBuilder();

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static ImageLoader create(@NotNull Context context) {
        return Companion.create(context);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\rJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\rJ\u0010\u0010\t\u001a\u00020\u00002\b\b\u0001\u0010!\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#J\u0010\u0010\u000b\u001a\u00020\u00002\b\b\u0001\u0010!\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\rJ\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u000fH\u0002J\b\u0010'\u001a\u00020\u0019H\u0002J\u0014\u0010\u000e\u001a\u00020\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0)J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0011J%\u0010\u0010\u001a\u00020\u00002\u0017\u0010+\u001a\u0013\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,\u00a2\u0006\u0002\b/H\u0086\b\u00f8\u0001\u0000J\u000e\u00100\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\rJ\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020\u00002\u0006\u00106\u001a\u000207J\u0010\u00108\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010:J\u0010\u00108\u001a\u00020\u00002\b\b\u0001\u0010;\u001a\u000202J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020>J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u0015J\u0010\u0010@\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010:J\u0010\u0010@\u001a\u00020\u00002\b\b\u0001\u0010;\u001a\u000202J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\rJ\u0010\u0010\u0016\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020BJ\u000e\u0010C\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u000e\u0010D\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u000e\u0010E\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\rJ\u0014\u0010F\u001a\u00020\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020G0)J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010F\u001a\u00020GJ\u0010\u0010H\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010:J\u0010\u0010H\u001a\u00020\u00002\b\b\u0001\u0010;\u001a\u000202J\u000e\u0010I\u001a\u00020\u00002\u0006\u0010I\u001a\u00020JJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\rJ\u0010\u0010K\u001a\u00020\u00002\u0006\u0010K\u001a\u00020LH\u0007R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006M"}, d2={"Lcoil/ImageLoader$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "imageLoader", "Lcoil/RealImageLoader;", "(Lcoil/RealImageLoader;)V", "applicationContext", "availableMemoryPercentage", "", "bitmapPoolPercentage", "bitmapPoolingEnabled", "", "callFactory", "Lokhttp3/Call$Factory;", "componentRegistry", "Lcoil/ComponentRegistry;", "defaults", "Lcoil/request/DefaultRequestOptions;", "eventListenerFactory", "Lcoil/EventListener$Factory;", "logger", "Lcoil/util/Logger;", "memoryCache", "Lcoil/memory/RealMemoryCache;", "options", "Lcoil/util/ImageLoaderOptions;", "trackWeakReferences", "addLastModifiedToFileCacheKey", "enable", "allowHardware", "allowRgb565", "percent", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "build", "Lcoil/ImageLoader;", "buildDefaultCallFactory", "buildDefaultMemoryCache", "initializer", "Lkotlin/Function0;", "registry", "builder", "Lkotlin/Function1;", "Lcoil/ComponentRegistry$Builder;", "", "Lkotlin/ExtensionFunctionType;", "crossfade", "durationMillis", "", "diskCachePolicy", "policy", "Lcoil/request/CachePolicy;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "error", "drawable", "Landroid/graphics/drawable/Drawable;", "drawableResId", "eventListener", "listener", "Lcoil/EventListener;", "factory", "fallback", "launchInterceptorChainOnMainThread", "Lcoil/memory/MemoryCache;", "memoryCachePolicy", "networkCachePolicy", "networkObserverEnabled", "okHttpClient", "Lokhttp3/OkHttpClient;", "placeholder", "precision", "Lcoil/size/Precision;", "transition", "Lcoil/transition/Transition;", "coil-base_release"})
    public static final class Builder {
        @NotNull
        private final Context applicationContext;
        @NotNull
        private DefaultRequestOptions defaults;
        @Nullable
        private Call.Factory callFactory;
        @Nullable
        private EventListener.Factory eventListenerFactory;
        @Nullable
        private ComponentRegistry componentRegistry;
        @NotNull
        private ImageLoaderOptions options;
        @Nullable
        private Logger logger;
        @Nullable
        private RealMemoryCache memoryCache;
        private double availableMemoryPercentage;
        private double bitmapPoolPercentage;
        private boolean bitmapPoolingEnabled;
        private boolean trackWeakReferences;

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            this.applicationContext = context2;
            this.defaults = DefaultRequestOptions.INSTANCE;
            this.callFactory = null;
            this.eventListenerFactory = null;
            this.componentRegistry = null;
            this.options = new ImageLoaderOptions(false, false, false, 7, null);
            this.logger = null;
            this.memoryCache = null;
            this.availableMemoryPercentage = Utils.INSTANCE.getDefaultAvailableMemoryPercentage(this.applicationContext);
            this.bitmapPoolPercentage = Utils.INSTANCE.getDefaultBitmapPoolPercentage();
            this.bitmapPoolingEnabled = true;
            this.trackWeakReferences = true;
        }

        public Builder(@NotNull RealImageLoader imageLoader) {
            Intrinsics.checkNotNullParameter((Object)imageLoader, (String)"imageLoader");
            Context context = imageLoader.getContext().getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"imageLoader.context.applicationContext");
            this.applicationContext = context;
            this.defaults = imageLoader.getDefaults();
            this.callFactory = imageLoader.getCallFactory();
            this.eventListenerFactory = imageLoader.getEventListenerFactory();
            this.componentRegistry = imageLoader.getComponentRegistry();
            this.options = imageLoader.getOptions();
            this.logger = imageLoader.getLogger();
            this.memoryCache = imageLoader.getMemoryCache();
            this.availableMemoryPercentage = Utils.INSTANCE.getDefaultAvailableMemoryPercentage(this.applicationContext);
            this.bitmapPoolPercentage = Utils.INSTANCE.getDefaultBitmapPoolPercentage();
            this.bitmapPoolingEnabled = true;
            this.trackWeakReferences = true;
        }

        @NotNull
        public final Builder okHttpClient(@NotNull OkHttpClient okHttpClient) {
            Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
            return this.callFactory((Call.Factory)okHttpClient);
        }

        @NotNull
        public final Builder okHttpClient(@NotNull Function0<? extends OkHttpClient> initializer) {
            Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
            return this.callFactory(initializer);
        }

        @NotNull
        public final Builder callFactory(@NotNull Call.Factory callFactory) {
            Intrinsics.checkNotNullParameter((Object)callFactory, (String)"callFactory");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$callFactory_u24lambda_u2d0 = builder;
            boolean bl3 = false;
            $this$callFactory_u24lambda_u2d0.callFactory = callFactory;
            return builder;
        }

        @NotNull
        public final Builder callFactory(@NotNull Function0<? extends Call.Factory> initializer) {
            Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$callFactory_u24lambda_u2d1 = builder;
            boolean bl3 = false;
            $this$callFactory_u24lambda_u2d1.callFactory = -Extensions.lazyCallFactory(initializer);
            return builder;
        }

        public final /* synthetic */ Builder componentRegistry(Function1<? super ComponentRegistry.Builder, Unit> builder) {
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            boolean $i$f$componentRegistry = false;
            ComponentRegistry.Builder builder2 = new ComponentRegistry.Builder();
            boolean bl = false;
            boolean bl2 = false;
            builder.invoke((Object)builder2);
            return this.componentRegistry(builder2.build());
        }

        @NotNull
        public final Builder componentRegistry(@NotNull ComponentRegistry registry) {
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$componentRegistry_u24lambda_u2d2 = builder;
            boolean bl3 = false;
            $this$componentRegistry_u24lambda_u2d2.componentRegistry = registry;
            return builder;
        }

        @NotNull
        public final Builder memoryCache(@NotNull MemoryCache memoryCache) {
            Intrinsics.checkNotNullParameter((Object)memoryCache, (String)"memoryCache");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$memoryCache_u24lambda_u2d4 = builder;
            boolean bl3 = false;
            boolean bl4 = memoryCache instanceof RealMemoryCache;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Custom memory cache implementations are currently not supported.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$memoryCache_u24lambda_u2d4.memoryCache = (RealMemoryCache)memoryCache;
            return builder;
        }

        @NotNull
        public final Builder availableMemoryPercentage(@FloatRange(from=0.0, to=1.0) double percent) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$availableMemoryPercentage_u24lambda_u2d6 = builder;
            boolean bl3 = false;
            boolean bl4 = 0.0 <= percent ? percent <= 1.0 : false;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Percent must be in the range [0.0, 1.0].";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$availableMemoryPercentage_u24lambda_u2d6.availableMemoryPercentage = percent;
            $this$availableMemoryPercentage_u24lambda_u2d6.memoryCache = null;
            return builder;
        }

        @NotNull
        public final Builder bitmapPoolPercentage(@FloatRange(from=0.0, to=1.0) double percent) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$bitmapPoolPercentage_u24lambda_u2d8 = builder;
            boolean bl3 = false;
            boolean bl4 = 0.0 <= percent ? percent <= 1.0 : false;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Percent must be in the range [0.0, 1.0].";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$bitmapPoolPercentage_u24lambda_u2d8.bitmapPoolPercentage = percent;
            $this$bitmapPoolPercentage_u24lambda_u2d8.memoryCache = null;
            return builder;
        }

        @NotNull
        public final Builder dispatcher(@NotNull CoroutineDispatcher dispatcher) {
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$dispatcher_u24lambda_u2d9 = builder;
            boolean bl3 = false;
            $this$dispatcher_u24lambda_u2d9.defaults = DefaultRequestOptions.copy$default($this$dispatcher_u24lambda_u2d9.defaults, dispatcher, null, null, null, false, false, null, null, null, null, null, null, 4094, null);
            return builder;
        }

        @NotNull
        public final Builder allowHardware(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$allowHardware_u24lambda_u2d10 = builder;
            boolean bl3 = false;
            $this$allowHardware_u24lambda_u2d10.defaults = DefaultRequestOptions.copy$default($this$allowHardware_u24lambda_u2d10.defaults, null, null, null, null, enable, false, null, null, null, null, null, null, 4079, null);
            return builder;
        }

        @NotNull
        public final Builder allowRgb565(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$allowRgb565_u24lambda_u2d11 = builder;
            boolean bl3 = false;
            $this$allowRgb565_u24lambda_u2d11.defaults = DefaultRequestOptions.copy$default($this$allowRgb565_u24lambda_u2d11.defaults, null, null, null, null, false, enable, null, null, null, null, null, null, 4063, null);
            return builder;
        }

        @NotNull
        public final Builder addLastModifiedToFileCacheKey(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$addLastModifiedToFileCacheKey_u24lambda_u2d12 = builder;
            boolean bl3 = false;
            $this$addLastModifiedToFileCacheKey_u24lambda_u2d12.options = ImageLoaderOptions.copy$default($this$addLastModifiedToFileCacheKey_u24lambda_u2d12.options, enable, false, false, 6, null);
            return builder;
        }

        @NotNull
        public final Builder bitmapPoolingEnabled(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$bitmapPoolingEnabled_u24lambda_u2d13 = builder;
            boolean bl3 = false;
            $this$bitmapPoolingEnabled_u24lambda_u2d13.bitmapPoolingEnabled = enable;
            $this$bitmapPoolingEnabled_u24lambda_u2d13.memoryCache = null;
            return builder;
        }

        @NotNull
        public final Builder networkObserverEnabled(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$networkObserverEnabled_u24lambda_u2d14 = builder;
            boolean bl3 = false;
            $this$networkObserverEnabled_u24lambda_u2d14.options = ImageLoaderOptions.copy$default($this$networkObserverEnabled_u24lambda_u2d14.options, false, false, enable, 3, null);
            return builder;
        }

        @NotNull
        public final Builder trackWeakReferences(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$trackWeakReferences_u24lambda_u2d15 = builder;
            boolean bl3 = false;
            $this$trackWeakReferences_u24lambda_u2d15.trackWeakReferences = enable;
            $this$trackWeakReferences_u24lambda_u2d15.memoryCache = null;
            return builder;
        }

        @NotNull
        public final Builder launchInterceptorChainOnMainThread(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$launchInterceptorChainOnMainThread_u24lambda_u2d16 = builder;
            boolean bl3 = false;
            $this$launchInterceptorChainOnMainThread_u24lambda_u2d16.options = ImageLoaderOptions.copy$default($this$launchInterceptorChainOnMainThread_u24lambda_u2d16.options, false, enable, false, 5, null);
            return builder;
        }

        @NotNull
        public final Builder eventListener(@NotNull EventListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            return this.eventListener(EventListener.Factory.Companion.create(listener2));
        }

        @NotNull
        public final Builder eventListener(@NotNull EventListener.Factory factory) {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$eventListener_u24lambda_u2d17 = builder;
            boolean bl3 = false;
            $this$eventListener_u24lambda_u2d17.eventListenerFactory = factory;
            return builder;
        }

        @NotNull
        public final Builder crossfade(boolean enable) {
            return this.crossfade(enable ? 100 : 0);
        }

        @NotNull
        public final Builder crossfade(int durationMillis) {
            return this.transition(durationMillis > 0 ? (Transition)new CrossfadeTransition(durationMillis, false, 2, null) : Transition.NONE);
        }

        @ExperimentalCoilApi
        @NotNull
        public final Builder transition(@NotNull Transition transition2) {
            Intrinsics.checkNotNullParameter((Object)transition2, (String)"transition");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$transition_u24lambda_u2d18 = builder;
            boolean bl3 = false;
            $this$transition_u24lambda_u2d18.defaults = DefaultRequestOptions.copy$default($this$transition_u24lambda_u2d18.defaults, null, transition2, null, null, false, false, null, null, null, null, null, null, 4093, null);
            return builder;
        }

        @NotNull
        public final Builder precision(@NotNull Precision precision) {
            Intrinsics.checkNotNullParameter((Object)((Object)precision), (String)"precision");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$precision_u24lambda_u2d19 = builder;
            boolean bl3 = false;
            $this$precision_u24lambda_u2d19.defaults = DefaultRequestOptions.copy$default($this$precision_u24lambda_u2d19.defaults, null, null, precision, null, false, false, null, null, null, null, null, null, 4091, null);
            return builder;
        }

        @NotNull
        public final Builder bitmapConfig(@NotNull Bitmap.Config bitmapConfig) {
            Intrinsics.checkNotNullParameter((Object)bitmapConfig, (String)"bitmapConfig");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$bitmapConfig_u24lambda_u2d20 = builder;
            boolean bl3 = false;
            $this$bitmapConfig_u24lambda_u2d20.defaults = DefaultRequestOptions.copy$default($this$bitmapConfig_u24lambda_u2d20.defaults, null, null, null, bitmapConfig, false, false, null, null, null, null, null, null, 4087, null);
            return builder;
        }

        @NotNull
        public final Builder placeholder(@DrawableRes int drawableResId) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$placeholder_u24lambda_u2d21 = builder;
            boolean bl3 = false;
            $this$placeholder_u24lambda_u2d21.defaults = DefaultRequestOptions.copy$default($this$placeholder_u24lambda_u2d21.defaults, null, null, null, null, false, false, -Contexts.getDrawableCompat($this$placeholder_u24lambda_u2d21.applicationContext, drawableResId), null, null, null, null, null, 4031, null);
            return builder;
        }

        @NotNull
        public final Builder placeholder(@Nullable Drawable drawable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$placeholder_u24lambda_u2d22 = builder;
            boolean bl3 = false;
            $this$placeholder_u24lambda_u2d22.defaults = DefaultRequestOptions.copy$default($this$placeholder_u24lambda_u2d22.defaults, null, null, null, null, false, false, drawable, null, null, null, null, null, 4031, null);
            return builder;
        }

        @NotNull
        public final Builder error(@DrawableRes int drawableResId) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$error_u24lambda_u2d23 = builder;
            boolean bl3 = false;
            $this$error_u24lambda_u2d23.defaults = DefaultRequestOptions.copy$default($this$error_u24lambda_u2d23.defaults, null, null, null, null, false, false, null, -Contexts.getDrawableCompat($this$error_u24lambda_u2d23.applicationContext, drawableResId), null, null, null, null, 3967, null);
            return builder;
        }

        @NotNull
        public final Builder error(@Nullable Drawable drawable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$error_u24lambda_u2d24 = builder;
            boolean bl3 = false;
            $this$error_u24lambda_u2d24.defaults = DefaultRequestOptions.copy$default($this$error_u24lambda_u2d24.defaults, null, null, null, null, false, false, null, drawable, null, null, null, null, 3967, null);
            return builder;
        }

        @NotNull
        public final Builder fallback(@DrawableRes int drawableResId) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$fallback_u24lambda_u2d25 = builder;
            boolean bl3 = false;
            $this$fallback_u24lambda_u2d25.defaults = DefaultRequestOptions.copy$default($this$fallback_u24lambda_u2d25.defaults, null, null, null, null, false, false, null, null, -Contexts.getDrawableCompat($this$fallback_u24lambda_u2d25.applicationContext, drawableResId), null, null, null, 3839, null);
            return builder;
        }

        @NotNull
        public final Builder fallback(@Nullable Drawable drawable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$fallback_u24lambda_u2d26 = builder;
            boolean bl3 = false;
            $this$fallback_u24lambda_u2d26.defaults = DefaultRequestOptions.copy$default($this$fallback_u24lambda_u2d26.defaults, null, null, null, null, false, false, null, null, drawable, null, null, null, 3839, null);
            return builder;
        }

        @NotNull
        public final Builder memoryCachePolicy(@NotNull CachePolicy policy) {
            Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$memoryCachePolicy_u24lambda_u2d27 = builder;
            boolean bl3 = false;
            $this$memoryCachePolicy_u24lambda_u2d27.defaults = DefaultRequestOptions.copy$default($this$memoryCachePolicy_u24lambda_u2d27.defaults, null, null, null, null, false, false, null, null, null, policy, null, null, 3583, null);
            return builder;
        }

        @NotNull
        public final Builder diskCachePolicy(@NotNull CachePolicy policy) {
            Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$diskCachePolicy_u24lambda_u2d28 = builder;
            boolean bl3 = false;
            $this$diskCachePolicy_u24lambda_u2d28.defaults = DefaultRequestOptions.copy$default($this$diskCachePolicy_u24lambda_u2d28.defaults, null, null, null, null, false, false, null, null, null, null, policy, null, 3071, null);
            return builder;
        }

        @NotNull
        public final Builder networkCachePolicy(@NotNull CachePolicy policy) {
            Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$networkCachePolicy_u24lambda_u2d29 = builder;
            boolean bl3 = false;
            $this$networkCachePolicy_u24lambda_u2d29.defaults = DefaultRequestOptions.copy$default($this$networkCachePolicy_u24lambda_u2d29.defaults, null, null, null, null, false, false, null, null, null, null, null, policy, 2047, null);
            return builder;
        }

        @NotNull
        public final Builder logger(@Nullable Logger logger) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$logger_u24lambda_u2d30 = builder;
            boolean bl3 = false;
            $this$logger_u24lambda_u2d30.logger = logger;
            return builder;
        }

        @NotNull
        public final ImageLoader build() {
            Object object = this.memoryCache;
            RealMemoryCache memoryCache = object == null ? this.buildDefaultMemoryCache() : object;
            object = this.callFactory;
            Object object2 = object == null ? this.buildDefaultCallFactory() : object;
            object = this.eventListenerFactory;
            Object object3 = object == null ? EventListener.Factory.NONE : object;
            object = this.componentRegistry;
            return new RealImageLoader(this.applicationContext, this.defaults, memoryCache.getBitmapPool(), memoryCache, (Call.Factory)object2, (EventListener.Factory)object3, (ComponentRegistry)(object == null ? new ComponentRegistry() : object), this.options, this.logger);
        }

        private final Call.Factory buildDefaultCallFactory() {
            return -Extensions.lazyCallFactory((Function0<? extends Call.Factory>)((Function0)new Function0<Call.Factory>(this){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Call.Factory invoke() {
                    OkHttpClient okHttpClient = new OkHttpClient.Builder().cache(CoilUtils.createDefaultCache(Builder.access$getApplicationContext$p(this.this$0))).build();
                    Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"Builder()\n                .cache(CoilUtils.createDefaultCache(applicationContext))\n                .build()");
                    return (Call.Factory)okHttpClient;
                }
            }));
        }

        private final RealMemoryCache buildDefaultMemoryCache() {
            long availableMemorySize = Utils.INSTANCE.calculateAvailableMemorySize(this.applicationContext, this.availableMemoryPercentage);
            double bitmapPoolPercentage = this.bitmapPoolingEnabled ? this.bitmapPoolPercentage : 0.0;
            int bitmapPoolSize = (int)(bitmapPoolPercentage * (double)availableMemorySize);
            int memoryCacheSize = (int)(availableMemorySize - (long)bitmapPoolSize);
            BitmapPool bitmapPool = bitmapPoolSize == 0 ? (BitmapPool)new EmptyBitmapPool() : (BitmapPool)new RealBitmapPool(bitmapPoolSize, null, null, this.logger, 6, null);
            WeakMemoryCache weakMemoryCache = this.trackWeakReferences ? (WeakMemoryCache)new RealWeakMemoryCache(this.logger) : (WeakMemoryCache)EmptyWeakMemoryCache.INSTANCE;
            BitmapReferenceCounter referenceCounter = this.bitmapPoolingEnabled ? (BitmapReferenceCounter)new RealBitmapReferenceCounter(weakMemoryCache, bitmapPool, this.logger) : (BitmapReferenceCounter)EmptyBitmapReferenceCounter.INSTANCE;
            StrongMemoryCache strongMemoryCache = StrongMemoryCache.Companion.invoke(weakMemoryCache, referenceCounter, memoryCacheSize, this.logger);
            return new RealMemoryCache(strongMemoryCache, weakMemoryCache, referenceCounter, bitmapPool);
        }

        public static final /* synthetic */ Context access$getApplicationContext$p(Builder $this) {
            return $this.applicationContext;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0087\u0002\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcoil/ImageLoader$Companion;", "", "()V", "invoke", "Lcoil/ImageLoader;", "context", "Landroid/content/Context;", "create", "coil-base_release"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final ImageLoader create(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new Builder(context).build();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

