/*
 * Decompiled with CFR 0.152.
 */
package coil.request;

import coil.annotation.ExperimentalCoilApi;
import coil.request.Disposable;
import coil.target.ViewTarget;
import coil.util.-Extensions;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\n\u001a\u00020\u000bH\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lcoil/request/ViewTargetDisposable;", "Lcoil/request/Disposable;", "requestId", "Ljava/util/UUID;", "target", "Lcoil/target/ViewTarget;", "(Ljava/util/UUID;Lcoil/target/ViewTarget;)V", "isDisposed", "", "()Z", "await", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "coil-base_release"})
public final class ViewTargetDisposable
implements Disposable {
    @NotNull
    private final UUID requestId;
    @NotNull
    private final ViewTarget<?> target;

    public ViewTargetDisposable(@NotNull UUID requestId, @NotNull ViewTarget<?> target2) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter(target2, (String)"target");
        this.requestId = requestId;
        this.target = target2;
    }

    @Override
    public boolean isDisposed() {
        return !Intrinsics.areEqual((Object)-Extensions.getRequestManager(this.target.getView()).getCurrentRequestId(), (Object)this.requestId);
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        -Extensions.getRequestManager(this.target.getView()).clearCurrentRequest();
    }

    @Override
    @ExperimentalCoilApi
    @Nullable
    public Object await(@NotNull Continuation<? super Unit> $completion) {
        if (this.isDisposed()) {
            return Unit.INSTANCE;
        }
        Job job2 = -Extensions.getRequestManager(this.target.getView()).getCurrentRequestJob();
        if (job2 != null) {
            Object object = job2.join($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (null == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return null;
        }
        return Unit.INSTANCE;
    }
}

