/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import androidx.annotation.WorkerThread;
import coil.memory.HardwareBitmapService;
import coil.size.PixelSize;
import coil.size.Size;
import coil.util.Logger;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcoil/memory/LimitedFileDescriptorHardwareBitmapService;", "Lcoil/memory/HardwareBitmapService;", "()V", "FILE_DESCRIPTOR_CHECK_INTERVAL", "", "FILE_DESCRIPTOR_LIMIT", "MIN_SIZE_DIMENSION", "TAG", "", "decodesSinceLastFileDescriptorCheck", "fileDescriptorList", "Ljava/io/File;", "hasAvailableFileDescriptors", "", "allowHardware", "size", "Lcoil/size/Size;", "logger", "Lcoil/util/Logger;", "coil-base_release"})
final class LimitedFileDescriptorHardwareBitmapService
extends HardwareBitmapService {
    @NotNull
    public static final LimitedFileDescriptorHardwareBitmapService INSTANCE = new LimitedFileDescriptorHardwareBitmapService();
    @NotNull
    private static final String TAG = "LimitedFileDescriptorHardwareBitmapService";
    private static final int MIN_SIZE_DIMENSION = 75;
    private static final int FILE_DESCRIPTOR_LIMIT = 750;
    private static final int FILE_DESCRIPTOR_CHECK_INTERVAL = 50;
    @NotNull
    private static final File fileDescriptorList = new File("/proc/self/fd");
    private static volatile int decodesSinceLastFileDescriptorCheck;
    private static volatile boolean hasAvailableFileDescriptors;

    private LimitedFileDescriptorHardwareBitmapService() {
        super(null);
    }

    @Override
    public boolean allowHardware(@NotNull Size size2, @Nullable Logger logger) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        if (size2 instanceof PixelSize && (((PixelSize)size2).getWidth() < 75 || ((PixelSize)size2).getHeight() < 75)) {
            return false;
        }
        return this.hasAvailableFileDescriptors(logger);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final synchronized boolean hasAvailableFileDescriptors(Logger logger) {
        LimitedFileDescriptorHardwareBitmapService limitedFileDescriptorHardwareBitmapService = this;
        int n = decodesSinceLastFileDescriptorCheck;
        decodesSinceLastFileDescriptorCheck = n + 1;
        if (n >= 50) {
            decodesSinceLastFileDescriptorCheck = 0;
            String[] $this$orEmpty$iv = fileDescriptorList.list();
            boolean $i$f$orEmpty2 = false;
            String[] stringArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                stringArray = new String[]{};
            }
            Object object = stringArray;
            $i$f$orEmpty2 = false;
            int numUsedFileDescriptors = ((String[])object).length;
            boolean bl = hasAvailableFileDescriptors = numUsedFileDescriptors < 750;
            if (hasAvailableFileDescriptors && (object = logger) != null) {
                void $this$log$iv;
                Object $i$f$orEmpty2 = object;
                String string = TAG;
                int priority$iv = 5;
                boolean $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv) {
                    void tag$iv;
                    int n2 = priority$iv;
                    void var10_12 = tag$iv;
                    void var9_13 = $this$log$iv;
                    boolean bl2 = false;
                    String string2 = Intrinsics.stringPlus((String)"Unable to allocate more hardware bitmaps. Number of used file descriptors: ", (Object)numUsedFileDescriptors);
                    var9_13.log((String)var10_12, n2, string2, null);
                }
            }
        }
        return hasAvailableFileDescriptors;
    }

    static {
        hasAvailableFileDescriptors = true;
    }
}

