/*
 * Decompiled with CFR 0.152.
 */
package coil.bitmap;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import androidx.collection.SparseArrayCompat;
import coil.bitmap.BitmapPool;
import coil.bitmap.BitmapReferenceCounter;
import coil.memory.WeakMemoryCache;
import coil.util.Logger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 %2\u00020\u0001:\u0002%&B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u00132\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\n8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\f\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcoil/bitmap/RealBitmapReferenceCounter;", "Lcoil/bitmap/BitmapReferenceCounter;", "weakMemoryCache", "Lcoil/memory/WeakMemoryCache;", "bitmapPool", "Lcoil/bitmap/BitmapPool;", "logger", "Lcoil/util/Logger;", "(Lcoil/memory/WeakMemoryCache;Lcoil/bitmap/BitmapPool;Lcoil/util/Logger;)V", "operationsSinceCleanUp", "", "getOperationsSinceCleanUp$coil_base_release$annotations", "()V", "getOperationsSinceCleanUp$coil_base_release", "()I", "setOperationsSinceCleanUp$coil_base_release", "(I)V", "values", "Landroidx/collection/SparseArrayCompat;", "Lcoil/bitmap/RealBitmapReferenceCounter$Value;", "getValues$coil_base_release$annotations", "getValues$coil_base_release", "()Landroidx/collection/SparseArrayCompat;", "cleanUp", "", "cleanUp$coil_base_release", "cleanUpIfNecessary", "decrement", "", "bitmap", "Landroid/graphics/Bitmap;", "getValue", "key", "getValueOrNull", "increment", "setValid", "isValid", "Companion", "Value", "coil-base_release"})
public final class RealBitmapReferenceCounter
implements BitmapReferenceCounter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WeakMemoryCache weakMemoryCache;
    @NotNull
    private final BitmapPool bitmapPool;
    @Nullable
    private final Logger logger;
    @NotNull
    private final SparseArrayCompat<Value> values;
    private int operationsSinceCleanUp;
    @NotNull
    private static final String TAG = "RealBitmapReferenceCounter";
    private static final int CLEAN_UP_INTERVAL = 50;
    @NotNull
    private static final Handler MAIN_HANDLER = new Handler(Looper.getMainLooper());

    public RealBitmapReferenceCounter(@NotNull WeakMemoryCache weakMemoryCache, @NotNull BitmapPool bitmapPool, @Nullable Logger logger) {
        Intrinsics.checkNotNullParameter((Object)weakMemoryCache, (String)"weakMemoryCache");
        Intrinsics.checkNotNullParameter((Object)bitmapPool, (String)"bitmapPool");
        this.weakMemoryCache = weakMemoryCache;
        this.bitmapPool = bitmapPool;
        this.logger = logger;
        this.values = new SparseArrayCompat();
    }

    @NotNull
    public final SparseArrayCompat<Value> getValues$coil_base_release() {
        return this.values;
    }

    @VisibleForTesting
    public static /* synthetic */ void getValues$coil_base_release$annotations() {
    }

    public final int getOperationsSinceCleanUp$coil_base_release() {
        return this.operationsSinceCleanUp;
    }

    public final void setOperationsSinceCleanUp$coil_base_release(int n) {
        this.operationsSinceCleanUp = n;
    }

    @VisibleForTesting
    public static /* synthetic */ void getOperationsSinceCleanUp$coil_base_release$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void increment(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Bitmap $this$identityHashCode$iv = bitmap;
        boolean $i$f$getIdentityHashCode = false;
        int key = System.identityHashCode($this$identityHashCode$iv);
        Value value = this.getValue(key, bitmap);
        Object object = value;
        int n = ((Value)object).getCount();
        ((Value)object).setCount(n + 1);
        object = this.logger;
        if (object != null) {
            void $this$log$iv;
            Object object2 = object;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n2 = priority$iv;
                void var11_12 = tag$iv;
                void var10_13 = $this$log$iv;
                boolean bl = false;
                String string2 = "INCREMENT: [" + key + ", " + value.getCount() + ", " + value.isValid() + ']';
                var10_13.log((String)var11_12, n2, string2, null);
            }
        }
        this.cleanUpIfNecessary();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean decrement(@NotNull Bitmap bitmap) {
        boolean removed;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Bitmap $this$identityHashCode$iv = bitmap;
        boolean $i$f$getIdentityHashCode22 = false;
        int key = System.identityHashCode($this$identityHashCode$iv);
        Object $i$f$getIdentityHashCode22 = this.getValueOrNull(key, bitmap);
        if ($i$f$getIdentityHashCode22 == null) {
            RealBitmapReferenceCounter realBitmapReferenceCounter = this;
            boolean bl = false;
            boolean bl2 = false;
            RealBitmapReferenceCounter $this$decrement_u24lambda_u2d2 = realBitmapReferenceCounter;
            boolean bl3 = false;
            Logger logger = $this$decrement_u24lambda_u2d2.logger;
            if (logger != null) {
                void $this$log$iv;
                Logger logger2 = logger;
                String string = TAG;
                int priority$iv = 2;
                boolean $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv) {
                    void tag$iv;
                    int n = priority$iv;
                    void var16_24 = tag$iv;
                    void var17_25 = $this$log$iv;
                    boolean bl4 = false;
                    String string2 = "DECREMENT: [" + key + ", UNKNOWN, UNKNOWN]";
                    var17_25.log((String)var16_24, n, string2, null);
                }
            }
            return false;
        }
        Value value = $i$f$getIdentityHashCode22;
        $i$f$getIdentityHashCode22 = value;
        int n = ((Value)$i$f$getIdentityHashCode22).getCount();
        ((Value)$i$f$getIdentityHashCode22).setCount(n + -1);
        $i$f$getIdentityHashCode22 = this.logger;
        if ($i$f$getIdentityHashCode22 != null) {
            void $this$log$iv;
            Object object = $i$f$getIdentityHashCode22;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n2 = priority$iv;
                void var21_29 = tag$iv;
                void var20_30 = $this$log$iv;
                boolean bl = false;
                String string3 = "DECREMENT: [" + key + ", " + value.getCount() + ", " + value.isValid() + ']';
                var20_30.log((String)var21_29, n2, string3, null);
            }
        }
        boolean bl = removed = value.getCount() <= 0 && value.isValid();
        if (removed) {
            this.values.remove(key);
            this.weakMemoryCache.remove(bitmap);
            MAIN_HANDLER.post(new Runnable(this, bitmap){
                final /* synthetic */ RealBitmapReferenceCounter this$0;
                final /* synthetic */ Bitmap $bitmap;
                {
                    this.this$0 = $receiver;
                    this.$bitmap = $bitmap;
                }

                public final void run() {
                    RealBitmapReferenceCounter.access$getBitmapPool$p(this.this$0).put(this.$bitmap);
                }
            });
        }
        this.cleanUpIfNecessary();
        return removed;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setValid(@NotNull Bitmap bitmap, boolean isValid) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Bitmap $this$identityHashCode$iv = bitmap;
        boolean $i$f$getIdentityHashCode2 = false;
        int key = System.identityHashCode($this$identityHashCode$iv);
        if (isValid) {
            value = this.getValueOrNull(key, bitmap);
            if (value == null) {
                void $receiver$iv;
                SparseArrayCompat<Value> $i$f$getIdentityHashCode2 = this.values;
                Value value$iv = new Value(new WeakReference<Bitmap>(bitmap), 0, true);
                boolean $i$f$set = false;
                $receiver$iv.put(key, (Object)value$iv);
            }
        } else {
            value = this.getValue(key, bitmap);
            value.setValid(false);
        }
        this.cleanUpIfNecessary();
    }

    private final void cleanUpIfNecessary() {
        RealBitmapReferenceCounter realBitmapReferenceCounter = this;
        int n = realBitmapReferenceCounter.operationsSinceCleanUp;
        realBitmapReferenceCounter.operationsSinceCleanUp = n + 1;
        if (n >= 50) {
            this.cleanUp$coil_base_release();
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void cleanUp$coil_base_release() {
        void $this$forEachIndices$iv;
        int n = 0;
        ArrayList toRemove = new ArrayList();
        n = 0;
        SparseArrayCompat<Value> $receiver$iv = this.values;
        boolean $i$f$getSize = false;
        int n2 = $receiver$iv.size();
        if (n < n2) {
            do {
                int index;
                Value value;
                if ((value = (Value)this.values.valueAt(index = n++)).getBitmap().get() != null) continue;
                Collection collection = toRemove;
                Integer n3 = index;
                boolean bl = false;
                collection.add(n3);
            } while (n < n2);
        }
        List list = toRemove;
        SparseArrayCompat<Value> sparseArrayCompat = this.values;
        boolean $i$f$forEachIndices = false;
        int n4 = 0;
        int n5 = $this$forEachIndices$iv.size() + -1;
        if (n4 <= n5) {
            do {
                int i$iv = n4++;
                int p0 = ((Number)$this$forEachIndices$iv.get(i$iv)).intValue();
                boolean bl = false;
                sparseArrayCompat.removeAt(p0);
            } while (n4 <= n5);
        }
    }

    private final Value getValue(int key, Bitmap bitmap) {
        Value value = this.getValueOrNull(key, bitmap);
        if (value == null) {
            value = new Value(new WeakReference<Bitmap>(bitmap), 0, false);
            SparseArrayCompat<Value> $receiver$iv = this.values;
            boolean $i$f$set = false;
            $receiver$iv.put(key, (Object)value);
        }
        return value;
    }

    private final Value getValueOrNull(int key, Bitmap bitmap) {
        Value value;
        Value value2 = (Value)this.values.get(key);
        if (value2 == null) {
            value = null;
        } else {
            Value value3 = value2;
            boolean bl = false;
            boolean bl2 = false;
            Value it = value3;
            boolean bl3 = false;
            value = it.getBitmap().get() == bitmap ? value3 : null;
        }
        return value;
    }

    public static final /* synthetic */ BitmapPool access$getBitmapPool$p(RealBitmapReferenceCounter $this) {
        return $this.bitmapPool;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0001\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcoil/bitmap/RealBitmapReferenceCounter$Value;", "", "bitmap", "Ljava/lang/ref/WeakReference;", "Landroid/graphics/Bitmap;", "count", "", "isValid", "", "(Ljava/lang/ref/WeakReference;IZ)V", "getBitmap", "()Ljava/lang/ref/WeakReference;", "getCount", "()I", "setCount", "(I)V", "()Z", "setValid", "(Z)V", "coil-base_release"})
    @VisibleForTesting
    public static final class Value {
        @NotNull
        private final WeakReference<Bitmap> bitmap;
        private int count;
        private boolean isValid;

        public Value(@NotNull WeakReference<Bitmap> bitmap, int count, boolean isValid) {
            Intrinsics.checkNotNullParameter(bitmap, (String)"bitmap");
            this.bitmap = bitmap;
            this.count = count;
            this.isValid = isValid;
        }

        @NotNull
        public final WeakReference<Bitmap> getBitmap() {
            return this.bitmap;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public final boolean isValid() {
            return this.isValid;
        }

        public final void setValid(boolean bl) {
            this.isValid = bl;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcoil/bitmap/RealBitmapReferenceCounter$Companion;", "", "()V", "CLEAN_UP_INTERVAL", "", "MAIN_HANDLER", "Landroid/os/Handler;", "TAG", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

