/*
 * Decompiled with CFR 0.152.
 */
package coil.util;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.StatFs;
import androidx.annotation.Px;
import androidx.core.content.ContextCompat;
import coil.util.-Bitmaps;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0013\u001a\u00020\u00102\b\b\u0001\u0010\u0014\u001a\u00020\u00102\b\b\u0001\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001f\u001a\u00020\nJ\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcoil/util/Utils;", "", "()V", "CACHE_DIRECTORY_NAME", "", "DEFAULT_BITMAP_CONFIG", "Landroid/graphics/Bitmap$Config;", "getDEFAULT_BITMAP_CONFIG", "()Landroid/graphics/Bitmap$Config;", "DISK_CACHE_PERCENTAGE", "", "LOW_MEMORY_MULTIPLIER", "MAX_DISK_CACHE_SIZE", "", "MIN_DISK_CACHE_SIZE", "REQUEST_TYPE_ENQUEUE", "", "REQUEST_TYPE_EXECUTE", "STANDARD_MULTIPLIER", "calculateAllocationByteCount", "width", "height", "config", "calculateAvailableMemorySize", "context", "Landroid/content/Context;", "percentage", "calculateDiskCacheSize", "cacheDirectory", "Ljava/io/File;", "getDefaultAvailableMemoryPercentage", "getDefaultBitmapPoolPercentage", "getDefaultCacheDirectory", "coil-base_release"})
public final class Utils {
    private static final String CACHE_DIRECTORY_NAME = "image_cache";
    private static final long MIN_DISK_CACHE_SIZE = 0xA00000L;
    private static final long MAX_DISK_CACHE_SIZE = 0xFA00000L;
    private static final double DISK_CACHE_PERCENTAGE = 0.02;
    private static final double STANDARD_MULTIPLIER = 0.2;
    private static final double LOW_MEMORY_MULTIPLIER = 0.15;
    public static final int REQUEST_TYPE_ENQUEUE = 0;
    public static final int REQUEST_TYPE_EXECUTE = 1;
    public static final Utils INSTANCE;

    @NotNull
    public final Bitmap.Config getDEFAULT_BITMAP_CONFIG() {
        return Build.VERSION.SDK_INT >= 26 ? Bitmap.Config.HARDWARE : Bitmap.Config.ARGB_8888;
    }

    public final int calculateAllocationByteCount(@Px int width, @Px int height, @Nullable Bitmap.Config config) {
        return width * height * -Bitmaps.getBytesPerPixel(config);
    }

    @NotNull
    public final File getDefaultCacheDirectory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File file = new File(context.getCacheDir(), CACHE_DIRECTORY_NAME);
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        $this$apply.mkdirs();
        return file;
    }

    public final long calculateDiskCacheSize(@NotNull File cacheDirectory) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        try {
            StatFs cacheDir;
            StatFs $this$blockCountCompat$iv = cacheDir = new StatFs(cacheDirectory.getAbsolutePath());
            boolean $i$f$getBlockCountCompat = false;
            StatFs $this$blockSizeCompat$iv = cacheDir;
            boolean $i$f$getBlockSizeCompat = false;
            double size = 0.02 * (double)(Build.VERSION.SDK_INT >= 18 ? $this$blockCountCompat$iv.getBlockCountLong() : (long)$this$blockCountCompat$iv.getBlockCount()) * (double)(Build.VERSION.SDK_INT >= 18 ? $this$blockSizeCompat$iv.getBlockSizeLong() : (long)$this$blockSizeCompat$iv.getBlockSize());
            return RangesKt.coerceIn((long)((long)size), (long)0xA00000L, (long)0xFA00000L);
        }
        catch (Exception _) {
            long l = 0xA00000L;
            return l;
        }
    }

    public final long calculateAvailableMemorySize(@NotNull Context context, double percentage) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context $this$requireSystemService$iv = context;
        boolean $i$f$requireSystemService = false;
        Context $this$getSystemService$iv$iv = $this$requireSystemService$iv;
        boolean $i$f$getSystemService = false;
        Object object = ContextCompat.getSystemService((Context)$this$getSystemService$iv$iv, ActivityManager.class);
        boolean bl = false;
        boolean bl2 = false;
        if (object == null) {
            boolean bl3 = false;
            String string = "System service of type " + ActivityManager.class + " was not found.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ActivityManager activityManager = (ActivityManager)object;
        boolean isLargeHeap = (context.getApplicationInfo().flags & 0x100000) != 0;
        int memoryClassMegabytes = isLargeHeap ? activityManager.getLargeMemoryClass() : activityManager.getMemoryClass();
        return (long)(percentage * (double)memoryClassMegabytes * (double)1024 * (double)1024);
    }

    public final double getDefaultAvailableMemoryPercentage(@NotNull Context context) {
        ActivityManager activityManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context $this$requireSystemService$iv = context;
        boolean $i$f$requireSystemService = false;
        Context $this$getSystemService$iv$iv = $this$requireSystemService$iv;
        boolean $i$f$getSystemService = false;
        Object object = ContextCompat.getSystemService((Context)$this$getSystemService$iv$iv, ActivityManager.class);
        boolean bl = false;
        boolean bl2 = false;
        if (object == null) {
            boolean bl3 = false;
            String string = "System service of type " + ActivityManager.class + " was not found.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ActivityManager $this$isLowRamDeviceCompat$iv = activityManager = (ActivityManager)object;
        boolean $i$f$isLowRamDeviceCompat = false;
        return Build.VERSION.SDK_INT < 19 || $this$isLowRamDeviceCompat$iv.isLowRamDevice() ? 0.15 : 0.2;
    }

    public final double getDefaultBitmapPoolPercentage() {
        return Build.VERSION.SDK_INT >= 24 ? 0.0 : (Build.VERSION.SDK_INT >= 19 ? 0.5 : 0.25);
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

