/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.webkit.MimeTypeMap;
import androidx.annotation.VisibleForTesting;
import coil.bitmap.BitmapPool;
import coil.decode.DataSource;
import coil.decode.Options;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.HttpFetcher;
import coil.fetch.SourceResult;
import coil.network.HttpException;
import coil.size.Size;
import coil.util.-Extensions;
import coil.util.ContinuationCallback;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000 \u0019*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0019B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J1\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b\u0016J\u0011\u0010\u0017\u001a\u00020\u0013*\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcoil/fetch/HttpFetcher;", "T", "", "Lcoil/fetch/Fetcher;", "callFactory", "Lokhttp3/Call$Factory;", "(Lokhttp3/Call$Factory;)V", "fetch", "Lcoil/fetch/FetchResult;", "pool", "Lcoil/bitmap/BitmapPool;", "data", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmap/BitmapPool;Ljava/lang/Object;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMimeType", "", "Lokhttp3/HttpUrl;", "body", "Lokhttp3/ResponseBody;", "getMimeType$coil_base_release", "toHttpUrl", "(Ljava/lang/Object;)Lokhttp3/HttpUrl;", "Companion", "coil-base_release"})
public abstract class HttpFetcher<T>
implements Fetcher<T> {
    private final Call.Factory callFactory;
    private static final String MIME_TYPE_TEXT_PLAIN = "text/plain";
    private static final CacheControl CACHE_CONTROL_FORCE_NETWORK_NO_CACHE;
    private static final CacheControl CACHE_CONTROL_NO_NETWORK_NO_CACHE;
    public static final Companion Companion;

    @NotNull
    public abstract HttpUrl toHttpUrl(@NotNull T var1);

    @Override
    @Nullable
    public Object fetch(@NotNull BitmapPool bitmapPool, @NotNull T t, @NotNull Size size, @NotNull Options options, @NotNull Continuation<? super FetchResult> $completion) {
        return HttpFetcher.fetch$suspendImpl(this, bitmapPool, t, size, options, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object fetch$suspendImpl(HttpFetcher this, BitmapPool pool, Object data, Size size, Options options, Continuation $completion) {
        if (!($completion instanceof fetch.1)) ** GOTO lbl-1000
        var21_6 = $completion;
        if ((var21_6.label & -2147483648) != 0) {
            var21_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ HttpFetcher this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                boolean Z$0;
                boolean Z$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpFetcher.fetch$suspendImpl(this.this$0, null, null, null, null, (Continuation)this);
                }
                {
                    this.this$0 = httpFetcher;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var22_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                url = this.toHttpUrl(data);
                request = new Request.Builder().url(url).headers(options.getHeaders());
                networkRead = options.getNetworkCachePolicy().getReadEnabled();
                diskRead = options.getDiskCachePolicy().getReadEnabled();
                if (!networkRead && diskRead) {
                    request.cacheControl(CacheControl.FORCE_CACHE);
                } else if (networkRead && !diskRead) {
                    if (options.getDiskCachePolicy().getWriteEnabled()) {
                        request.cacheControl(CacheControl.FORCE_NETWORK);
                    } else {
                        request.cacheControl(HttpFetcher.CACHE_CONTROL_FORCE_NETWORK_NO_CACHE);
                    }
                } else if (!networkRead && !diskRead) {
                    request.cacheControl(HttpFetcher.CACHE_CONTROL_NO_NETWORK_NO_CACHE);
                }
                v0 = this.callFactory.newCall(request.build());
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"callFactory.newCall(request.build())");
                $this$await$iv = v0;
                $i$f$await = false;
                $i$f$suspendCancellableCoroutine = false;
                $continuation.L$0 = this;
                $continuation.L$1 = pool;
                $continuation.L$2 = data;
                $continuation.L$3 = size;
                $continuation.L$4 = options;
                $continuation.L$5 = url;
                $continuation.L$6 = request;
                $continuation.Z$0 = networkRead;
                $continuation.Z$1 = diskRead;
                $continuation.L$7 = $this$await$iv;
                $continuation.label = 1;
                uCont$iv$iv = $continuation;
                $i$a$-suspendCoroutineUninterceptedOrReturn-CancellableContinuationKt$suspendCancellableCoroutine$2$iv$iv = false;
                cancellable$iv$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv$iv), 1);
                cancellable$iv$iv.initCancellability();
                continuation$iv = (CancellableContinuation)cancellable$iv$iv;
                $i$a$-suspendCancellableCoroutine--Calls$await$2$iv = false;
                callback$iv = new ContinuationCallback($this$await$iv, (CancellableContinuation<? super Response>)continuation$iv);
                $this$await$iv.enqueue((Callback)callback$iv);
                continuation$iv.invokeOnCancellation((Function1)callback$iv);
                v1 = cancellable$iv$iv.getResult();
                if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)$continuation);
                }
                v2 = v1;
                if (v1 == var22_8) {
                    return var22_8;
                }
                ** GOTO lbl81
            }
            case 1: {
                $this$await$iv = (Call)$continuation.L$7;
                diskRead = $continuation.Z$1;
                networkRead = $continuation.Z$0;
                request = (Request.Builder)$continuation.L$6;
                url = (HttpUrl)$continuation.L$5;
                options = (Options)$continuation.L$4;
                size = (Size)$continuation.L$3;
                data = $continuation.L$2;
                pool = (BitmapPool)$continuation.L$1;
                this = (HttpFetcher)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl81:
                // 2 sources

                response = (Response)v2;
                if (!response.isSuccessful()) {
                    throw (Throwable)new HttpException(response);
                }
                var12_18 = response.body();
                var13_19 = false;
                var14_21 = false;
                if (var12_18 == null) {
                    $i$a$-checkNotNull-HttpFetcher$fetch$body$1 = false;
                    var14_22 = "Null response body!";
                    throw (Throwable)new IllegalStateException(var14_22.toString());
                }
                body = var12_18;
                v3 = body.source();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"body.source()");
                return new SourceResult(v3, this.getMimeType$coil_base_release(url, body), response.cacheResponse() != null ? DataSource.DISK : DataSource.NETWORK);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @VisibleForTesting
    @Nullable
    public final String getMimeType$coil_base_release(@NotNull HttpUrl data, @NotNull ResponseBody body) {
        String rawContentType;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        MediaType mediaType = body.contentType();
        String string = rawContentType = mediaType != null ? mediaType.toString() : null;
        if (rawContentType == null || StringsKt.startsWith$default((String)rawContentType, (String)MIME_TYPE_TEXT_PLAIN, (boolean)false, (int)2, null)) {
            MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
            Intrinsics.checkNotNullExpressionValue((Object)mimeTypeMap, (String)"MimeTypeMap.getSingleton()");
            String string2 = -Extensions.getMimeTypeFromUrl(mimeTypeMap, data.toString());
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                return it;
            }
        }
        String string4 = rawContentType;
        return string4 != null ? StringsKt.substringBefore$default((String)string4, (char)';', null, (int)2, null) : null;
    }

    public HttpFetcher(@NotNull Call.Factory callFactory) {
        Intrinsics.checkNotNullParameter((Object)callFactory, (String)"callFactory");
        this.callFactory = callFactory;
    }

    static {
        Companion = new Companion(null);
        CACHE_CONTROL_FORCE_NETWORK_NO_CACHE = new CacheControl.Builder().noCache().noStore().build();
        CACHE_CONTROL_NO_NETWORK_NO_CACHE = new CacheControl.Builder().noCache().onlyIfCached().build();
    }

    @Override
    public boolean handles(@NotNull T data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return Fetcher.DefaultImpls.handles(this, data);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcoil/fetch/HttpFetcher$Companion;", "", "()V", "CACHE_CONTROL_FORCE_NETWORK_NO_CACHE", "Lokhttp3/CacheControl;", "kotlin.jvm.PlatformType", "CACHE_CONTROL_NO_NETWORK_NO_CACHE", "MIME_TYPE_TEXT_PLAIN", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

