/*
 * Decompiled with CFR 0.152.
 */
package coil;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import coil.ComponentRegistry;
import coil.EventListener;
import coil.RealImageLoader;
import coil.annotation.ExperimentalCoilApi;
import coil.bitmap.BitmapPool;
import coil.bitmap.BitmapReferenceCounter;
import coil.bitmap.EmptyBitmapReferenceCounter;
import coil.bitmap.RealBitmapPool;
import coil.bitmap.RealBitmapReferenceCounter;
import coil.memory.EmptyWeakMemoryCache;
import coil.memory.MemoryCache;
import coil.memory.RealWeakMemoryCache;
import coil.memory.StrongMemoryCache;
import coil.memory.WeakMemoryCache;
import coil.request.CachePolicy;
import coil.request.DefaultRequestOptions;
import coil.request.Disposable;
import coil.request.ImageRequest;
import coil.request.ImageResult;
import coil.size.Precision;
import coil.transition.CrossfadeTransition;
import coil.transition.Transition;
import coil.util.-Contexts;
import coil.util.-Extensions;
import coil.util.CoilUtils;
import coil.util.Logger;
import coil.util.Utils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0019\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lcoil/ImageLoader;", "", "bitmapPool", "Lcoil/bitmap/BitmapPool;", "getBitmapPool", "()Lcoil/bitmap/BitmapPool;", "defaults", "Lcoil/request/DefaultRequestOptions;", "getDefaults", "()Lcoil/request/DefaultRequestOptions;", "memoryCache", "Lcoil/memory/MemoryCache;", "getMemoryCache", "()Lcoil/memory/MemoryCache;", "enqueue", "Lcoil/request/Disposable;", "request", "Lcoil/request/ImageRequest;", "execute", "Lcoil/request/ImageResult;", "(Lcoil/request/ImageRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shutdown", "", "Builder", "Companion", "coil-base_release"})
public interface ImageLoader {
    public static final Companion Companion = coil.ImageLoader$Companion.$$INSTANCE;

    @NotNull
    public DefaultRequestOptions getDefaults();

    @NotNull
    public MemoryCache getMemoryCache();

    @NotNull
    public BitmapPool getBitmapPool();

    @NotNull
    public Disposable enqueue(@NotNull ImageRequest var1);

    @Nullable
    public Object execute(@NotNull ImageRequest var1, @NotNull Continuation<? super ImageResult> var2);

    public void shutdown();

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static ImageLoader create(@NotNull Context context) {
        return Companion.create(context);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0006J\u0010\u0010\t\u001a\u00020\u00002\b\b\u0001\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u000b\u001a\u00020\u00002\b\b\u0001\u0010\u001c\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0006J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u000eH\u0002J\u0014\u0010\r\u001a\u00020\u00002\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0#J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J%\u0010$\u001a\u00020\u00002\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&\u00a2\u0006\u0002\b)H\u0086\b\u00f8\u0001\u0000J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020\u00002\b\u00103\u001a\u0004\u0018\u000104J\u0010\u00102\u001a\u00020\u00002\b\b\u0001\u00105\u001a\u00020,J\u0010\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u000208H\u0007J\u0010\u00106\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0012H\u0007J\u0010\u0010:\u001a\u00020\u00002\b\u00103\u001a\u0004\u0018\u000104J\u0010\u0010:\u001a\u00020\u00002\b\b\u0001\u00105\u001a\u00020,J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0006J\u0010\u0010\u0014\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/J\u0014\u0010=\u001a\u00020\u00002\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020>0#J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010=\u001a\u00020>J\u0010\u0010?\u001a\u00020\u00002\b\u00103\u001a\u0004\u0018\u000104J\u0010\u0010?\u001a\u00020\u00002\b\b\u0001\u00105\u001a\u00020,J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010@\u001a\u00020AJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0006J\u0010\u0010B\u001a\u00020\u00002\u0006\u0010B\u001a\u00020CH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006D"}, d2={"Lcoil/ImageLoader$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "addLastModifiedToFileCacheKey", "", "applicationContext", "kotlin.jvm.PlatformType", "availableMemoryPercentage", "", "bitmapPoolPercentage", "bitmapPoolingEnabled", "callFactory", "Lokhttp3/Call$Factory;", "defaults", "Lcoil/request/DefaultRequestOptions;", "eventListenerFactory", "Lcoil/EventListener$Factory;", "launchInterceptorChainOnMainThread", "logger", "Lcoil/util/Logger;", "registry", "Lcoil/ComponentRegistry;", "trackWeakReferences", "enable", "allowHardware", "allowRgb565", "percent", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "build", "Lcoil/ImageLoader;", "buildDefaultCallFactory", "initializer", "Lkotlin/Function0;", "componentRegistry", "builder", "Lkotlin/Function1;", "Lcoil/ComponentRegistry$Builder;", "", "Lkotlin/ExtensionFunctionType;", "crossfade", "durationMillis", "", "diskCachePolicy", "policy", "Lcoil/request/CachePolicy;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "error", "drawable", "Landroid/graphics/drawable/Drawable;", "drawableResId", "eventListener", "listener", "Lcoil/EventListener;", "factory", "fallback", "memoryCachePolicy", "networkCachePolicy", "okHttpClient", "Lokhttp3/OkHttpClient;", "placeholder", "precision", "Lcoil/size/Precision;", "transition", "Lcoil/transition/Transition;", "coil-base_release"})
    public static final class Builder {
        private final Context applicationContext;
        private Call.Factory callFactory;
        private EventListener.Factory eventListenerFactory;
        private ComponentRegistry registry;
        private Logger logger;
        private DefaultRequestOptions defaults;
        private double availableMemoryPercentage;
        private double bitmapPoolPercentage;
        private boolean addLastModifiedToFileCacheKey;
        private boolean bitmapPoolingEnabled;
        private boolean launchInterceptorChainOnMainThread;
        private boolean trackWeakReferences;

        @NotNull
        public final Builder okHttpClient(@NotNull OkHttpClient okHttpClient) {
            Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
            return this.callFactory((Call.Factory)okHttpClient);
        }

        @NotNull
        public final Builder okHttpClient(@NotNull Function0<? extends OkHttpClient> initializer) {
            Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
            return this.callFactory(initializer);
        }

        @NotNull
        public final Builder callFactory(@NotNull Call.Factory callFactory) {
            Intrinsics.checkNotNullParameter((Object)callFactory, (String)"callFactory");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.callFactory = callFactory;
            return builder;
        }

        @NotNull
        public final Builder callFactory(@NotNull Function0<? extends Call.Factory> initializer) {
            Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.callFactory = -Extensions.lazyCallFactory(initializer);
            return builder;
        }

        @NotNull
        public final /* synthetic */ Builder componentRegistry(@NotNull Function1<? super ComponentRegistry.Builder, Unit> builder) {
            int $i$f$componentRegistry = 0;
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            ComponentRegistry.Builder builder2 = new ComponentRegistry.Builder();
            boolean bl = false;
            boolean bl2 = false;
            builder.invoke((Object)builder2);
            return this.componentRegistry(builder2.build());
        }

        @NotNull
        public final Builder componentRegistry(@NotNull ComponentRegistry registry) {
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.registry = registry;
            return builder;
        }

        @NotNull
        public final Builder availableMemoryPercentage(@FloatRange(from=0.0, to=1.0) double percent) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            double d = percent;
            boolean bl4 = d >= 0.0 && d <= 1.0;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Percent must be in the range [0.0, 1.0].";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$apply.availableMemoryPercentage = percent;
            return builder;
        }

        @NotNull
        public final Builder bitmapPoolPercentage(@FloatRange(from=0.0, to=1.0) double percent) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            double d = percent;
            boolean bl4 = d >= 0.0 && d <= 1.0;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Percent must be in the range [0.0, 1.0].";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$apply.bitmapPoolPercentage = percent;
            return builder;
        }

        @NotNull
        public final Builder dispatcher(@NotNull CoroutineDispatcher dispatcher) {
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, dispatcher, null, null, null, false, false, null, null, null, null, null, null, 4094, null);
            return builder;
        }

        @NotNull
        public final Builder allowHardware(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, enable, false, null, null, null, null, null, null, 4079, null);
            return builder;
        }

        @NotNull
        public final Builder allowRgb565(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, enable, null, null, null, null, null, null, 4063, null);
            return builder;
        }

        @NotNull
        public final Builder addLastModifiedToFileCacheKey(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.addLastModifiedToFileCacheKey = enable;
            return builder;
        }

        @NotNull
        public final Builder bitmapPoolingEnabled(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.bitmapPoolingEnabled = enable;
            return builder;
        }

        @NotNull
        public final Builder launchInterceptorChainOnMainThread(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.launchInterceptorChainOnMainThread = enable;
            return builder;
        }

        @NotNull
        public final Builder trackWeakReferences(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.trackWeakReferences = enable;
            return builder;
        }

        @ExperimentalCoilApi
        @NotNull
        public final Builder eventListener(@NotNull EventListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            return this.eventListener(EventListener.Factory.Companion.create(listener2));
        }

        @ExperimentalCoilApi
        @NotNull
        public final Builder eventListener(@NotNull EventListener.Factory factory) {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.eventListenerFactory = factory;
            return builder;
        }

        @NotNull
        public final Builder crossfade(boolean enable) {
            return this.crossfade(enable ? 100 : 0);
        }

        @NotNull
        public final Builder crossfade(int durationMillis) {
            return this.transition(durationMillis > 0 ? (Transition)new CrossfadeTransition(durationMillis) : Transition.NONE);
        }

        @ExperimentalCoilApi
        @NotNull
        public final Builder transition(@NotNull Transition transition2) {
            Intrinsics.checkNotNullParameter((Object)transition2, (String)"transition");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, transition2, null, null, false, false, null, null, null, null, null, null, 4093, null);
            return builder;
        }

        @NotNull
        public final Builder precision(@NotNull Precision precision) {
            Intrinsics.checkNotNullParameter((Object)((Object)precision), (String)"precision");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, precision, null, false, false, null, null, null, null, null, null, 4091, null);
            return builder;
        }

        @NotNull
        public final Builder bitmapConfig(@NotNull Bitmap.Config bitmapConfig) {
            Intrinsics.checkNotNullParameter((Object)bitmapConfig, (String)"bitmapConfig");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, bitmapConfig, false, false, null, null, null, null, null, null, 4087, null);
            return builder;
        }

        @NotNull
        public final Builder placeholder(@DrawableRes int drawableResId) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            DefaultRequestOptions defaultRequestOptions = $this$apply.defaults;
            Context context = $this$apply.applicationContext;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            $this$apply.defaults = DefaultRequestOptions.copy$default(defaultRequestOptions, null, null, null, null, false, false, -Contexts.getDrawableCompat(context, drawableResId), null, null, null, null, null, 4031, null);
            return builder;
        }

        @NotNull
        public final Builder placeholder(@Nullable Drawable drawable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, false, drawable, null, null, null, null, null, 4031, null);
            return builder;
        }

        @NotNull
        public final Builder error(@DrawableRes int drawableResId) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            DefaultRequestOptions defaultRequestOptions = $this$apply.defaults;
            Context context = $this$apply.applicationContext;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            $this$apply.defaults = DefaultRequestOptions.copy$default(defaultRequestOptions, null, null, null, null, false, false, null, -Contexts.getDrawableCompat(context, drawableResId), null, null, null, null, 3967, null);
            return builder;
        }

        @NotNull
        public final Builder error(@Nullable Drawable drawable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, false, null, drawable, null, null, null, null, 3967, null);
            return builder;
        }

        @NotNull
        public final Builder fallback(@DrawableRes int drawableResId) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            DefaultRequestOptions defaultRequestOptions = $this$apply.defaults;
            Context context = $this$apply.applicationContext;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            $this$apply.defaults = DefaultRequestOptions.copy$default(defaultRequestOptions, null, null, null, null, false, false, null, -Contexts.getDrawableCompat(context, drawableResId), null, null, null, null, 3967, null);
            return builder;
        }

        @NotNull
        public final Builder fallback(@Nullable Drawable drawable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, false, null, drawable, null, null, null, null, 3967, null);
            return builder;
        }

        @NotNull
        public final Builder memoryCachePolicy(@NotNull CachePolicy policy) {
            Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, false, null, null, null, policy, null, null, 3583, null);
            return builder;
        }

        @NotNull
        public final Builder diskCachePolicy(@NotNull CachePolicy policy) {
            Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, false, null, null, null, null, policy, null, 3071, null);
            return builder;
        }

        @NotNull
        public final Builder networkCachePolicy(@NotNull CachePolicy policy) {
            Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, false, null, null, null, null, null, policy, 2047, null);
            return builder;
        }

        @NotNull
        public final Builder logger(@Nullable Logger logger) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.logger = logger;
            return builder;
        }

        @NotNull
        public final ImageLoader build() {
            ComponentRegistry componentRegistry;
            EventListener.Factory factory;
            Context context = this.applicationContext;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            long availableMemorySize = Utils.INSTANCE.calculateAvailableMemorySize(context, this.availableMemoryPercentage);
            double bitmapPoolPercentage = this.bitmapPoolingEnabled ? this.bitmapPoolPercentage : 0.0;
            int bitmapPoolSize = (int)(bitmapPoolPercentage * (double)availableMemorySize);
            int memoryCacheSize = (int)(availableMemorySize - (long)bitmapPoolSize);
            RealBitmapPool bitmapPool = new RealBitmapPool(bitmapPoolSize, null, null, this.logger, 6, null);
            WeakMemoryCache weakMemoryCache = this.trackWeakReferences ? (WeakMemoryCache)new RealWeakMemoryCache(this.logger) : (WeakMemoryCache)EmptyWeakMemoryCache.INSTANCE;
            BitmapReferenceCounter referenceCounter = this.bitmapPoolingEnabled ? (BitmapReferenceCounter)new RealBitmapReferenceCounter(weakMemoryCache, bitmapPool, this.logger) : (BitmapReferenceCounter)EmptyBitmapReferenceCounter.INSTANCE;
            StrongMemoryCache strongMemoryCache = StrongMemoryCache.Companion.invoke(weakMemoryCache, referenceCounter, memoryCacheSize, this.logger);
            Context context2 = this.applicationContext;
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"applicationContext");
            BitmapPool bitmapPool2 = bitmapPool;
            Call.Factory factory2 = this.callFactory;
            if (factory2 == null) {
                factory2 = this.buildDefaultCallFactory();
            }
            if ((factory = this.eventListenerFactory) == null) {
                factory = EventListener.Factory.NONE;
            }
            if ((componentRegistry = this.registry) == null) {
                componentRegistry = new ComponentRegistry();
            }
            return new RealImageLoader(context2, this.defaults, bitmapPool2, referenceCounter, strongMemoryCache, weakMemoryCache, factory2, factory, componentRegistry, this.addLastModifiedToFileCacheKey, this.launchInterceptorChainOnMainThread, this.logger);
        }

        private final Call.Factory buildDefaultCallFactory() {
            return -Extensions.lazyCallFactory((Function0<? extends Call.Factory>)((Function0)new Function0<Call.Factory>(this){
                final /* synthetic */ Builder this$0;

                @NotNull
                public final Call.Factory invoke() {
                    OkHttpClient.Builder builder = new OkHttpClient.Builder();
                    Context context = Builder.access$getApplicationContext$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                    OkHttpClient okHttpClient = builder.cache(CoilUtils.createDefaultCache(context)).build();
                    Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"OkHttpClient.Builder()\n \u2026\n                .build()");
                    return (Call.Factory)okHttpClient;
                }
                {
                    this.this$0 = builder;
                    super(0);
                }
            }));
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.applicationContext = context.getApplicationContext();
            this.defaults = DefaultRequestOptions.INSTANCE;
            Context context2 = this.applicationContext;
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"applicationContext");
            this.availableMemoryPercentage = Utils.INSTANCE.getDefaultAvailableMemoryPercentage(context2);
            this.bitmapPoolPercentage = Utils.INSTANCE.getDefaultBitmapPoolPercentage();
            this.addLastModifiedToFileCacheKey = true;
            this.bitmapPoolingEnabled = true;
            this.launchInterceptorChainOnMainThread = true;
            this.trackWeakReferences = true;
        }

        public static final /* synthetic */ Context access$getApplicationContext$p(Builder $this) {
            return $this.applicationContext;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0087\u0002\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcoil/ImageLoader$Companion;", "", "()V", "invoke", "Lcoil/ImageLoader;", "context", "Landroid/content/Context;", "create", "coil-base_release"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final ImageLoader create(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new Builder(context).build();
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

