/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import coil.memory.MemoryCache;
import coil.memory.RealMemoryCache;
import coil.memory.RealWeakMemoryCache;
import coil.memory.WeakMemoryCache;
import coil.util.Logger;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 (2\u00020\u0001:\u0003()*B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J(\u0010#\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\u0011H\u0016J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u0011H\u0016RX\u0010\u0005\u001a>\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n0\u0006j\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n`\u000b8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u00118\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0012\u0010\r\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lcoil/memory/RealWeakMemoryCache;", "Lcoil/memory/WeakMemoryCache;", "logger", "Lcoil/util/Logger;", "(Lcoil/util/Logger;)V", "cache", "Ljava/util/HashMap;", "Lcoil/memory/MemoryCache$Key;", "Ljava/util/ArrayList;", "Lcoil/memory/RealWeakMemoryCache$WeakValue;", "Lkotlin/collections/ArrayList;", "Lkotlin/collections/HashMap;", "getCache$coil_base_release$annotations", "()V", "getCache$coil_base_release", "()Ljava/util/HashMap;", "operationsSinceCleanUp", "", "getOperationsSinceCleanUp$coil_base_release$annotations", "getOperationsSinceCleanUp$coil_base_release", "()I", "setOperationsSinceCleanUp$coil_base_release", "(I)V", "cleanUp", "", "cleanUp$coil_base_release", "cleanUpIfNecessary", "clearMemory", "get", "Lcoil/memory/RealMemoryCache$Value;", "key", "remove", "", "bitmap", "Landroid/graphics/Bitmap;", "set", "isSampled", "size", "trimMemory", "level", "Companion", "StrongValue", "WeakValue", "coil-base_release"})
public final class RealWeakMemoryCache
implements WeakMemoryCache {
    @NotNull
    private final HashMap<MemoryCache.Key, ArrayList<WeakValue>> cache;
    private int operationsSinceCleanUp;
    private final Logger logger;
    private static final String TAG = "RealWeakMemoryCache";
    private static final int CLEAN_UP_INTERVAL = 10;
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting
    public static /* synthetic */ void getCache$coil_base_release$annotations() {
    }

    @NotNull
    public final HashMap<MemoryCache.Key, ArrayList<WeakValue>> getCache$coil_base_release() {
        return this.cache;
    }

    @VisibleForTesting
    public static /* synthetic */ void getOperationsSinceCleanUp$coil_base_release$annotations() {
    }

    public final int getOperationsSinceCleanUp$coil_base_release() {
        return this.operationsSinceCleanUp;
    }

    public final void setOperationsSinceCleanUp$coil_base_release(int n) {
        this.operationsSinceCleanUp = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public synchronized RealMemoryCache.Value get(@NotNull MemoryCache.Key key) {
        StrongValue strongValue;
        block5: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            ArrayList<WeakValue> arrayList = this.cache.get(key);
            if (arrayList == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"cache[key] ?: return null");
            ArrayList<WeakValue> values = arrayList;
            List $this$firstNotNullIndices$iv = values;
            boolean $i$f$firstNotNullIndices = false;
            int n = 0;
            int n2 = ((Collection)$this$firstNotNullIndices$iv).size();
            while (n < n2) {
                StrongValue strongValue2;
                void i$iv;
                WeakValue value = (WeakValue)$this$firstNotNullIndices$iv.get((int)i$iv);
                boolean bl = false;
                if ((Bitmap)value.getBitmap().get() != null) {
                    Bitmap bitmap;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Bitmap it = bitmap;
                    boolean bl4 = false;
                    Bitmap bitmap2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"it");
                    strongValue2 = new StrongValue(bitmap2, value.isSampled());
                } else {
                    strongValue2 = null;
                }
                if (strongValue2 != null) {
                    StrongValue strongValue3 = strongValue2;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    StrongValue it$iv = strongValue3;
                    boolean bl7 = false;
                    strongValue = it$iv;
                    break block5;
                }
                ++i$iv;
            }
            strongValue = null;
        }
        StrongValue strongValue4 = strongValue;
        this.cleanUpIfNecessary();
        return strongValue4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void set(@NotNull MemoryCache.Key key, @NotNull Bitmap bitmap, boolean isSampled, int size) {
        block6: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Map $this$getOrPut$iv = this.cache;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl = false;
                boolean bl2 = false;
                ArrayList answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ArrayList values = (ArrayList)object;
            RealWeakMemoryCache realWeakMemoryCache = this;
            boolean bl = false;
            boolean bl3 = false;
            RealWeakMemoryCache $this$run = realWeakMemoryCache;
            boolean bl4 = false;
            Bitmap $this$identityHashCode$iv = bitmap;
            int $i$f$getIdentityHashCode = 0;
            int identityHashCode = System.identityHashCode($this$identityHashCode$iv);
            WeakValue newValue = new WeakValue(identityHashCode, new WeakReference<Bitmap>(bitmap), isSampled, size);
            $i$f$getIdentityHashCode = 0;
            int n = ((Collection)values).size();
            while ($i$f$getIdentityHashCode < n) {
                void index;
                Object e = values.get((int)index);
                Intrinsics.checkNotNullExpressionValue(e, (String)"values[index]");
                WeakValue value = (WeakValue)e;
                if (size >= value.getSize()) {
                    if (value.getIdentityHashCode() == identityHashCode && (Bitmap)value.getBitmap().get() == bitmap) {
                        values.set((int)index, newValue);
                    } else {
                        values.add((int)index, newValue);
                    }
                    break block6;
                }
                ++index;
            }
            Collection collection = values;
            n = 0;
            collection.add(newValue);
        }
        this.cleanUpIfNecessary();
    }

    @Override
    public synchronized boolean remove(@NotNull MemoryCache.Key key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.cache.remove(key) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean remove(@NotNull Bitmap bitmap) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Bitmap $this$identityHashCode$iv = bitmap;
            boolean $i$f$getIdentityHashCode = false;
            int identityHashCode = System.identityHashCode($this$identityHashCode$iv);
            RealWeakMemoryCache realWeakMemoryCache = this;
            boolean bl2 = false;
            boolean bl3 = false;
            RealWeakMemoryCache $this$run = realWeakMemoryCache;
            boolean bl4 = false;
            Collection<ArrayList<WeakValue>> collection = $this$run.cache.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"cache.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ArrayList values = (ArrayList)element$iv;
                boolean bl5 = false;
                int n = 0;
                ArrayList arrayList = values;
                Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"values");
                int n2 = ((Collection)arrayList).size();
                while (n < n2) {
                    void index;
                    if (((WeakValue)values.get((int)index)).getIdentityHashCode() == identityHashCode) {
                        values.remove((int)index);
                        bl = true;
                        break block3;
                    }
                    ++index;
                }
            }
            bl = false;
        }
        boolean removed = bl;
        this.cleanUpIfNecessary();
        return removed;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void clearMemory() {
        Logger logger = this.logger;
        if (logger != null) {
            void $this$log$iv;
            Logger logger2 = logger;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var7_6 = tag$iv;
                void var6_7 = $this$log$iv;
                boolean bl = false;
                String string2 = "clearMemory";
                var6_7.log((String)var7_6, n, string2, null);
            }
        }
        this.operationsSinceCleanUp = 0;
        this.cache.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void trimMemory(int level) {
        Logger logger = this.logger;
        if (logger != null) {
            void $this$log$iv;
            Logger logger2 = logger;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var8_7 = tag$iv;
                void var7_8 = $this$log$iv;
                boolean bl = false;
                String string2 = "trimMemory, level=" + level;
                var7_8.log((String)var8_7, n, string2, null);
            }
        }
        if (level >= 10 && level != 20) {
            this.cleanUp$coil_base_release();
        }
    }

    private final void cleanUpIfNecessary() {
        int n = this.operationsSinceCleanUp;
        this.operationsSinceCleanUp = n + 1;
        if (n >= 10) {
            this.cleanUp$coil_base_release();
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void cleanUp$coil_base_release() {
        this.operationsSinceCleanUp = 0;
        Iterator<ArrayList<WeakValue>> iterator = this.cache.values().iterator();
        while (iterator.hasNext()) {
            ArrayList<WeakValue> list;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"iterator.next()");
            Collection collection = list;
            boolean bl = false;
            if (collection.size() <= 1) {
                Object object = (WeakValue)CollectionsKt.firstOrNull((List)list);
                if ((object != null && (object = ((WeakValue)object).getBitmap()) != null ? (Bitmap)((Reference)object).get() : null) != null) continue;
                iterator.remove();
                continue;
            }
            if (Build.VERSION.SDK_INT >= 24) {
                list.removeIf(cleanUp.1.INSTANCE);
            } else {
                List $this$removeIfIndices$iv = list;
                boolean $i$f$removeIfIndices = false;
                int numDeleted$iv = 0;
                int n = 0;
                int n2 = ((Collection)$this$removeIfIndices$iv).size();
                while (n < n2) {
                    void rawIndex$iv;
                    void index$iv = rawIndex$iv - numDeleted$iv;
                    Object value$iv = $this$removeIfIndices$iv.get((int)index$iv);
                    WeakValue it = (WeakValue)value$iv;
                    boolean bl2 = false;
                    if (it.getBitmap().get() == null) {
                        $this$removeIfIndices$iv.remove((int)index$iv);
                        ++numDeleted$iv;
                    }
                    ++rawIndex$iv;
                }
            }
            if (!list.isEmpty()) continue;
            iterator.remove();
        }
    }

    public RealWeakMemoryCache(@Nullable Logger logger) {
        this.logger = logger;
        boolean bl = false;
        this.cache = new HashMap();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0001\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcoil/memory/RealWeakMemoryCache$WeakValue;", "", "identityHashCode", "", "bitmap", "Ljava/lang/ref/WeakReference;", "Landroid/graphics/Bitmap;", "isSampled", "", "size", "(ILjava/lang/ref/WeakReference;ZI)V", "getBitmap", "()Ljava/lang/ref/WeakReference;", "getIdentityHashCode", "()I", "()Z", "getSize", "coil-base_release"})
    @VisibleForTesting
    public static final class WeakValue {
        private final int identityHashCode;
        @NotNull
        private final WeakReference<Bitmap> bitmap;
        private final boolean isSampled;
        private final int size;

        public final int getIdentityHashCode() {
            return this.identityHashCode;
        }

        @NotNull
        public final WeakReference<Bitmap> getBitmap() {
            return this.bitmap;
        }

        public final boolean isSampled() {
            return this.isSampled;
        }

        public final int getSize() {
            return this.size;
        }

        public WeakValue(int identityHashCode, @NotNull WeakReference<Bitmap> bitmap, boolean isSampled, int size) {
            Intrinsics.checkNotNullParameter(bitmap, (String)"bitmap");
            this.identityHashCode = identityHashCode;
            this.bitmap = bitmap;
            this.isSampled = isSampled;
            this.size = size;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\n"}, d2={"Lcoil/memory/RealWeakMemoryCache$StrongValue;", "Lcoil/memory/RealMemoryCache$Value;", "bitmap", "Landroid/graphics/Bitmap;", "isSampled", "", "(Landroid/graphics/Bitmap;Z)V", "getBitmap", "()Landroid/graphics/Bitmap;", "()Z", "coil-base_release"})
    private static final class StrongValue
    implements RealMemoryCache.Value {
        @NotNull
        private final Bitmap bitmap;
        private final boolean isSampled;

        @Override
        @NotNull
        public Bitmap getBitmap() {
            return this.bitmap;
        }

        @Override
        public boolean isSampled() {
            return this.isSampled;
        }

        public StrongValue(@NotNull Bitmap bitmap, boolean isSampled) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            this.bitmap = bitmap;
            this.isSampled = isSampled;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcoil/memory/RealWeakMemoryCache$Companion;", "", "()V", "CLEAN_UP_INTERVAL", "", "TAG", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

