/*
 * Decompiled with CFR 0.152.
 */
package coil.bitmap;

import android.graphics.Bitmap;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import coil.bitmap.BitmapPoolStrategy;
import coil.collection.LinkedMultimap;
import coil.util.-Bitmaps;
import coil.util.Utils;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J&\u0010\f\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\r\u001a\u00020\u00052\b\b\u0001\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J$\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\r\u001a\u00020\u00052\b\b\u0001\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcoil/bitmap/SizeStrategy;", "Lcoil/bitmap/BitmapPoolStrategy;", "()V", "entries", "Lcoil/collection/LinkedMultimap;", "", "Landroid/graphics/Bitmap;", "sizes", "Ljava/util/TreeMap;", "decrementSize", "", "size", "get", "width", "height", "config", "Landroid/graphics/Bitmap$Config;", "put", "bitmap", "removeLast", "stringify", "", "toString", "Companion", "coil-base_release"})
@VisibleForTesting
@RequiresApi(value=19)
public final class SizeStrategy
implements BitmapPoolStrategy {
    private final LinkedMultimap<Integer, Bitmap> entries = new LinkedMultimap();
    private final TreeMap<Integer, Integer> sizes = new TreeMap();
    private static final int MAX_SIZE_MULTIPLE = 4;
    public static final Companion Companion = new Companion(null);

    @Override
    public void put(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        int size = -Bitmaps.getAllocationByteCountCompat(bitmap);
        this.entries.put(size, bitmap);
        Integer count = this.sizes.get(size);
        ((Map)this.sizes).put(size, count == null ? 1 : count + 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Bitmap get(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        size = Utils.INSTANCE.calculateAllocationByteCount(width, height, config);
        v0 = this.sizes.ceilingKey(size);
        if (v0 == null) ** GOTO lbl-1000
        var6_5 = v0;
        var7_6 = false;
        var8_7 = false;
        it = ((Number)var6_5).intValue();
        $i$a$-takeIf-SizeStrategy$get$bestSize$1 = false;
        v0 = it <= 4 * size != false ? var6_5 : null;
        if (v0 != null) {
            v1 = v0;
        } else lbl-1000:
        // 2 sources

        {
            v1 = size;
        }
        bestSize = v1;
        bitmap = this.entries.removeLast(bestSize);
        if (bitmap != null) {
            this.decrementSize(bestSize);
            bitmap.reconfigure(width, height, config);
        }
        return bitmap;
    }

    @Override
    @Nullable
    public Bitmap removeLast() {
        Bitmap bitmap = this.entries.removeLast();
        if (bitmap != null) {
            this.decrementSize(bitmap.getAllocationByteCount());
        }
        return bitmap;
    }

    private final void decrementSize(int size) {
        int count = ((Number)MapsKt.getValue((Map)this.sizes, (Object)size)).intValue();
        if (count == 1) {
            Map map = this.sizes;
            Integer n = size;
            boolean bl = false;
            map.remove(n);
        } else {
            ((Map)this.sizes).put(size, count - 1);
        }
    }

    @Override
    @NotNull
    public String stringify(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        return "" + '[' + -Bitmaps.getAllocationByteCountCompat(bitmap) + ']';
    }

    @Override
    @NotNull
    public String stringify(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return "" + '[' + Utils.INSTANCE.calculateAllocationByteCount(width, height, config) + ']';
    }

    @NotNull
    public String toString() {
        return "SizeStrategy: entries=" + this.entries + ", sizes=" + this.sizes;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/bitmap/SizeStrategy$Companion;", "", "()V", "MAX_SIZE_MULTIPLE", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

