/*
 * Decompiled with CFR 0.152.
 */
package coil.transform;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.Px;
import coil.bitmap.BitmapPool;
import coil.decode.DecodeUtils;
import coil.size.OriginalSize;
import coil.size.PixelSize;
import coil.size.Scale;
import coil.size.Size;
import coil.transform.Transformation;
import coil.util.-Bitmaps;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0003\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J)\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lcoil/transform/RoundedCornersTransformation;", "Lcoil/transform/Transformation;", "radius", "", "(F)V", "topLeft", "topRight", "bottomLeft", "bottomRight", "(FFFF)V", "equals", "", "other", "", "hashCode", "", "key", "", "toString", "transform", "Landroid/graphics/Bitmap;", "pool", "Lcoil/bitmap/BitmapPool;", "input", "size", "Lcoil/size/Size;", "(Lcoil/bitmap/BitmapPool;Landroid/graphics/Bitmap;Lcoil/size/Size;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "coil-base_release"})
public final class RoundedCornersTransformation
implements Transformation {
    private final float topLeft;
    private final float topRight;
    private final float bottomLeft;
    private final float bottomRight;

    @Override
    @NotNull
    public String key() {
        return RoundedCornersTransformation.class.getName() + '-' + this.topLeft + ',' + this.topRight + ',' + this.bottomLeft + ',' + this.bottomRight;
    }

    @Override
    @Nullable
    public Object transform(@NotNull BitmapPool pool, @NotNull Bitmap input, @NotNull Size size, @NotNull Continuation<? super Bitmap> $completion) {
        Canvas c$iv;
        Bitmap output;
        Paint paint = new Paint(3);
        int outputWidth = 0;
        int outputHeight = 0;
        Size size2 = size;
        if (size2 instanceof PixelSize) {
            double multiplier = DecodeUtils.computeSizeMultiplier(input.getWidth(), input.getHeight(), ((PixelSize)size).getWidth(), ((PixelSize)size).getHeight(), Scale.FILL);
            outputWidth = MathKt.roundToInt((double)((double)((PixelSize)size).getWidth() / multiplier));
            outputHeight = MathKt.roundToInt((double)((double)((PixelSize)size).getHeight() / multiplier));
        } else if (size2 instanceof OriginalSize) {
            outputWidth = input.getWidth();
            outputHeight = input.getHeight();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Bitmap $this$applyCanvas$iv = output = pool.get(outputWidth, outputHeight, -Bitmaps.getSafeConfig(input));
        boolean $i$f$applyCanvas = false;
        Canvas $this$applyCanvas = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl = false;
        $this$applyCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        Matrix matrix = new Matrix();
        matrix.setTranslate((float)(outputWidth - input.getWidth()) / 2.0f, (float)(outputHeight - input.getHeight()) / 2.0f);
        BitmapShader shader = new BitmapShader(input, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        shader.setLocalMatrix(matrix);
        paint.setShader((Shader)shader);
        float[] radii = new float[]{this.topLeft, this.topLeft, this.topRight, this.topRight, this.bottomRight, this.bottomRight, this.bottomLeft, this.bottomLeft};
        RectF rect = new RectF(0.0f, 0.0f, (float)$this$applyCanvas.getWidth(), (float)$this$applyCanvas.getHeight());
        Path path = new Path();
        boolean bl2 = false;
        boolean bl3 = false;
        Path $this$apply = path;
        boolean bl4 = false;
        $this$apply.addRoundRect(rect, radii, Path.Direction.CW);
        Path path2 = path;
        $this$applyCanvas.drawPath(path2, paint);
        return output;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RoundedCornersTransformation && this.topLeft == ((RoundedCornersTransformation)other).topLeft && this.topRight == ((RoundedCornersTransformation)other).topRight && this.bottomLeft == ((RoundedCornersTransformation)other).bottomLeft && this.bottomRight == ((RoundedCornersTransformation)other).bottomRight;
    }

    public int hashCode() {
        int result = Float.hashCode(this.topLeft);
        result = 31 * result + Float.hashCode(this.topRight);
        result = 31 * result + Float.hashCode(this.bottomLeft);
        result = 31 * result + Float.hashCode(this.bottomRight);
        return result;
    }

    @NotNull
    public String toString() {
        return "RoundedCornersTransformation(topLeft=" + this.topLeft + ", topRight=" + this.topRight + ", " + "bottomLeft=" + this.bottomLeft + ", bottomRight=" + this.bottomRight + ')';
    }

    public RoundedCornersTransformation(@Px float topLeft, @Px float topRight, @Px float bottomLeft, @Px float bottomRight) {
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
        boolean bl = this.topLeft >= 0.0f && this.topRight >= 0.0f && this.bottomLeft >= 0.0f && this.bottomRight >= 0.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "All radii must be >= 0.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ RoundedCornersTransformation(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n & 8) != 0) {
            f4 = 0.0f;
        }
        this(f, f2, f3, f4);
    }

    public RoundedCornersTransformation() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    }

    public RoundedCornersTransformation(@Px float radius) {
        this(radius, radius, radius, radius);
    }
}

