/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import androidx.annotation.MainThread;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import coil.EventListener;
import coil.ImageLoader;
import coil.bitmap.BitmapReferenceCounter;
import coil.memory.BaseRequestDelegate;
import coil.memory.EmptyTargetDelegate;
import coil.memory.InvalidatableEmptyTargetDelegate;
import coil.memory.InvalidatableTargetDelegate;
import coil.memory.PoolableTargetDelegate;
import coil.memory.RequestDelegate;
import coil.memory.TargetDelegate;
import coil.memory.ViewTargetRequestDelegate;
import coil.request.ImageRequest;
import coil.target.PoolableViewTarget;
import coil.target.Target;
import coil.target.ViewTarget;
import coil.util.-Extensions;
import coil.util.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\"\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcoil/memory/DelegateService;", "", "imageLoader", "Lcoil/ImageLoader;", "referenceCounter", "Lcoil/bitmap/BitmapReferenceCounter;", "logger", "Lcoil/util/Logger;", "(Lcoil/ImageLoader;Lcoil/bitmap/BitmapReferenceCounter;Lcoil/util/Logger;)V", "createRequestDelegate", "Lcoil/memory/RequestDelegate;", "request", "Lcoil/request/ImageRequest;", "targetDelegate", "Lcoil/memory/TargetDelegate;", "job", "Lkotlinx/coroutines/Job;", "createTargetDelegate", "target", "Lcoil/target/Target;", "type", "", "eventListener", "Lcoil/EventListener;", "coil-base_release"})
public final class DelegateService {
    private final ImageLoader imageLoader;
    private final BitmapReferenceCounter referenceCounter;
    private final Logger logger;

    @MainThread
    @NotNull
    public final TargetDelegate createTargetDelegate(@Nullable Target target2, int type, @NotNull EventListener eventListener) {
        TargetDelegate targetDelegate;
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        switch (type) {
            case 1: {
                Target target3 = target2;
                if (target3 == null) {
                    targetDelegate = new InvalidatableEmptyTargetDelegate(this.referenceCounter);
                    break;
                }
                targetDelegate = new InvalidatableTargetDelegate(target2, this.referenceCounter, eventListener, this.logger);
                break;
            }
            case 0: {
                Target target4 = target2;
                if (target4 == null) {
                    targetDelegate = EmptyTargetDelegate.INSTANCE;
                    break;
                }
                if (target4 instanceof PoolableViewTarget) {
                    targetDelegate = new PoolableTargetDelegate((PoolableViewTarget)target2, this.referenceCounter, eventListener, this.logger);
                    break;
                }
                targetDelegate = new InvalidatableTargetDelegate(target2, this.referenceCounter, eventListener, this.logger);
                break;
            }
            default: {
                String string = "Invalid type.";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return targetDelegate;
    }

    @MainThread
    @NotNull
    public final RequestDelegate createRequestDelegate(@NotNull ImageRequest request, @NotNull TargetDelegate targetDelegate, @NotNull Job job2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)targetDelegate, (String)"targetDelegate");
        Intrinsics.checkNotNullParameter((Object)job2, (String)"job");
        Lifecycle lifecycle = request.getLifecycle();
        RequestDelegate delegate = null;
        Target target2 = request.getTarget();
        if (target2 instanceof ViewTarget) {
            delegate = new ViewTargetRequestDelegate(this.imageLoader, request, targetDelegate, job2);
            lifecycle.addObserver((LifecycleObserver)delegate);
            if (request.getTarget() instanceof LifecycleObserver) {
                lifecycle.addObserver((LifecycleObserver)request.getTarget());
            }
            -Extensions.getRequestManager(((ViewTarget)request.getTarget()).getView()).setCurrentRequest((ViewTargetRequestDelegate)delegate);
        } else {
            delegate = new BaseRequestDelegate(lifecycle, job2);
            lifecycle.addObserver((LifecycleObserver)delegate);
        }
        return delegate;
    }

    public DelegateService(@NotNull ImageLoader imageLoader, @NotNull BitmapReferenceCounter referenceCounter, @Nullable Logger logger) {
        Intrinsics.checkNotNullParameter((Object)imageLoader, (String)"imageLoader");
        Intrinsics.checkNotNullParameter((Object)referenceCounter, (String)"referenceCounter");
        this.imageLoader = imageLoader;
        this.referenceCounter = referenceCounter;
        this.logger = logger;
    }
}

