/*
 * Decompiled with CFR 0.152.
 */
package coil.bitmap;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import androidx.collection.SparseArrayCompat;
import coil.bitmap.BitmapPool;
import coil.bitmap.BitmapReferenceCounter;
import coil.memory.WeakMemoryCache;
import coil.util.Logger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 %2\u00020\u0001:\u0002%&B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u00132\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\n8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\f\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcoil/bitmap/RealBitmapReferenceCounter;", "Lcoil/bitmap/BitmapReferenceCounter;", "weakMemoryCache", "Lcoil/memory/WeakMemoryCache;", "bitmapPool", "Lcoil/bitmap/BitmapPool;", "logger", "Lcoil/util/Logger;", "(Lcoil/memory/WeakMemoryCache;Lcoil/bitmap/BitmapPool;Lcoil/util/Logger;)V", "operationsSinceCleanUp", "", "getOperationsSinceCleanUp$coil_base_release$annotations", "()V", "getOperationsSinceCleanUp$coil_base_release", "()I", "setOperationsSinceCleanUp$coil_base_release", "(I)V", "values", "Landroidx/collection/SparseArrayCompat;", "Lcoil/bitmap/RealBitmapReferenceCounter$Value;", "getValues$coil_base_release$annotations", "getValues$coil_base_release", "()Landroidx/collection/SparseArrayCompat;", "cleanUp", "", "cleanUp$coil_base_release", "cleanUpIfNecessary", "decrement", "", "bitmap", "Landroid/graphics/Bitmap;", "getValue", "key", "getValueOrNull", "increment", "setValid", "isValid", "Companion", "Value", "coil-base_release"})
public final class RealBitmapReferenceCounter
implements BitmapReferenceCounter {
    @NotNull
    private final SparseArrayCompat<Value> values;
    private int operationsSinceCleanUp;
    private final WeakMemoryCache weakMemoryCache;
    private final BitmapPool bitmapPool;
    private final Logger logger;
    private static final String TAG = "RealBitmapReferenceCounter";
    private static final int CLEAN_UP_INTERVAL = 50;
    private static final Handler MAIN_HANDLER;
    public static final Companion Companion;

    @VisibleForTesting
    public static /* synthetic */ void getValues$coil_base_release$annotations() {
    }

    @NotNull
    public final SparseArrayCompat<Value> getValues$coil_base_release() {
        return this.values;
    }

    @VisibleForTesting
    public static /* synthetic */ void getOperationsSinceCleanUp$coil_base_release$annotations() {
    }

    public final int getOperationsSinceCleanUp$coil_base_release() {
        return this.operationsSinceCleanUp;
    }

    public final void setOperationsSinceCleanUp$coil_base_release(int n) {
        this.operationsSinceCleanUp = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void increment(@NotNull Bitmap bitmap) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Bitmap $this$identityHashCode$iv = bitmap;
        int $i$f$getIdentityHashCode2 = 0;
        int key = System.identityHashCode($this$identityHashCode$iv);
        Value value2 = value = this.getValue(key, bitmap);
        $i$f$getIdentityHashCode2 = value2.getCount();
        value2.setCount($i$f$getIdentityHashCode2 + 1);
        Logger logger = this.logger;
        if (logger != null) {
            void $this$log$iv;
            Logger $i$f$getIdentityHashCode2 = logger;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var10_10 = tag$iv;
                void var9_11 = $this$log$iv;
                boolean bl = false;
                String string2 = "INCREMENT: [" + key + ", " + value.getCount() + ", " + value.isValid() + ']';
                var9_11.log((String)var10_10, n, string2, null);
            }
        }
        this.cleanUpIfNecessary();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean decrement(@NotNull Bitmap bitmap) {
        boolean removed;
        Value value;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Bitmap $this$identityHashCode$iv = bitmap;
        int $i$f$getIdentityHashCode2 = 0;
        int key = System.identityHashCode($this$identityHashCode$iv);
        Value value2 = this.getValueOrNull(key, bitmap);
        if (value2 == null) {
            RealBitmapReferenceCounter $i$f$getIdentityHashCode2 = this;
            boolean bl = false;
            boolean bl2 = false;
            RealBitmapReferenceCounter $this$run = $i$f$getIdentityHashCode2;
            boolean bl3 = false;
            Logger logger = $this$run.logger;
            if (logger != null) {
                void $this$log$iv;
                Logger logger2 = logger;
                String string = TAG;
                int priority$iv = 2;
                boolean $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv) {
                    void tag$iv;
                    int n = priority$iv;
                    void var14_21 = tag$iv;
                    void var15_22 = $this$log$iv;
                    boolean bl4 = false;
                    String string2 = "DECREMENT: [" + key + ", UNKNOWN, UNKNOWN]";
                    var15_22.log((String)var14_21, n, string2, null);
                }
            }
            return false;
        }
        Value value3 = value = value2;
        $i$f$getIdentityHashCode2 = value3.getCount();
        value3.setCount($i$f$getIdentityHashCode2 + -1);
        Logger logger = this.logger;
        if (logger != null) {
            void $this$log$iv;
            Logger $i$f$getIdentityHashCode2 = logger;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var19_26 = tag$iv;
                void var18_27 = $this$log$iv;
                boolean bl = false;
                String string3 = "DECREMENT: [" + key + ", " + value.getCount() + ", " + value.isValid() + ']';
                var18_27.log((String)var19_26, n, string3, null);
            }
        }
        boolean bl = removed = value.getCount() <= 0 && value.isValid();
        if (removed) {
            this.values.remove(key);
            this.weakMemoryCache.remove(bitmap);
            MAIN_HANDLER.post(new Runnable(this, bitmap){
                final /* synthetic */ RealBitmapReferenceCounter this$0;
                final /* synthetic */ Bitmap $bitmap;

                public final void run() {
                    RealBitmapReferenceCounter.access$getBitmapPool$p(this.this$0).put(this.$bitmap);
                }
                {
                    this.this$0 = realBitmapReferenceCounter;
                    this.$bitmap = bitmap;
                }
            });
        }
        this.cleanUpIfNecessary();
        return removed;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setValid(@NotNull Bitmap bitmap, boolean isValid) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Bitmap $this$identityHashCode$iv = bitmap;
        boolean $i$f$getIdentityHashCode2 = false;
        int key = System.identityHashCode($this$identityHashCode$iv);
        if (isValid) {
            value = this.getValueOrNull(key, bitmap);
            if (value == null) {
                void $receiver$iv;
                SparseArrayCompat<Value> $i$f$getIdentityHashCode2 = this.values;
                Value value$iv = new Value(new WeakReference<Bitmap>(bitmap), 0, true);
                boolean $i$f$set = false;
                $receiver$iv.put(key, (Object)value$iv);
            }
        } else {
            value = this.getValue(key, bitmap);
            value.setValid(false);
        }
        this.cleanUpIfNecessary();
    }

    private final void cleanUpIfNecessary() {
        int n = this.operationsSinceCleanUp;
        this.operationsSinceCleanUp = n + 1;
        if (n >= 50) {
            this.cleanUp$coil_base_release();
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void cleanUp$coil_base_release() {
        void $this$forEachIndices$iv;
        int n = 0;
        ArrayList toRemove = new ArrayList();
        n = 0;
        SparseArrayCompat<Value> $receiver$iv = this.values;
        int $i$f$getSize2 = 0;
        int n2 = $receiver$iv.size();
        while (n < n2) {
            void index;
            Value value = (Value)this.values.valueAt((int)index);
            if (value.getBitmap().get() == null) {
                Collection $i$f$getSize2 = toRemove;
                Integer n3 = (int)index;
                boolean bl = false;
                $i$f$getSize2.add(n3);
            }
            ++index;
        }
        List index = toRemove;
        SparseArrayCompat<Value> sparseArrayCompat = this.values;
        boolean $i$f$forEachIndices = false;
        $i$f$getSize2 = 0;
        int n4 = ((Collection)$this$forEachIndices$iv).size();
        while ($i$f$getSize2 < n4) {
            void i$iv;
            int p1 = ((Number)$this$forEachIndices$iv.get((int)i$iv)).intValue();
            boolean bl = false;
            sparseArrayCompat.removeAt(p1);
            ++i$iv;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Value getValue(int key, Bitmap bitmap) {
        Value value = this.getValueOrNull(key, bitmap);
        if (value == null) {
            void $receiver$iv;
            value = new Value(new WeakReference<Bitmap>(bitmap), 0, false);
            SparseArrayCompat<Value> sparseArrayCompat = this.values;
            Value value$iv = value;
            boolean $i$f$set = false;
            $receiver$iv.put(key, (Object)value$iv);
        }
        return value;
    }

    private final Value getValueOrNull(int key, Bitmap bitmap) {
        Value value;
        Value value2 = (Value)this.values.get(key);
        if (value2 != null) {
            Value value3 = value2;
            boolean bl = false;
            boolean bl2 = false;
            Value it = value3;
            boolean bl3 = false;
            value = (Bitmap)it.getBitmap().get() == bitmap ? value3 : null;
        } else {
            value = null;
        }
        return value;
    }

    public RealBitmapReferenceCounter(@NotNull WeakMemoryCache weakMemoryCache, @NotNull BitmapPool bitmapPool, @Nullable Logger logger) {
        Intrinsics.checkNotNullParameter((Object)weakMemoryCache, (String)"weakMemoryCache");
        Intrinsics.checkNotNullParameter((Object)bitmapPool, (String)"bitmapPool");
        this.weakMemoryCache = weakMemoryCache;
        this.bitmapPool = bitmapPool;
        this.logger = logger;
        this.values = new SparseArrayCompat();
    }

    static {
        Companion = new Companion(null);
        MAIN_HANDLER = new Handler(Looper.getMainLooper());
    }

    public static final /* synthetic */ BitmapPool access$getBitmapPool$p(RealBitmapReferenceCounter $this) {
        return $this.bitmapPool;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0001\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcoil/bitmap/RealBitmapReferenceCounter$Value;", "", "bitmap", "Ljava/lang/ref/WeakReference;", "Landroid/graphics/Bitmap;", "count", "", "isValid", "", "(Ljava/lang/ref/WeakReference;IZ)V", "getBitmap", "()Ljava/lang/ref/WeakReference;", "getCount", "()I", "setCount", "(I)V", "()Z", "setValid", "(Z)V", "coil-base_release"})
    @VisibleForTesting
    public static final class Value {
        @NotNull
        private final WeakReference<Bitmap> bitmap;
        private int count;
        private boolean isValid;

        @NotNull
        public final WeakReference<Bitmap> getBitmap() {
            return this.bitmap;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public final boolean isValid() {
            return this.isValid;
        }

        public final void setValid(boolean bl) {
            this.isValid = bl;
        }

        public Value(@NotNull WeakReference<Bitmap> bitmap, int count, boolean isValid) {
            Intrinsics.checkNotNullParameter(bitmap, (String)"bitmap");
            this.bitmap = bitmap;
            this.count = count;
            this.isValid = isValid;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcoil/bitmap/RealBitmapReferenceCounter$Companion;", "", "()V", "CLEAN_UP_INTERVAL", "", "MAIN_HANDLER", "Landroid/os/Handler;", "TAG", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

