/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.WorkerThread;
import coil.bitmappool.BitmapPool;
import coil.decode.DecodeUtils;
import coil.size.OriginalSize;
import coil.size.PixelSize;
import coil.size.Scale;
import coil.size.Size;
import coil.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcoil/decode/DrawableDecoderService;", "", "bitmapPool", "Lcoil/bitmappool/BitmapPool;", "(Lcoil/bitmappool/BitmapPool;)V", "convert", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "size", "Lcoil/size/Size;", "config", "Landroid/graphics/Bitmap$Config;", "Companion", "coil-base_release"})
public final class DrawableDecoderService {
    private final BitmapPool bitmapPool;
    private static final int DEFAULT_SIZE = 512;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public final Bitmap convert(@NotNull Drawable drawable, @NotNull Size size2, @NotNull Bitmap.Config config) {
        void oldRight;
        void oldTop;
        void oldLeft;
        Rect rect;
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        Intrinsics.checkParameterIsNotNull((Object)size2, (String)"size");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Bitmap.Config safeConfig = ExtensionsKt.normalize(config);
        if (drawable instanceof BitmapDrawable) {
            Bitmap bitmap;
            Bitmap bitmap2 = bitmap = ((BitmapDrawable)drawable).getBitmap();
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
            if (ExtensionsKt.normalize(bitmap2.getConfig()) == safeConfig) {
                return bitmap;
            }
        }
        int width = 0;
        int height = 0;
        int unsafeIntrinsicWidth = drawable.getIntrinsicWidth();
        int unsafeIntrinsicHeight = drawable.getIntrinsicHeight();
        int intrinsicWidth = unsafeIntrinsicWidth > 0 ? unsafeIntrinsicWidth : 512;
        int intrinsicHeight = unsafeIntrinsicHeight > 0 ? unsafeIntrinsicHeight : 512;
        Size size3 = size2;
        if (size3 instanceof OriginalSize) {
            width = intrinsicWidth;
            height = intrinsicHeight;
        } else if (size3 instanceof PixelSize) {
            double multiplier = DecodeUtils.computeSizeMultiplier(intrinsicWidth, intrinsicHeight, ((PixelSize)size2).getWidth(), ((PixelSize)size2).getHeight(), Scale.FIT);
            width = MathKt.roundToInt((double)(multiplier * (double)intrinsicWidth));
            height = MathKt.roundToInt((double)(multiplier * (double)intrinsicHeight));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Rect $this$component1$iv = rect = drawable.getBounds();
        boolean $i$f$component1 = false;
        int n = $this$component1$iv.left;
        Rect $this$component2$iv = rect;
        boolean $i$f$component2 = false;
        int multiplier = $this$component2$iv.top;
        Rect $this$component3$iv = rect;
        boolean $i$f$component3 = false;
        int n2 = $this$component3$iv.right;
        Rect $this$component4$iv = rect;
        boolean $i$f$component4 = false;
        int oldBottom = $this$component4$iv.bottom;
        Bitmap bitmap = this.bitmapPool.get(width, height, safeConfig);
        Drawable drawable2 = drawable;
        boolean bl = false;
        boolean bl2 = false;
        Drawable $this$apply = drawable2;
        boolean bl3 = false;
        $this$apply.setBounds(0, 0, width, height);
        $this$apply.draw(new Canvas(bitmap));
        $this$apply.setBounds((int)oldLeft, (int)oldTop, (int)oldRight, oldBottom);
        return bitmap;
    }

    public DrawableDecoderService(@NotNull BitmapPool bitmapPool) {
        Intrinsics.checkParameterIsNotNull((Object)bitmapPool, (String)"bitmapPool");
        this.bitmapPool = bitmapPool;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/decode/DrawableDecoderService$Companion;", "", "()V", "DEFAULT_SIZE", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

