/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.exifinterface.media.ExifInterface;
import coil.bitmappool.BitmapPool;
import coil.decode.DecodeResult;
import coil.decode.DecodeUtils;
import coil.decode.Decoder;
import coil.decode.Options;
import coil.size.PixelSize;
import coil.size.Size;
import coil.util.ExtensionsKt;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000  2\u00020\u0001:\u0003\u001f !B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J1\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001a\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lcoil/decode/BitmapFactoryDecoder;", "Lcoil/decode/Decoder;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "paint", "Landroid/graphics/Paint;", "allowRgb565", "", "config", "Landroid/graphics/Bitmap$Config;", "mimeType", "", "applyExifTransformations", "Landroid/graphics/Bitmap;", "pool", "Lcoil/bitmappool/BitmapPool;", "inBitmap", "isFlipped", "rotationDegrees", "", "decode", "Lcoil/decode/DecodeResult;", "source", "Lokio/BufferedSource;", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmappool/BitmapPool;Lokio/BufferedSource;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handles", "AlwaysAvailableInputStream", "Companion", "ExceptionCatchingSource", "coil-base_release"})
public final class BitmapFactoryDecoder
implements Decoder {
    private final Paint paint;
    private final Context context;
    private static final String MIME_TYPE_JPEG = "image/jpeg";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean handles(@NotNull BufferedSource source, @Nullable String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object decode(@NotNull BitmapPool pool, @NotNull BufferedSource source, @NotNull Size size2, @NotNull Options options, @NotNull Continuation<? super DecodeResult> $completion) {
        void $this$toDrawable$iv$iv;
        void $this$toDrawable$iv;
        BitmapFactory.Options options2 = new BitmapFactory.Options();
        boolean bl = false;
        boolean bl2 = false;
        BitmapFactory.Options $this$run = options2;
        boolean bl3 = false;
        ExceptionCatchingSource safeSource = new ExceptionCatchingSource((Source)source);
        BufferedSource safeBufferedSource = Okio.buffer((Source)((Source)safeSource));
        $this$run.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)safeBufferedSource.peek().inputStream(), null, (BitmapFactory.Options)$this$run);
        Exception exception = safeSource.getException();
        if (exception != null) {
            Exception exception2 = exception;
            boolean bl4 = false;
            boolean bl5 = false;
            Exception it = exception2;
            boolean bl6 = false;
            throw (Throwable)it;
        }
        $this$run.inJustDecodeBounds = false;
        ExifInterface exifInterface = new ExifInterface((InputStream)new AlwaysAvailableInputStream(safeBufferedSource.peek().inputStream()));
        boolean isFlipped = exifInterface.isFlipped();
        int rotationDegrees = exifInterface.getRotationDegrees();
        boolean isRotated = rotationDegrees > 0;
        boolean isSwapped = rotationDegrees == 90 || rotationDegrees == 270;
        int srcWidth = isSwapped ? $this$run.outHeight : $this$run.outWidth;
        int srcHeight = isSwapped ? $this$run.outWidth : $this$run.outHeight;
        Bitmap.Config safeConfig = isFlipped || isRotated ? ExtensionsKt.normalize(options.getConfig()) : options.getConfig();
        Bitmap.Config config = $this$run.inPreferredConfig = this.allowRgb565(options.getAllowRgb565(), safeConfig, $this$run.outMimeType) ? Bitmap.Config.RGB_565 : safeConfig;
        if (Build.VERSION.SDK_INT >= 26 && options.getColorSpace() != null) {
            $this$run.inPreferredColorSpace = options.getColorSpace();
        }
        $this$run.inMutable = Build.VERSION.SDK_INT < 26 || $this$run.inPreferredConfig != Bitmap.Config.HARDWARE;
        $this$run.inScaled = false;
        if ($this$run.outWidth <= 0 || $this$run.outHeight <= 0) {
            $this$run.inSampleSize = 1;
            $this$run.inBitmap = null;
        } else if (!(size2 instanceof PixelSize)) {
            $this$run.inSampleSize = 1;
            if ($this$run.inMutable) {
                int n = $this$run.outWidth;
                int n2 = $this$run.outHeight;
                Bitmap.Config config2 = $this$run.inPreferredConfig;
                Intrinsics.checkExpressionValueIsNotNull((Object)config2, (String)"inPreferredConfig");
                $this$run.inBitmap = pool.getDirtyOrNull(n, n2, config2);
            }
        } else if (Build.VERSION.SDK_INT >= 19) {
            void width;
            PixelSize pixelSize = (PixelSize)size2;
            int n = pixelSize.component1();
            int height22 = pixelSize.component2();
            $this$run.inSampleSize = DecodeUtils.calculateInSampleSize(srcWidth, srcHeight, (int)width, height22, options.getScale());
            double rawScale = DecodeUtils.computeSizeMultiplier((double)srcWidth / (double)$this$run.inSampleSize, (double)srcHeight / (double)$this$run.inSampleSize, (double)width, (double)height22, options.getScale());
            double scale = options.getAllowInexactSize() ? RangesKt.coerceAtMost((double)rawScale, (double)1.0) : rawScale;
            boolean bl7 = $this$run.inScaled = scale != 1.0;
            if ($this$run.inScaled) {
                if (scale > 1.0) {
                    $this$run.inDensity = MathKt.roundToInt((double)((double)Integer.MAX_VALUE / scale));
                    $this$run.inTargetDensity = Integer.MAX_VALUE;
                } else {
                    $this$run.inDensity = Integer.MAX_VALUE;
                    $this$run.inTargetDensity = MathKt.roundToInt((double)((double)Integer.MAX_VALUE * scale));
                }
            }
            if ($this$run.inMutable) {
                double sampledOutWidth = (double)$this$run.outWidth / (double)$this$run.inSampleSize;
                double sampledOutHeight = (double)$this$run.outHeight / (double)$this$run.inSampleSize;
                double d = scale * sampledOutWidth + 0.5;
                BitmapPool bitmapPool = pool;
                BitmapFactory.Options options3 = $this$run;
                boolean bl8 = false;
                double d2 = Math.ceil(d);
                d = scale * sampledOutHeight + 0.5;
                int n3 = (int)d2;
                bl8 = false;
                double d3 = Math.ceil(d);
                int n4 = (int)d3;
                Bitmap.Config config3 = $this$run.inPreferredConfig;
                Intrinsics.checkExpressionValueIsNotNull((Object)config3, (String)"inPreferredConfig");
                options3.inBitmap = bitmapPool.getDirtyOrNull(n3, n4, config3);
            }
        } else {
            if ($this$run.inMutable) {
                int n = $this$run.outWidth;
                int n5 = $this$run.outHeight;
                Bitmap.Config config4 = $this$run.inPreferredConfig;
                Intrinsics.checkExpressionValueIsNotNull((Object)config4, (String)"inPreferredConfig");
                $this$run.inBitmap = pool.getDirtyOrNull(n, n5, config4);
            }
            $this$run.inSampleSize = $this$run.inBitmap != null ? 1 : DecodeUtils.calculateInSampleSize(srcWidth, srcHeight, ((PixelSize)size2).getWidth(), ((PixelSize)size2).getHeight(), options.getScale());
        }
        Object height22 = (Closeable)safeBufferedSource;
        boolean bl9 = false;
        Throwable throwable = null;
        try {
            BufferedSource it = (BufferedSource)height22;
            boolean bl10 = false;
            it = BitmapFactory.decodeStream((InputStream)it.inputStream(), null, (BitmapFactory.Options)$this$run);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)height22, (Throwable)throwable);
        }
        BufferedSource rawBitmap = it;
        Exception exception3 = safeSource.getException();
        if (exception3 != null) {
            height22 = exception3;
            bl9 = false;
            boolean bl11 = false;
            Object exception4 = height22;
            boolean bl12 = false;
            BufferedSource bufferedSource = rawBitmap;
            if (bufferedSource != null) {
                BufferedSource bufferedSource2 = bufferedSource;
                BitmapPool bitmapPool = pool;
                boolean bl13 = false;
                boolean bl14 = false;
                BufferedSource p1 = bufferedSource2;
                boolean bl15 = false;
                bitmapPool.put((Bitmap)p1);
            }
            throw (Throwable)exception4;
        }
        boolean height22 = false;
        bl9 = false;
        if (rawBitmap == null) {
            boolean bl16 = false;
            String string = "BitmapFactory returned a null Bitmap. Often this means BitmapFactory could not decode the image data read from the input source (e.g. network or disk) as it's not encoded as a valid image format.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Bitmap.Config config5 = $this$run.inPreferredConfig;
        Intrinsics.checkExpressionValueIsNotNull((Object)config5, (String)"inPreferredConfig");
        Bitmap bitmap = this.applyExifTransformations(pool, (Bitmap)rawBitmap, config5, isFlipped, rotationDegrees);
        bitmap.setDensity(0);
        Bitmap bitmap2 = bitmap;
        Context context$iv = this.context;
        boolean $i$f$toDrawable = false;
        void bl12 = $this$toDrawable$iv;
        Resources resources = context$iv.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        Resources resources$iv$iv = resources;
        boolean $i$f$toDrawable2 = false;
        BitmapDrawable bitmapDrawable = new BitmapDrawable(resources$iv$iv, (Bitmap)$this$toDrawable$iv$iv);
        boolean bl17 = $this$run.inSampleSize > 1 || $this$run.inScaled;
        Drawable drawable = (Drawable)bitmapDrawable;
        return new DecodeResult(drawable, bl17);
    }

    private final boolean allowRgb565(boolean allowRgb565, Bitmap.Config config, String mimeType) {
        return allowRgb565 && (Build.VERSION.SDK_INT < 26 || config == Bitmap.Config.ARGB_8888) && Intrinsics.areEqual((Object)mimeType, (Object)MIME_TYPE_JPEG);
    }

    private final Bitmap applyExifTransformations(BitmapPool pool, Bitmap inBitmap, Bitmap.Config config, boolean isFlipped, int rotationDegrees) {
        Canvas c$iv;
        Bitmap outBitmap;
        boolean isRotated;
        boolean bl = isRotated = rotationDegrees > 0;
        if (!isFlipped && !isRotated) {
            return inBitmap;
        }
        Matrix matrix = new Matrix();
        float centerX = (float)inBitmap.getWidth() / 2.0f;
        float centerY = (float)inBitmap.getHeight() / 2.0f;
        if (isFlipped) {
            matrix.postScale(-1.0f, 1.0f, centerX, centerY);
        }
        if (isRotated) {
            matrix.postRotate((float)rotationDegrees, centerX, centerY);
        }
        RectF rect = new RectF(0.0f, 0.0f, (float)inBitmap.getWidth(), (float)inBitmap.getHeight());
        matrix.mapRect(rect);
        if (rect.left != 0.0f || rect.top != 0.0f) {
            matrix.postTranslate(-rect.left, -rect.top);
        }
        Bitmap $this$applyCanvas$iv = outBitmap = rotationDegrees == 90 || rotationDegrees == 270 ? pool.get(inBitmap.getHeight(), inBitmap.getWidth(), config) : pool.get(inBitmap.getWidth(), inBitmap.getHeight(), config);
        boolean $i$f$applyCanvas = false;
        Canvas $this$applyCanvas = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl2 = false;
        $this$applyCanvas.drawBitmap(inBitmap, matrix, this.paint);
        pool.put(inBitmap);
        return outBitmap;
    }

    public BitmapFactoryDecoder(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.paint = new Paint(3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016R.\u0010\b\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\u000e\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcoil/decode/BitmapFactoryDecoder$ExceptionCatchingSource;", "Lokio/ForwardingSource;", "delegate", "Lokio/Source;", "(Lokio/Source;)V", "<set-?>", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "getException", "()Ljava/lang/Exception;", "read", "", "sink", "Lokio/Buffer;", "byteCount", "coil-base_release"})
    private static final class ExceptionCatchingSource
    extends ForwardingSource {
        @Nullable
        private Exception exception;

        @Nullable
        public final Exception getException() {
            return this.exception;
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
            try {
                return super.read(sink, byteCount);
            }
            catch (Exception e) {
                this.exception = e;
                throw (Throwable)e;
            }
        }

        public ExceptionCatchingSource(@NotNull Source delegate) {
            Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
            super(delegate);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcoil/decode/BitmapFactoryDecoder$AlwaysAvailableInputStream;", "Ljava/io/InputStream;", "delegate", "(Ljava/io/InputStream;)V", "available", "", "close", "", "mark", "readlimit", "markSupported", "", "read", "b", "", "off", "len", "reset", "skip", "", "n", "coil-base_release"})
    private static final class AlwaysAvailableInputStream
    extends InputStream {
        private final InputStream delegate;

        @Override
        public int read() {
            return this.delegate.read();
        }

        @Override
        public int read(@NotNull byte[] b) {
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            return this.delegate.read(b);
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) {
            return this.delegate.skip(n);
        }

        @Override
        public int available() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        public AlwaysAvailableInputStream(@NotNull InputStream delegate) {
            Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/decode/BitmapFactoryDecoder$Companion;", "", "()V", "MIME_TYPE_JPEG", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

