/*
 * Decompiled with CFR 0.152.
 */
package coil.bitmappool.strategy;

import android.graphics.Bitmap;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import coil.bitmappool.strategy.BitmapPoolStrategy;
import coil.collection.GroupedLinkedMap;
import coil.util.ExtensionsKt;
import coil.util.Utils;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J&\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u000f\u001a\u00020\u00052\b\b\u0001\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J$\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u000f\u001a\u00020\u00052\b\b\u0001\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcoil/bitmappool/strategy/SizeStrategy;", "Lcoil/bitmappool/strategy/BitmapPoolStrategy;", "()V", "groupedMap", "Lcoil/collection/GroupedLinkedMap;", "", "Landroid/graphics/Bitmap;", "sortedSizes", "Ljava/util/TreeMap;", "decrementBitmapOfSize", "", "size", "removed", "findBestSize", "get", "width", "height", "config", "Landroid/graphics/Bitmap$Config;", "logBitmap", "", "bitmap", "put", "removeLast", "toString", "Companion", "coil-base_release"})
@RequiresApi(value=23)
public final class SizeStrategy
implements BitmapPoolStrategy {
    private final GroupedLinkedMap<Integer, Bitmap> groupedMap = new GroupedLinkedMap();
    private final TreeMap<Integer, Integer> sortedSizes = new TreeMap();
    private static final int MAX_SIZE_MULTIPLE = 8;
    public static final Companion Companion = new Companion(null);

    @Override
    public void put(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int size2 = ExtensionsKt.getAllocationByteCountCompat(bitmap);
        this.groupedMap.set(size2, bitmap);
        Integer current = this.sortedSizes.get(size2);
        ((Map)this.sortedSizes).put(size2, current == null ? 1 : current + 1);
    }

    @Override
    @Nullable
    public Bitmap get(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        int size2 = Utils.INSTANCE.calculateAllocationByteCount(width, height, config);
        int bestSize = this.findBestSize(size2);
        Bitmap result = this.groupedMap.get(bestSize);
        if (result != null) {
            this.decrementBitmapOfSize(bestSize, result);
            result.reconfigure(width, height, config);
        }
        return result;
    }

    private final int findBestSize(int size2) {
        Integer possibleSize = this.sortedSizes.ceilingKey(size2);
        return possibleSize != null && possibleSize <= size2 * 8 ? possibleSize : size2;
    }

    @Override
    @Nullable
    public Bitmap removeLast() {
        Bitmap removed = this.groupedMap.removeLast();
        if (removed != null) {
            this.decrementBitmapOfSize(ExtensionsKt.getAllocationByteCountCompat(removed), removed);
        }
        return removed;
    }

    private final void decrementBitmapOfSize(int size2, Bitmap removed) {
        Integer n = this.sortedSizes.get(size2);
        if (n == null) {
            SizeStrategy sizeStrategy = this;
            boolean bl = false;
            boolean bl2 = false;
            SizeStrategy $this$run = sizeStrategy;
            boolean bl3 = false;
            throw (Throwable)new NullPointerException("Tried to decrement empty size, size: " + size2 + ", " + "removed: " + $this$run.logBitmap(removed) + ", this: " + $this$run);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"sortedSizes[size] ?: run\u2026, this: $this\")\n        }");
        int current = n;
        if (current == 1) {
            this.sortedSizes.remove(size2);
        } else {
            ((Map)this.sortedSizes).put(size2, current - 1);
        }
    }

    @Override
    @NotNull
    public String logBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Companion companion = Companion;
        int size$iv = ExtensionsKt.getAllocationByteCountCompat(bitmap);
        boolean $i$f$getBitmapString = false;
        return "" + '[' + size$iv + ']';
    }

    @Override
    @NotNull
    public String logBitmap(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        int size2 = Utils.INSTANCE.calculateAllocationByteCount(width, height, config);
        Companion this_$iv = Companion;
        boolean $i$f$getBitmapString = false;
        return "" + '[' + size2 + ']';
    }

    @NotNull
    public String toString() {
        return "SizeStrategy: groupedMap=" + this.groupedMap + ", sortedSizes=(" + this.sortedSizes + ')';
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0082\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcoil/bitmappool/strategy/SizeStrategy$Companion;", "", "()V", "MAX_SIZE_MULTIPLE", "", "getBitmapString", "", "size", "coil-base_release"})
    public static final class Companion {
        private final String getBitmapString(int size2) {
            int $i$f$getBitmapString = 0;
            return "" + '[' + size2 + ']';
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$getBitmapString(Companion $this, int size2) {
            return $this.getBitmapString(size2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

