/*
 * Decompiled with CFR 0.152.
 */
package coil.drawable;

import android.content.res.ColorStateList;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import coil.decode.DecodeUtils;
import coil.size.Scale;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 L2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001LB-\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J!\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\tH\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0017J\b\u0010%\u001a\u00020\tH\u0016J\b\u0010&\u001a\u00020\tH\u0016J\b\u0010'\u001a\u00020\tH\u0016J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u0001H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u001aH\u0002J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020/H\u0014J\u0010\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\rH\u0016J \u00102\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u00012\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0017H\u0016J\u0010\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\tH\u0016J\u0012\u00108\u001a\u00020\u001a2\b\u00109\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\tH\u0017J\u0012\u0010<\u001a\u00020\u001a2\b\u0010=\u001a\u0004\u0018\u00010>H\u0017J\u0012\u0010?\u001a\u00020\u001a2\b\u0010@\u001a\u0004\u0018\u00010AH\u0017J\u0012\u0010B\u001a\u00020\u001a2\b\u0010C\u001a\u0004\u0018\u00010DH\u0017J\b\u0010\u0004\u001a\u00020\u001aH\u0016J\b\u0010E\u001a\u00020\u001aH\u0016J\u0010\u0010F\u001a\u00020+2\u0006\u00101\u001a\u00020\rH\u0016J\u0018\u0010G\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u00012\u0006\u00103\u001a\u000204H\u0016J\u001d\u0010H\u001a\u00020\u00112\u0006\u0010I\u001a\u00020\u00012\u0006\u0010J\u001a\u00020/H\u0001\u00a2\u0006\u0002\bKR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcoil/drawable/CrossfadeDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Drawable$Callback;", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat;", "start", "end", "scale", "Lcoil/size/Scale;", "durationMillis", "", "(Landroid/graphics/drawable/Drawable;Landroid/graphics/drawable/Drawable;Lcoil/size/Scale;I)V", "callbacks", "", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat$AnimationCallback;", "getEnd", "()Landroid/graphics/drawable/Drawable;", "endScale", "", "intrinsicHeight", "intrinsicWidth", "maxAlpha", "startScale", "startTimeMillis", "", "state", "clearAnimationCallbacks", "", "computeIntrinsicDimension", "startSize", "endSize", "(Ljava/lang/Integer;Ljava/lang/Integer;)I", "draw", "canvas", "Landroid/graphics/Canvas;", "getAlpha", "getColorFilter", "Landroid/graphics/ColorFilter;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "invalidateDrawable", "who", "isRunning", "", "markDone", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "registerAnimationCallback", "callback", "scheduleDrawable", "what", "Ljava/lang/Runnable;", "when", "setAlpha", "alpha", "setColorFilter", "colorFilter", "setTint", "tintColor", "setTintBlendMode", "blendMode", "Landroid/graphics/BlendMode;", "setTintList", "tint", "Landroid/content/res/ColorStateList;", "setTintMode", "tintMode", "Landroid/graphics/PorterDuff$Mode;", "stop", "unregisterAnimationCallback", "unscheduleDrawable", "updateBounds", "drawable", "targetBounds", "updateBounds$coil_base_release", "Companion", "coil-base_release"})
public final class CrossfadeDrawable
extends Drawable
implements Drawable.Callback,
Animatable2Compat {
    private final List<Animatable2Compat.AnimationCallback> callbacks;
    private final int intrinsicWidth;
    private final int intrinsicHeight;
    private long startTimeMillis;
    private int maxAlpha;
    private int state;
    private float startScale;
    private float endScale;
    private Drawable start;
    @Nullable
    private final Drawable end;
    private final Scale scale;
    private final int durationMillis;
    private static final int STATE_START = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_DONE = 2;
    public static final int DEFAULT_DURATION = 100;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NotNull Canvas canvas) {
        Canvas $this$withSave;
        int checkpoint$iv;
        boolean $i$f$withSave;
        Canvas $this$withSave$iv;
        Drawable $this$apply;
        boolean bl;
        boolean bl2;
        Drawable drawable;
        boolean isDone;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.state == 0) {
            Drawable drawable2 = this.start;
            if (drawable2 != null) {
                Drawable drawable3 = drawable2;
                boolean bl3 = false;
                boolean bl4 = false;
                Drawable $this$apply2 = drawable3;
                boolean bl5 = false;
                $this$apply2.setAlpha(this.maxAlpha);
                Canvas $this$withSave$iv2 = canvas;
                boolean $i$f$withSave2 = false;
                int checkpoint$iv2 = $this$withSave$iv2.save();
                try {
                    Canvas $this$withSave2 = $this$withSave$iv2;
                    boolean bl6 = false;
                    $this$withSave2.scale(this.startScale, this.startScale);
                    $this$apply2.draw($this$withSave2);
                }
                finally {
                    $this$withSave$iv2.restoreToCount(checkpoint$iv2);
                }
            }
            return;
        }
        if (this.state == 2) {
            Drawable drawable4 = this.end;
            if (drawable4 != null) {
                Drawable drawable5 = drawable4;
                boolean bl7 = false;
                boolean bl8 = false;
                Drawable $this$apply3 = drawable5;
                boolean bl9 = false;
                $this$apply3.setAlpha(this.maxAlpha);
                Canvas $this$withSave$iv3 = canvas;
                boolean $i$f$withSave3 = false;
                int checkpoint$iv3 = $this$withSave$iv3.save();
                try {
                    Canvas $this$withSave3 = $this$withSave$iv3;
                    boolean bl10 = false;
                    $this$withSave3.scale(this.endScale, this.endScale);
                    $this$apply3.draw($this$withSave3);
                }
                finally {
                    $this$withSave$iv3.restoreToCount(checkpoint$iv3);
                }
            }
            return;
        }
        double percent = (double)(SystemClock.uptimeMillis() - this.startTimeMillis) / (double)this.durationMillis;
        boolean bl11 = isDone = percent >= 1.0;
        if (!isDone) {
            Drawable drawable6 = this.start;
            if (drawable6 != null) {
                drawable = drawable6;
                bl2 = false;
                bl = false;
                $this$apply = drawable;
                boolean bl12 = false;
                $this$apply.setAlpha(this.maxAlpha);
                $this$withSave$iv = canvas;
                $i$f$withSave = false;
                checkpoint$iv = $this$withSave$iv.save();
                try {
                    $this$withSave = $this$withSave$iv;
                    boolean bl13 = false;
                    $this$withSave.scale(this.startScale, this.startScale);
                    $this$apply.draw($this$withSave);
                }
                finally {
                    $this$withSave$iv.restoreToCount(checkpoint$iv);
                }
            }
        }
        Drawable drawable7 = this.end;
        if (drawable7 != null) {
            drawable = drawable7;
            bl2 = false;
            bl = false;
            $this$apply = drawable;
            boolean bl14 = false;
            $this$apply.setAlpha((int)(RangesKt.coerceIn((double)percent, (double)0.0, (double)1.0) * (double)this.maxAlpha));
            $this$withSave$iv = canvas;
            $i$f$withSave = false;
            checkpoint$iv = $this$withSave$iv.save();
            try {
                $this$withSave = $this$withSave$iv;
                boolean bl15 = false;
                $this$withSave.scale(this.endScale, this.endScale);
                $this$apply.draw($this$withSave);
            }
            finally {
                $this$withSave$iv.restoreToCount(checkpoint$iv);
            }
        }
        if (isDone) {
            this.markDone();
        } else {
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.maxAlpha;
    }

    public void setAlpha(int alpha) {
        int n = alpha;
        n = 0 <= n && 255 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Invalid alpha: " + alpha;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.maxAlpha = alpha;
    }

    public int getOpacity() {
        Drawable start = this.start;
        Drawable end = this.end;
        if (this.state == 0) {
            Drawable drawable = start;
            return drawable != null ? drawable.getOpacity() : -2;
        }
        if (this.state == 2) {
            Drawable drawable = end;
            return drawable != null ? drawable.getOpacity() : -2;
        }
        return start != null && end != null ? Drawable.resolveOpacity((int)start.getOpacity(), (int)end.getOpacity()) : (start != null ? start.getOpacity() : (end != null ? end.getOpacity() : -2));
    }

    @RequiresApi(value=21)
    @Nullable
    public ColorFilter getColorFilter() {
        Drawable drawable;
        switch (this.state) {
            case 0: {
                Drawable drawable2 = this.start;
                if (drawable2 != null) {
                    drawable = drawable2.getColorFilter();
                    break;
                }
                drawable = null;
                break;
            }
            case 1: {
                drawable = this.end;
                if (drawable != null && (drawable = drawable.getColorFilter()) != null) break;
                Drawable drawable3 = this.start;
                if (drawable3 != null) {
                    drawable = drawable3.getColorFilter();
                    break;
                }
                drawable = null;
                break;
            }
            case 2: {
                Drawable drawable4 = this.end;
                if (drawable4 != null) {
                    drawable = drawable4.getColorFilter();
                    break;
                }
                drawable = null;
                break;
            }
            default: {
                drawable = null;
            }
        }
        return drawable;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        block1: {
            Drawable drawable = this.start;
            if (drawable != null) {
                drawable.setColorFilter(colorFilter);
            }
            Drawable drawable2 = this.end;
            if (drawable2 == null) break block1;
            drawable2.setColorFilter(colorFilter);
        }
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        float f;
        float f2;
        float f3;
        Drawable it;
        boolean bl;
        boolean bl2;
        CrossfadeDrawable crossfadeDrawable;
        Drawable drawable;
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        CrossfadeDrawable crossfadeDrawable2 = this;
        Drawable drawable2 = this.start;
        if (drawable2 != null) {
            drawable = drawable2;
            crossfadeDrawable = crossfadeDrawable2;
            bl2 = false;
            bl = false;
            it = drawable;
            boolean bl3 = false;
            f3 = this.updateBounds$coil_base_release(it, bounds);
            crossfadeDrawable2 = crossfadeDrawable;
            f2 = f3;
        } else {
            f2 = 1.0f;
        }
        crossfadeDrawable2.startScale = f2;
        CrossfadeDrawable crossfadeDrawable3 = this;
        Drawable drawable3 = this.end;
        if (drawable3 != null) {
            drawable = drawable3;
            crossfadeDrawable = crossfadeDrawable3;
            bl2 = false;
            bl = false;
            it = drawable;
            boolean bl4 = false;
            f3 = this.updateBounds$coil_base_release(it, bounds);
            crossfadeDrawable3 = crossfadeDrawable;
            f = f3;
        } else {
            f = 1.0f;
        }
        crossfadeDrawable3.endScale = f;
    }

    public int getIntrinsicWidth() {
        return this.intrinsicWidth;
    }

    public int getIntrinsicHeight() {
        return this.intrinsicHeight;
    }

    public void unscheduleDrawable(@NotNull Drawable who, @NotNull Runnable what) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
        this.unscheduleSelf(what);
    }

    public void invalidateDrawable(@NotNull Drawable who) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        this.invalidateSelf();
    }

    public void scheduleDrawable(@NotNull Drawable who, @NotNull Runnable what, long when) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
        this.scheduleSelf(what, when);
    }

    @RequiresApi(value=21)
    public void setTint(int tintColor) {
        block1: {
            Drawable drawable = this.start;
            if (drawable != null) {
                drawable.setTint(tintColor);
            }
            Drawable drawable2 = this.end;
            if (drawable2 == null) break block1;
            drawable2.setTint(tintColor);
        }
    }

    @RequiresApi(value=21)
    public void setTintList(@Nullable ColorStateList tint) {
        block1: {
            Drawable drawable = this.start;
            if (drawable != null) {
                drawable.setTintList(tint);
            }
            Drawable drawable2 = this.end;
            if (drawable2 == null) break block1;
            drawable2.setTintList(tint);
        }
    }

    @RequiresApi(value=21)
    public void setTintMode(@Nullable PorterDuff.Mode tintMode) {
        block1: {
            Drawable drawable = this.start;
            if (drawable != null) {
                drawable.setTintMode(tintMode);
            }
            Drawable drawable2 = this.end;
            if (drawable2 == null) break block1;
            drawable2.setTintMode(tintMode);
        }
    }

    @RequiresApi(value=29)
    public void setTintBlendMode(@Nullable BlendMode blendMode) {
        block1: {
            Drawable drawable = this.start;
            if (drawable != null) {
                drawable.setTintBlendMode(blendMode);
            }
            Drawable drawable2 = this.end;
            if (drawable2 == null) break block1;
            drawable2.setTintBlendMode(blendMode);
        }
    }

    public boolean isRunning() {
        return this.state == 1;
    }

    public void start() {
        Drawable drawable;
        Drawable drawable2 = this.start;
        if (!(drawable2 instanceof Animatable)) {
            drawable2 = null;
        }
        Animatable animatable = (Animatable)drawable2;
        if (animatable != null) {
            animatable.start();
        }
        if (!((drawable = this.end) instanceof Animatable)) {
            drawable = null;
        }
        Animatable animatable2 = (Animatable)drawable;
        if (animatable2 != null) {
            animatable2.start();
        }
        if (this.state != 0) {
            return;
        }
        this.state = 1;
        this.startTimeMillis = SystemClock.uptimeMillis();
        Iterable $this$forEach$iv = this.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Animatable2Compat.AnimationCallback it = (Animatable2Compat.AnimationCallback)element$iv;
            boolean bl = false;
            it.onAnimationStart((Drawable)this);
        }
        this.invalidateSelf();
    }

    public void stop() {
        Drawable drawable;
        Drawable drawable2 = this.start;
        if (!(drawable2 instanceof Animatable)) {
            drawable2 = null;
        }
        Animatable animatable = (Animatable)drawable2;
        if (animatable != null) {
            animatable.stop();
        }
        if (!((drawable = this.end) instanceof Animatable)) {
            drawable = null;
        }
        Animatable animatable2 = (Animatable)drawable;
        if (animatable2 != null) {
            animatable2.stop();
        }
        if (this.state != 2) {
            this.markDone();
        }
    }

    public void registerAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.callbacks.add(callback);
    }

    public boolean unregisterAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        return this.callbacks.remove(callback);
    }

    public void clearAnimationCallbacks() {
        this.callbacks.clear();
    }

    @VisibleForTesting
    public final float updateBounds$coil_base_release(@NotNull Drawable drawable, @NotNull Rect targetBounds) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        Intrinsics.checkParameterIsNotNull((Object)targetBounds, (String)"targetBounds");
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        if (width <= 0 || height <= 0) {
            drawable.setBounds(targetBounds);
            return 1.0f;
        }
        int targetWidth = targetBounds.width();
        int targetHeight = targetBounds.height();
        double multiplier = DecodeUtils.computeSizeMultiplier(width, height, targetWidth, targetHeight, this.scale);
        int dx = MathKt.roundToInt((double)(((double)targetWidth - multiplier * (double)width) / (double)2));
        int dy = MathKt.roundToInt((double)(((double)targetHeight - multiplier * (double)height) / (double)2));
        if (drawable instanceof BitmapDrawable) {
            int left = targetBounds.left + dx;
            int top = targetBounds.top + dy;
            int right = targetBounds.right - dx;
            int bottom = targetBounds.bottom - dy;
            drawable.setBounds(left, top, right, bottom);
            return 1.0f;
        }
        int left = targetBounds.left + dx;
        int top = targetBounds.top + dy;
        int right = left + width;
        int bottom = top + height;
        drawable.setBounds(left, top, right, bottom);
        return (float)multiplier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int computeIntrinsicDimension(Integer startSize, Integer endSize) {
        Integer n = startSize;
        if (n != null) {
            if (n == -1) return -1;
        }
        Integer n2 = endSize;
        if (n2 != null && n2 == -1) {
            return -1;
        }
        Integer n3 = startSize;
        int n4 = n3 != null ? n3 : -1;
        Integer n5 = endSize;
        int n6 = n5 != null ? n5 : -1;
        boolean bl = false;
        int n7 = Math.max(n4, n6);
        return n7;
    }

    private final void markDone() {
        this.state = 2;
        this.start = null;
        Iterable $this$forEach$iv = this.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Animatable2Compat.AnimationCallback it = (Animatable2Compat.AnimationCallback)element$iv;
            boolean bl = false;
            it.onAnimationEnd((Drawable)this);
        }
    }

    @Nullable
    public final Drawable getEnd() {
        return this.end;
    }

    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end, @NotNull Scale scale, int durationMillis) {
        block2: {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)((Object)scale), (String)"scale");
            this.start = start;
            this.end = end;
            this.scale = scale;
            this.durationMillis = durationMillis;
            CrossfadeDrawable crossfadeDrawable = this;
            boolean bl = false;
            crossfadeDrawable.callbacks = list = (List)new ArrayList();
            Drawable drawable = this.start;
            Drawable drawable2 = this.end;
            this.intrinsicWidth = this.computeIntrinsicDimension(drawable != null ? Integer.valueOf(drawable.getIntrinsicWidth()) : null, drawable2 != null ? Integer.valueOf(drawable2.getIntrinsicWidth()) : null);
            Drawable drawable3 = this.start;
            Drawable drawable4 = this.end;
            this.intrinsicHeight = this.computeIntrinsicDimension(drawable3 != null ? Integer.valueOf(drawable3.getIntrinsicHeight()) : null, drawable4 != null ? Integer.valueOf(drawable4.getIntrinsicHeight()) : null);
            this.maxAlpha = 255;
            this.startScale = 1.0f;
            this.endScale = 1.0f;
            bl = this.durationMillis > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "durationMillis must be > 0.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Drawable drawable5 = this.start;
            if (drawable5 != null) {
                drawable5.setCallback((Drawable.Callback)this);
            }
            Drawable drawable6 = this.end;
            if (drawable6 == null) break block2;
            drawable6.setCallback((Drawable.Callback)this);
        }
    }

    public /* synthetic */ CrossfadeDrawable(Drawable drawable, Drawable drawable2, Scale scale, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            scale = Scale.FIT;
        }
        if ((n2 & 8) != 0) {
            n = 100;
        }
        this(drawable, drawable2, scale, n);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcoil/drawable/CrossfadeDrawable$Companion;", "", "()V", "DEFAULT_DURATION", "", "STATE_DONE", "STATE_RUNNING", "STATE_START", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

