/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import androidx.annotation.Px;
import coil.decode.DecodeUtils$WhenMappings;
import coil.size.Scale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\b\b\u0001\u0010\u000b\u001a\u00020\t2\b\b\u0001\u0010\f\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J8\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\n\u001a\u00020\u00112\b\b\u0001\u0010\u000b\u001a\u00020\u00112\b\b\u0001\u0010\f\u001a\u00020\u00112\b\b\u0001\u0010\r\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J8\u0010\u0010\u001a\u00020\u00122\b\b\u0001\u0010\n\u001a\u00020\u00122\b\b\u0001\u0010\u000b\u001a\u00020\u00122\b\b\u0001\u0010\f\u001a\u00020\u00122\b\b\u0001\u0010\r\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J8\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\n\u001a\u00020\t2\b\b\u0001\u0010\u000b\u001a\u00020\t2\b\b\u0001\u0010\f\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcoil/decode/DecodeUtils;", "", "()V", "GIF_HEADER", "Lokio/ByteString;", "WEBP_HEADER_RIFF", "WEBP_HEADER_VPX8", "WEBP_HEADER_WEBP", "calculateInSampleSize", "", "srcWidth", "srcHeight", "destWidth", "destHeight", "scale", "Lcoil/size/Scale;", "computeSizeMultiplier", "", "", "isAnimatedWebP", "", "source", "Lokio/BufferedSource;", "isGif", "isWebP", "coil-base_release"})
public final class DecodeUtils {
    private static final ByteString GIF_HEADER;
    private static final ByteString WEBP_HEADER_RIFF;
    private static final ByteString WEBP_HEADER_WEBP;
    private static final ByteString WEBP_HEADER_VPX8;
    public static final DecodeUtils INSTANCE;

    @JvmStatic
    public static final boolean isGif(@NotNull BufferedSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return source.rangeEquals(0L, GIF_HEADER);
    }

    @JvmStatic
    public static final boolean isWebP(@NotNull BufferedSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return source.rangeEquals(0L, WEBP_HEADER_RIFF) && source.rangeEquals(8L, WEBP_HEADER_WEBP);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isAnimatedWebP(@NotNull BufferedSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (!DecodeUtils.isWebP(source)) return false;
        if (!source.rangeEquals(12L, WEBP_HEADER_VPX8)) return false;
        if (!source.request(17L)) return false;
        byte by = source.getBuffer().getByte(16L);
        int n = 2;
        boolean bl = false;
        if ((byte)(by & n) <= 0) return false;
        return true;
    }

    @JvmStatic
    public static final int calculateInSampleSize(@Px int srcWidth, @Px int srcHeight, @Px int destWidth, @Px int destHeight, @NotNull Scale scale) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)((Object)scale), (String)"scale");
        int widthInSampleSize = RangesKt.coerceAtLeast((int)Integer.highestOneBit(srcWidth / destWidth), (int)1);
        int heightInSampleSize = RangesKt.coerceAtLeast((int)Integer.highestOneBit(srcHeight / destHeight), (int)1);
        switch (DecodeUtils$WhenMappings.$EnumSwitchMapping$0[scale.ordinal()]) {
            case 1: {
                boolean bl = false;
                n = Math.min(widthInSampleSize, heightInSampleSize);
                break;
            }
            case 2: {
                boolean bl = false;
                n = Math.max(widthInSampleSize, heightInSampleSize);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @JvmStatic
    public static final double computeSizeMultiplier(@Px int srcWidth, @Px int srcHeight, @Px int destWidth, @Px int destHeight, @NotNull Scale scale) {
        double d;
        Intrinsics.checkParameterIsNotNull((Object)((Object)scale), (String)"scale");
        double widthPercent = (double)destWidth / (double)srcWidth;
        double heightPercent = (double)destHeight / (double)srcHeight;
        switch (DecodeUtils$WhenMappings.$EnumSwitchMapping$1[scale.ordinal()]) {
            case 1: {
                boolean bl = false;
                d = Math.max(widthPercent, heightPercent);
                break;
            }
            case 2: {
                boolean bl = false;
                d = Math.min(widthPercent, heightPercent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @JvmStatic
    public static final float computeSizeMultiplier(@Px float srcWidth, @Px float srcHeight, @Px float destWidth, @Px float destHeight, @NotNull Scale scale) {
        float f;
        Intrinsics.checkParameterIsNotNull((Object)((Object)scale), (String)"scale");
        float widthPercent = destWidth / srcWidth;
        float heightPercent = destHeight / srcHeight;
        switch (DecodeUtils$WhenMappings.$EnumSwitchMapping$2[scale.ordinal()]) {
            case 1: {
                boolean bl = false;
                f = Math.max(widthPercent, heightPercent);
                break;
            }
            case 2: {
                boolean bl = false;
                f = Math.min(widthPercent, heightPercent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    @JvmStatic
    public static final double computeSizeMultiplier(@Px double srcWidth, @Px double srcHeight, @Px double destWidth, @Px double destHeight, @NotNull Scale scale) {
        double d;
        Intrinsics.checkParameterIsNotNull((Object)((Object)scale), (String)"scale");
        double widthPercent = destWidth / srcWidth;
        double heightPercent = destHeight / srcHeight;
        switch (DecodeUtils$WhenMappings.$EnumSwitchMapping$3[scale.ordinal()]) {
            case 1: {
                boolean bl = false;
                d = Math.max(widthPercent, heightPercent);
                break;
            }
            case 2: {
                boolean bl = false;
                d = Math.min(widthPercent, heightPercent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    private DecodeUtils() {
    }

    static {
        DecodeUtils decodeUtils;
        INSTANCE = decodeUtils = new DecodeUtils();
        GIF_HEADER = ByteString.Companion.encodeUtf8("GIF");
        WEBP_HEADER_RIFF = ByteString.Companion.encodeUtf8("RIFF");
        WEBP_HEADER_WEBP = ByteString.Companion.encodeUtf8("WEBP");
        WEBP_HEADER_VPX8 = ByteString.Companion.encodeUtf8("VP8X");
    }
}

