/*
 * Decompiled with CFR 0.152.
 */
package coil.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Xml;
import androidx.annotation.DrawableRes;
import androidx.annotation.XmlRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import coil.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u0002H\u0000\u001a\u001e\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0001\u001a\u0015\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0080\b\u001a\u001e\u0010\u000f\u001a\u0002H\u0010\"\n\b\u0000\u0010\u0010\u0018\u0001*\u00020\u0011*\u00020\u0002H\u0080\b\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"getDrawableCompat", "Landroid/graphics/drawable/Drawable;", "Landroid/content/Context;", "drawable", "resId", "", "getLifecycle", "Landroidx/lifecycle/Lifecycle;", "getXmlDrawableCompat", "resources", "Landroid/content/res/Resources;", "isPermissionGranted", "", "permission", "", "requireSystemService", "T", "", "(Landroid/content/Context;)Ljava/lang/Object;", "coil-base_release"})
public final class ContextsKt {
    @NotNull
    public static final Drawable getDrawableCompat(@NotNull Context $this$getDrawableCompat, @DrawableRes int resId) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getDrawableCompat, (String)"$this$getDrawableCompat");
        Drawable drawable = AppCompatResources.getDrawable((Context)$this$getDrawableCompat, (int)resId);
        boolean bl = false;
        boolean bl2 = false;
        if (drawable == null) {
            boolean bl3 = false;
            String string = "Invalid resource ID: " + resId;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return drawable;
    }

    @Nullable
    public static final Drawable getDrawableCompat(@NotNull Context $this$getDrawableCompat, @Nullable Drawable drawable, @DrawableRes int resId) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getDrawableCompat, (String)"$this$getDrawableCompat");
        Drawable drawable2 = drawable;
        boolean bl = false;
        boolean bl2 = false;
        Drawable it = drawable2;
        boolean bl3 = false;
        Object object = it != ExtensionsKt.getEMPTY_DRAWABLE() ? drawable2 : null;
        if (object == null) {
            object = resId != 0 ? ContextsKt.getDrawableCompat($this$getDrawableCompat, resId) : null;
        }
        return object;
    }

    @SuppressLint(value={"ResourceType"})
    @NotNull
    public static final Drawable getXmlDrawableCompat(@NotNull Context $this$getXmlDrawableCompat, @NotNull Resources resources, @XmlRes int resId) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getXmlDrawableCompat, (String)"$this$getXmlDrawableCompat");
        Intrinsics.checkParameterIsNotNull((Object)resources, (String)"resources");
        XmlResourceParser xmlResourceParser = resources.getXml(resId);
        Intrinsics.checkExpressionValueIsNotNull((Object)xmlResourceParser, (String)"resources.getXml(resId)");
        XmlResourceParser parser = xmlResourceParser;
        int type = parser.next();
        while (type != 2 && type != 1) {
            type = parser.next();
        }
        if (type != 2) {
            throw (Throwable)new XmlPullParserException("No start tag found.");
        }
        if (Build.VERSION.SDK_INT < 24) {
            String string = parser.getName();
            if (string != null) {
                switch (string) {
                    case "vector": {
                        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)((XmlPullParser)parser));
                        VectorDrawableCompat vectorDrawableCompat = VectorDrawableCompat.createFromXmlInner((Resources)resources, (XmlPullParser)((XmlPullParser)parser), (AttributeSet)attrs, (Resources.Theme)$this$getXmlDrawableCompat.getTheme());
                        Intrinsics.checkExpressionValueIsNotNull((Object)vectorDrawableCompat, (String)"VectorDrawableCompat.cre\u2026es, parser, attrs, theme)");
                        return (Drawable)vectorDrawableCompat;
                    }
                    case "animated-vector": {
                        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)((XmlPullParser)parser));
                        AnimatedVectorDrawableCompat animatedVectorDrawableCompat = AnimatedVectorDrawableCompat.createFromXmlInner((Context)$this$getXmlDrawableCompat, (Resources)resources, (XmlPullParser)((XmlPullParser)parser), (AttributeSet)attrs, (Resources.Theme)$this$getXmlDrawableCompat.getTheme());
                        Intrinsics.checkExpressionValueIsNotNull((Object)animatedVectorDrawableCompat, (String)"AnimatedVectorDrawableCo\u2026es, parser, attrs, theme)");
                        return (Drawable)animatedVectorDrawableCompat;
                    }
                }
            }
        }
        return ExtensionsKt.getDrawableCompat(resources, resId, $this$getXmlDrawableCompat.getTheme());
    }

    @Nullable
    public static final Lifecycle getLifecycle(@NotNull Context $this$getLifecycle) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getLifecycle, (String)"$this$getLifecycle");
        Context context = $this$getLifecycle;
        Context context2;
        while (!((context2 = context) instanceof LifecycleOwner)) {
            if (!(context2 instanceof ContextWrapper)) {
                return null;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return ((LifecycleOwner)context).getLifecycle();
    }

    @NotNull
    public static final /* synthetic */ <T> T requireSystemService(@NotNull Context $this$requireSystemService) {
        int $i$f$requireSystemService = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$requireSystemService, (String)"$this$requireSystemService");
        Context $this$getSystemService$iv = $this$requireSystemService;
        boolean $i$f$getSystemService = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object object = ContextCompat.getSystemService((Context)$this$getSystemService$iv, Object.class);
        boolean bl = false;
        boolean bl2 = false;
        if (object == null) {
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append("System service of type ");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            String string = stringBuilder.append(Object.class).append(" was not found.").toString();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (T)object;
    }

    public static final boolean isPermissionGranted(@NotNull Context $this$isPermissionGranted, @NotNull String permission) {
        int $i$f$isPermissionGranted = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$isPermissionGranted, (String)"$this$isPermissionGranted");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        return ContextCompat.checkSelfPermission((Context)$this$isPermissionGranted, (String)permission) == 0;
    }
}

