/*
 * Decompiled with CFR 0.152.
 */
package coil.transition;

import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import coil.annotation.ExperimentalCoilApi;
import coil.decode.DataSource;
import coil.drawable.CrossfadeDrawable;
import coil.request.ErrorResult;
import coil.request.RequestResult;
import coil.request.SuccessResult;
import coil.size.Scale;
import coil.transition.Transition;
import coil.transition.TransitionTarget;
import coil.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0014B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J%\u0010\u0010\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lcoil/transition/CrossfadeTransition;", "Lcoil/transition/Transition;", "durationMillis", "", "(I)V", "getDurationMillis", "()I", "createCrossfade", "Lcoil/drawable/CrossfadeDrawable;", "continuation", "Lkotlinx/coroutines/CancellableContinuation;", "", "target", "Lcoil/transition/TransitionTarget;", "drawable", "Landroid/graphics/drawable/Drawable;", "transition", "result", "Lcoil/request/RequestResult;", "(Lcoil/transition/TransitionTarget;Lcoil/request/RequestResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Callback", "coil-base_release"})
@ExperimentalCoilApi
public final class CrossfadeTransition
implements Transition {
    private final int durationMillis;

    @Override
    @Nullable
    public Object transition(@NotNull TransitionTarget<?> target2, @NotNull RequestResult result, @NotNull Continuation<? super Unit> $completion) {
        if (result instanceof SuccessResult && ((SuccessResult)result).getSource() == DataSource.MEMORY_CACHE) {
            target2.onSuccess(((SuccessResult)result).getDrawable());
            return Unit.INSTANCE;
        }
        Object $this$isVisible$iv = target2.getView();
        boolean $i$f$isVisible = false;
        if (!($this$isVisible$iv.getVisibility() == 0)) {
            $this$isVisible$iv = result;
            if ($this$isVisible$iv instanceof SuccessResult) {
                target2.onSuccess(((SuccessResult)result).getDrawable());
            } else if ($this$isVisible$iv instanceof ErrorResult) {
                target2.onError(result.getDrawable());
            }
            return Unit.INSTANCE;
        }
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        CrossfadeDrawable crossfadeDrawable = this.createCrossfade((CancellableContinuation<? super Unit>)continuation, target2, result.getDrawable());
        RequestResult requestResult = result;
        if (requestResult instanceof SuccessResult) {
            target2.onSuccess(crossfadeDrawable);
        } else if (requestResult instanceof ErrorResult) {
            target2.onError(crossfadeDrawable);
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final CrossfadeDrawable createCrossfade(CancellableContinuation<? super Unit> continuation, TransitionTarget<?> target2, Drawable drawable) {
        Object object;
        Drawable drawable2 = target2.getDrawable();
        Object t = target2.getView();
        if (!(t instanceof ImageView)) {
            t = null;
        }
        if ((object = (ImageView)t) == null || (object = ExtensionsKt.getScale(object)) == null) {
            object = Scale.FILL;
        }
        CrossfadeDrawable crossfade = new CrossfadeDrawable(drawable2, drawable, (Scale)((Object)object), this.durationMillis);
        Callback callback = new Callback(crossfade, continuation);
        crossfade.registerAnimationCallback(callback);
        continuation.invokeOnCancellation((Function1)callback);
        return crossfade;
    }

    public final int getDurationMillis() {
        return this.durationMillis;
    }

    @JvmOverloads
    public CrossfadeTransition(int durationMillis) {
        this.durationMillis = durationMillis;
        boolean bl = this.durationMillis > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "durationMillis must be > 0.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ CrossfadeTransition(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        this(n);
    }

    @JvmOverloads
    public CrossfadeTransition() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012#\u0012\u0015\u0012\u0013\u0018\u00010\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00070\u0002j\u0002`\bB\u001b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcoil/transition/CrossfadeTransition$Callback;", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat$AnimationCallback;", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "cause", "", "Lkotlinx/coroutines/CompletionHandler;", "crossfade", "Lcoil/drawable/CrossfadeDrawable;", "continuation", "Lkotlinx/coroutines/CancellableContinuation;", "(Lcoil/drawable/CrossfadeDrawable;Lkotlinx/coroutines/CancellableContinuation;)V", "invoke", "onAnimationEnd", "drawable", "Landroid/graphics/drawable/Drawable;", "coil-base_release"})
    private static final class Callback
    extends Animatable2Compat.AnimationCallback
    implements Function1<Throwable, Unit> {
        private final CrossfadeDrawable crossfade;
        private final CancellableContinuation<Unit> continuation;

        public void onAnimationEnd(@NotNull Drawable drawable) {
            Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
            this.crossfade.unregisterAnimationCallback(this);
            Continuation continuation = (Continuation)this.continuation;
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            Result.Companion companion = Result.Companion;
            Continuation continuation2 = continuation;
            boolean bl2 = false;
            Object object = Result.constructor-impl((Object)unit);
            continuation2.resumeWith(object);
        }

        public void invoke(@Nullable Throwable cause) {
            this.crossfade.stop();
        }

        public Callback(@NotNull CrossfadeDrawable crossfade, @NotNull CancellableContinuation<? super Unit> continuation) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)crossfade), (String)"crossfade");
            Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
            this.crossfade = crossfade;
            this.continuation = continuation;
        }
    }
}

