/*
 * Decompiled with CFR 0.152.
 */
package coil.transform;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import coil.bitmappool.BitmapPool;
import coil.size.Size;
import coil.transform.Transformation;
import coil.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J)\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lcoil/transform/CircleCropTransformation;", "Lcoil/transform/Transformation;", "()V", "key", "", "transform", "Landroid/graphics/Bitmap;", "pool", "Lcoil/bitmappool/BitmapPool;", "input", "size", "Lcoil/size/Size;", "(Lcoil/bitmappool/BitmapPool;Landroid/graphics/Bitmap;Lcoil/size/Size;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "coil-base_release"})
public final class CircleCropTransformation
implements Transformation {
    private static final PorterDuffXfermode XFERMODE;
    public static final Companion Companion;

    @Override
    @NotNull
    public String key() {
        String string = CircleCropTransformation.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CircleCropTransformation::class.java.name");
        return string;
    }

    @Override
    @Nullable
    public Object transform(@NotNull BitmapPool pool, @NotNull Bitmap input, @NotNull Size size2, @NotNull Continuation<? super Bitmap> $completion) {
        Canvas c$iv;
        Bitmap output;
        Paint paint = new Paint(3);
        int n = input.getWidth();
        int n2 = input.getHeight();
        boolean bl = false;
        int minSize = Math.min(n, n2);
        float radius = (float)minSize / 2.0f;
        Bitmap $this$applyCanvas$iv = output = pool.get(minSize, minSize, ExtensionsKt.getSafeConfig(input));
        boolean $i$f$applyCanvas = false;
        Canvas $this$applyCanvas = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl2 = false;
        $this$applyCanvas.drawCircle(radius, radius, radius, paint);
        paint.setXfermode((Xfermode)XFERMODE);
        $this$applyCanvas.drawBitmap(input, radius - (float)input.getWidth() / 2.0f, radius - (float)input.getHeight() / 2.0f, paint);
        pool.put(input);
        return output;
    }

    static {
        Companion = new Companion(null);
        XFERMODE = new PorterDuffXfermode(PorterDuff.Mode.SRC_IN);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/transform/CircleCropTransformation$Companion;", "", "()V", "XFERMODE", "Landroid/graphics/PorterDuffXfermode;", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

