/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import coil.memory.MemoryCache;
import coil.memory.RealWeakMemoryCache;
import coil.memory.WeakMemoryCache;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 %2\u00020\u0001:\u0003%&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0014\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J(\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000eH\u0016J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u000eH\u0016RX\u0010\u0003\u001a>\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b0\u0004j\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b`\t8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u00020\u000e8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lcoil/memory/RealWeakMemoryCache;", "Lcoil/memory/WeakMemoryCache;", "()V", "cache", "Ljava/util/HashMap;", "Lcoil/memory/MemoryCache$Key;", "Ljava/util/ArrayList;", "Lcoil/memory/RealWeakMemoryCache$WeakValue;", "Lkotlin/collections/ArrayList;", "Lkotlin/collections/HashMap;", "cache$annotations", "getCache$coil_base_release", "()Ljava/util/HashMap;", "operationsSinceCleanUp", "", "operationsSinceCleanUp$annotations", "getOperationsSinceCleanUp$coil_base_release", "()I", "setOperationsSinceCleanUp$coil_base_release", "(I)V", "cleanUp", "", "cleanUp$coil_base_release", "cleanUpIfNecessary", "clearMemory", "get", "Lcoil/memory/MemoryCache$Value;", "key", "invalidate", "bitmap", "Landroid/graphics/Bitmap;", "set", "isSampled", "", "size", "trimMemory", "level", "Companion", "StrongValue", "WeakValue", "coil-base_release"})
public final class RealWeakMemoryCache
implements WeakMemoryCache {
    @NotNull
    private final HashMap<MemoryCache.Key, ArrayList<WeakValue>> cache = new HashMap();
    private int operationsSinceCleanUp;
    private static final int CLEAN_UP_INTERVAL = 10;
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting
    public static /* synthetic */ void cache$annotations() {
    }

    @NotNull
    public final HashMap<MemoryCache.Key, ArrayList<WeakValue>> getCache$coil_base_release() {
        return this.cache;
    }

    @VisibleForTesting
    public static /* synthetic */ void operationsSinceCleanUp$annotations() {
    }

    public final int getOperationsSinceCleanUp$coil_base_release() {
        return this.operationsSinceCleanUp;
    }

    public final void setOperationsSinceCleanUp$coil_base_release(int n) {
        this.operationsSinceCleanUp = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public MemoryCache.Value get(@NotNull MemoryCache.Key key) {
        StrongValue strongValue;
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            ArrayList<WeakValue> arrayList = this.cache.get(key);
            if (arrayList == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"cache[key] ?: return null");
            ArrayList<WeakValue> values = arrayList;
            List $this$firstNotNullIndices$iv = values;
            boolean $i$f$firstNotNullIndices = false;
            int n = 0;
            int n2 = ((Collection)$this$firstNotNullIndices$iv).size();
            while (n < n2) {
                StrongValue strongValue2;
                void i$iv;
                WeakValue value = (WeakValue)$this$firstNotNullIndices$iv.get((int)i$iv);
                boolean bl = false;
                if ((Bitmap)value.getReference().get() != null) {
                    Bitmap bitmap;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Bitmap bitmap2 = bitmap;
                    boolean bl4 = false;
                    Bitmap bitmap3 = bitmap2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"bitmap");
                    strongValue2 = new StrongValue(bitmap3, value.isSampled());
                } else {
                    strongValue2 = null;
                }
                if (strongValue2 != null) {
                    StrongValue strongValue3 = strongValue2;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    StrongValue it$iv = strongValue3;
                    boolean bl7 = false;
                    strongValue = it$iv;
                    break block5;
                }
                ++i$iv;
            }
            strongValue = null;
        }
        StrongValue strongValue4 = strongValue;
        this.cleanUpIfNecessary();
        return strongValue4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void set(@NotNull MemoryCache.Key key, @NotNull Bitmap bitmap, boolean isSampled, int size2) {
        ArrayList<WeakValue> values;
        ArrayList<WeakValue> rawValues;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            rawValues = this.cache.get(key);
            ArrayList<WeakValue> arrayList = rawValues;
            if (arrayList == null) {
                boolean bl = false;
                arrayList = new ArrayList<WeakValue>();
            }
            values = arrayList;
            RealWeakMemoryCache realWeakMemoryCache = this;
            boolean bl = false;
            boolean bl2 = false;
            RealWeakMemoryCache $this$run = realWeakMemoryCache;
            boolean bl3 = false;
            Bitmap $this$identityHashCode$iv22 = bitmap;
            boolean $i$f$getIdentityHashCode = false;
            int n = System.identityHashCode($this$identityHashCode$iv22);
            int n2 = size2;
            boolean bl4 = isSampled;
            WeakReference<Bitmap> weakReference = new WeakReference<Bitmap>(bitmap);
            int n3 = n;
            WeakValue value = new WeakValue(n3, weakReference, bl4, n2);
            int $this$identityHashCode$iv22 = 0;
            int n4 = ((Collection)values).size();
            while ($this$identityHashCode$iv22 < n4) {
                void index;
                if (size2 >= ((WeakValue)values.get((int)index)).getSize()) {
                    values.add((int)index, value);
                    break block4;
                }
                ++index;
            }
            Collection collection = values;
            n4 = 0;
            collection.add(value);
        }
        if (rawValues == null) {
            ((Map)this.cache).put(key, values);
        }
        this.cleanUpIfNecessary();
    }

    @Override
    public void invalidate(@NotNull MemoryCache.Key key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        MemoryCache.Value value = this.get(key);
        if (value != null) {
            this.invalidate(value.getBitmap());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void invalidate(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Bitmap $this$identityHashCode$iv = bitmap;
        boolean $i$f$getIdentityHashCode = false;
        int identityHashCode = System.identityHashCode($this$identityHashCode$iv);
        RealWeakMemoryCache realWeakMemoryCache = this;
        boolean bl = false;
        boolean bl2 = false;
        RealWeakMemoryCache $this$run = realWeakMemoryCache;
        boolean bl3 = false;
        Collection<ArrayList<WeakValue>> collection = $this$run.cache.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"cache.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        block0: for (Object element$iv : $this$forEach$iv) {
            ArrayList values = (ArrayList)element$iv;
            boolean bl4 = false;
            int n = 0;
            ArrayList arrayList = values;
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"values");
            int n2 = ((Collection)arrayList).size();
            while (n < n2) {
                void index;
                if (((WeakValue)values.get((int)index)).getIdentityHashCode() == identityHashCode) {
                    values.remove((int)index);
                    break block0;
                }
                ++index;
            }
        }
        this.cleanUpIfNecessary();
    }

    @Override
    public void clearMemory() {
        this.cache.clear();
    }

    @Override
    public void trimMemory(int level) {
        if (level >= 10 && level != 20) {
            this.cleanUp$coil_base_release();
        }
    }

    private final void cleanUpIfNecessary() {
        int n = this.operationsSinceCleanUp;
        this.operationsSinceCleanUp = n + 1;
        if (n >= 10) {
            this.cleanUp$coil_base_release();
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void cleanUp$coil_base_release() {
        this.operationsSinceCleanUp = 0;
        Iterator<ArrayList<WeakValue>> iterator = this.cache.values().iterator();
        while (iterator.hasNext()) {
            ArrayList<WeakValue> list;
            Intrinsics.checkExpressionValueIsNotNull(iterator.next(), (String)"iterator.next()");
            Collection collection = list;
            boolean bl = false;
            if (collection.size() <= 1) {
                Object object = (WeakValue)CollectionsKt.firstOrNull((List)list);
                if ((object != null && (object = ((WeakValue)object).getReference()) != null ? (Bitmap)((Reference)object).get() : null) != null) continue;
                iterator.remove();
                continue;
            }
            if (Build.VERSION.SDK_INT >= 24) {
                list.removeIf(cleanUp.1.INSTANCE);
            } else {
                List $this$removeIfIndices$iv = list;
                boolean $i$f$removeIfIndices = false;
                int numDeleted$iv = 0;
                int n = 0;
                int n2 = ((Collection)$this$removeIfIndices$iv).size();
                while (n < n2) {
                    void rawIndex$iv;
                    void index$iv = rawIndex$iv - numDeleted$iv;
                    Object value$iv = $this$removeIfIndices$iv.get((int)index$iv);
                    WeakValue it = (WeakValue)value$iv;
                    boolean bl2 = false;
                    if (it.getReference().get() == null) {
                        $this$removeIfIndices$iv.remove((int)index$iv);
                        ++numDeleted$iv;
                    }
                    ++rawIndex$iv;
                }
            }
            if (!list.isEmpty()) continue;
            iterator.remove();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0001\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"Lcoil/memory/RealWeakMemoryCache$WeakValue;", "", "identityHashCode", "", "reference", "Ljava/lang/ref/WeakReference;", "Landroid/graphics/Bitmap;", "isSampled", "", "size", "(ILjava/lang/ref/WeakReference;ZI)V", "getIdentityHashCode", "()I", "()Z", "getReference", "()Ljava/lang/ref/WeakReference;", "getSize", "coil-base_release"})
    @VisibleForTesting
    public static final class WeakValue {
        private final int identityHashCode;
        @NotNull
        private final WeakReference<Bitmap> reference;
        private final boolean isSampled;
        private final int size;

        public final int getIdentityHashCode() {
            return this.identityHashCode;
        }

        @NotNull
        public final WeakReference<Bitmap> getReference() {
            return this.reference;
        }

        public final boolean isSampled() {
            return this.isSampled;
        }

        public final int getSize() {
            return this.size;
        }

        public WeakValue(int identityHashCode, @NotNull WeakReference<Bitmap> reference, boolean isSampled, int size2) {
            Intrinsics.checkParameterIsNotNull(reference, (String)"reference");
            this.identityHashCode = identityHashCode;
            this.reference = reference;
            this.isSampled = isSampled;
            this.size = size2;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\n"}, d2={"Lcoil/memory/RealWeakMemoryCache$StrongValue;", "Lcoil/memory/MemoryCache$Value;", "bitmap", "Landroid/graphics/Bitmap;", "isSampled", "", "(Landroid/graphics/Bitmap;Z)V", "getBitmap", "()Landroid/graphics/Bitmap;", "()Z", "coil-base_release"})
    private static final class StrongValue
    implements MemoryCache.Value {
        @NotNull
        private final Bitmap bitmap;
        private final boolean isSampled;

        @Override
        @NotNull
        public Bitmap getBitmap() {
            return this.bitmap;
        }

        @Override
        public boolean isSampled() {
            return this.isSampled;
        }

        public StrongValue(@NotNull Bitmap bitmap, boolean isSampled) {
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            this.bitmap = bitmap;
            this.isSampled = isSampled;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/memory/RealWeakMemoryCache$Companion;", "", "()V", "CLEAN_UP_INTERVAL", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

