/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.graphics.Bitmap;
import androidx.collection.LruCache;
import coil.memory.BitmapReferenceCounter;
import coil.memory.MemoryCache;
import coil.memory.RealMemoryCache;
import coil.memory.WeakMemoryCache;
import coil.util.ExtensionsKt;
import coil.util.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000M\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\f\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0007H\u0016R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcoil/memory/RealMemoryCache;", "Lcoil/memory/MemoryCache;", "weakMemoryCache", "Lcoil/memory/WeakMemoryCache;", "referenceCounter", "Lcoil/memory/BitmapReferenceCounter;", "maxSize", "", "logger", "Lcoil/util/Logger;", "(Lcoil/memory/WeakMemoryCache;Lcoil/memory/BitmapReferenceCounter;ILcoil/util/Logger;)V", "cache", "coil/memory/RealMemoryCache$cache$1", "Lcoil/memory/RealMemoryCache$cache$1;", "clearMemory", "", "get", "Lcoil/memory/MemoryCache$Value;", "key", "Lcoil/memory/MemoryCache$Key;", "invalidate", "set", "bitmap", "Landroid/graphics/Bitmap;", "isSampled", "", "size", "trimMemory", "level", "Companion", "InternalValue", "coil-base_release"})
final class RealMemoryCache
implements MemoryCache {
    private final cache.1 cache;
    private final WeakMemoryCache weakMemoryCache;
    private final BitmapReferenceCounter referenceCounter;
    private final Logger logger;
    private static final String TAG = "RealMemoryCache";
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public MemoryCache.Value get(@NotNull MemoryCache.Key key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        InternalValue internalValue = (InternalValue)this.cache.get(key);
        return internalValue != null ? (MemoryCache.Value)internalValue : this.weakMemoryCache.get(key);
    }

    @Override
    public void set(@NotNull MemoryCache.Key key, @NotNull Bitmap bitmap, boolean isSampled) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int size2 = ExtensionsKt.getAllocationByteCountCompat(bitmap);
        if (size2 > this.maxSize()) {
            InternalValue previous = (InternalValue)this.cache.remove(key);
            if (previous == null) {
                this.weakMemoryCache.set(key, bitmap, isSampled, size2);
            }
            return;
        }
        this.referenceCounter.increment(bitmap);
        this.cache.put(key, new InternalValue(bitmap, isSampled, size2));
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public int maxSize() {
        return this.cache.maxSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void invalidate(@NotNull MemoryCache.Key key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Logger logger = this.logger;
        if (logger != null) {
            void $this$log$iv;
            Logger logger2 = logger;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var8_7 = tag$iv;
                void var7_8 = $this$log$iv;
                boolean bl = false;
                String string2 = "invalidate, key=" + key;
                var7_8.log((String)var8_7, n, string2, null);
            }
        }
        this.cache.remove(key);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearMemory() {
        Logger logger = this.logger;
        if (logger != null) {
            void $this$log$iv;
            Logger logger2 = logger;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var7_6 = tag$iv;
                void var6_7 = $this$log$iv;
                boolean bl = false;
                String string2 = "clearMemory";
                var6_7.log((String)var7_6, n, string2, null);
            }
        }
        this.cache.trimToSize(-1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trimMemory(int level) {
        Logger logger = this.logger;
        if (logger != null) {
            void $this$log$iv;
            Logger logger2 = logger;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var8_8 = tag$iv;
                void var7_9 = $this$log$iv;
                boolean bl = false;
                String string2 = "trimMemory, level=" + level;
                var7_9.log((String)var8_8, n, string2, null);
            }
        }
        if (level >= 40) {
            this.clearMemory();
        } else {
            int n = level;
            if (10 <= n && 20 > n) {
                this.cache.trimToSize(this.size() / 2);
            }
        }
    }

    public RealMemoryCache(@NotNull WeakMemoryCache weakMemoryCache, @NotNull BitmapReferenceCounter referenceCounter, int maxSize, @Nullable Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)weakMemoryCache, (String)"weakMemoryCache");
        Intrinsics.checkParameterIsNotNull((Object)referenceCounter, (String)"referenceCounter");
        this.weakMemoryCache = weakMemoryCache;
        this.referenceCounter = referenceCounter;
        this.logger = logger;
        this.cache = new LruCache<MemoryCache.Key, InternalValue>(this, maxSize, maxSize){
            final /* synthetic */ RealMemoryCache this$0;
            final /* synthetic */ int $maxSize;

            protected void entryRemoved(boolean evicted, @NotNull MemoryCache.Key key, @NotNull InternalValue oldValue, @Nullable InternalValue newValue) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                Intrinsics.checkParameterIsNotNull((Object)oldValue, (String)"oldValue");
                boolean isPooled = RealMemoryCache.access$getReferenceCounter$p(this.this$0).decrement(oldValue.getBitmap());
                if (!isPooled) {
                    RealMemoryCache.access$getWeakMemoryCache$p(this.this$0).set(key, oldValue.getBitmap(), oldValue.isSampled(), oldValue.getSize());
                }
            }

            protected int sizeOf(@NotNull MemoryCache.Key key, @NotNull InternalValue value) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return value.getSize();
            }
            {
                this.this$0 = $outer;
                this.$maxSize = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    public static final /* synthetic */ BitmapReferenceCounter access$getReferenceCounter$p(RealMemoryCache $this) {
        return $this.referenceCounter;
    }

    public static final /* synthetic */ WeakMemoryCache access$getWeakMemoryCache$p(RealMemoryCache $this) {
        return $this.weakMemoryCache;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcoil/memory/RealMemoryCache$InternalValue;", "Lcoil/memory/MemoryCache$Value;", "bitmap", "Landroid/graphics/Bitmap;", "isSampled", "", "size", "", "(Landroid/graphics/Bitmap;ZI)V", "getBitmap", "()Landroid/graphics/Bitmap;", "()Z", "getSize", "()I", "coil-base_release"})
    private static final class InternalValue
    implements MemoryCache.Value {
        @NotNull
        private final Bitmap bitmap;
        private final boolean isSampled;
        private final int size;

        @Override
        @NotNull
        public Bitmap getBitmap() {
            return this.bitmap;
        }

        @Override
        public boolean isSampled() {
            return this.isSampled;
        }

        public final int getSize() {
            return this.size;
        }

        public InternalValue(@NotNull Bitmap bitmap, boolean isSampled, int size2) {
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            this.bitmap = bitmap;
            this.isSampled = isSampled;
            this.size = size2;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/memory/RealMemoryCache$Companion;", "", "()V", "TAG", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

