/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import androidx.annotation.MainThread;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import coil.EventListener;
import coil.ImageLoader;
import coil.memory.BaseRequestDelegate;
import coil.memory.BitmapReferenceCounter;
import coil.memory.EmptyRequestDelegate;
import coil.memory.EmptyTargetDelegate;
import coil.memory.InvalidatableEmptyTargetDelegate;
import coil.memory.InvalidatableTargetDelegate;
import coil.memory.PoolableTargetDelegate;
import coil.memory.RequestDelegate;
import coil.memory.TargetDelegate;
import coil.memory.ViewTargetRequestDelegate;
import coil.request.GetRequest;
import coil.request.LoadRequest;
import coil.request.Request;
import coil.target.PoolableViewTarget;
import coil.target.Target;
import coil.target.ViewTarget;
import coil.util.ExtensionsKt;
import coil.util.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0007J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcoil/memory/DelegateService;", "", "imageLoader", "Lcoil/ImageLoader;", "referenceCounter", "Lcoil/memory/BitmapReferenceCounter;", "logger", "Lcoil/util/Logger;", "(Lcoil/ImageLoader;Lcoil/memory/BitmapReferenceCounter;Lcoil/util/Logger;)V", "createRequestDelegate", "Lcoil/memory/RequestDelegate;", "request", "Lcoil/request/Request;", "targetDelegate", "Lcoil/memory/TargetDelegate;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "mainDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "deferred", "Lkotlinx/coroutines/Deferred;", "createTargetDelegate", "eventListener", "Lcoil/EventListener;", "coil-base_release"})
public final class DelegateService {
    private final ImageLoader imageLoader;
    private final BitmapReferenceCounter referenceCounter;
    private final Logger logger;

    @NotNull
    public final TargetDelegate createTargetDelegate(@NotNull Request request, @NotNull EventListener eventListener) {
        TargetDelegate targetDelegate;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)eventListener, (String)"eventListener");
        Request request2 = request;
        if (request2 instanceof GetRequest) {
            targetDelegate = new InvalidatableEmptyTargetDelegate(this.referenceCounter);
        } else if (request2 instanceof LoadRequest) {
            Target target2 = request.getTarget();
            targetDelegate = target2 == null ? (TargetDelegate)EmptyTargetDelegate.INSTANCE : (target2 instanceof PoolableViewTarget ? (TargetDelegate)new PoolableTargetDelegate(request, (PoolableViewTarget)target2, this.referenceCounter, eventListener, this.logger) : (TargetDelegate)new InvalidatableTargetDelegate(request, target2, this.referenceCounter, eventListener, this.logger));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return targetDelegate;
    }

    @MainThread
    @NotNull
    public final RequestDelegate createRequestDelegate(@NotNull Request request, @NotNull TargetDelegate targetDelegate, @NotNull Lifecycle lifecycle, @NotNull CoroutineDispatcher mainDispatcher, @NotNull Deferred<?> deferred2) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)targetDelegate, (String)"targetDelegate");
        Intrinsics.checkParameterIsNotNull((Object)lifecycle, (String)"lifecycle");
        Intrinsics.checkParameterIsNotNull((Object)mainDispatcher, (String)"mainDispatcher");
        Intrinsics.checkParameterIsNotNull(deferred2, (String)"deferred");
        RequestDelegate requestDelegate = null;
        Request request2 = request;
        if (request2 instanceof GetRequest) {
            requestDelegate = EmptyRequestDelegate.INSTANCE;
            lifecycle.addObserver((LifecycleObserver)requestDelegate);
        } else if (request2 instanceof LoadRequest) {
            Target target2 = request.getTarget();
            if (target2 instanceof ViewTarget) {
                requestDelegate = new ViewTargetRequestDelegate(this.imageLoader, (LoadRequest)request, targetDelegate, lifecycle, mainDispatcher, (Job)deferred2);
                lifecycle.addObserver((LifecycleObserver)requestDelegate);
                ExtensionsKt.getRequestManager(((ViewTarget)target2).getView()).setCurrentRequest((ViewTargetRequestDelegate)requestDelegate);
            } else {
                requestDelegate = new BaseRequestDelegate(lifecycle, mainDispatcher, (Job)deferred2);
                lifecycle.addObserver((LifecycleObserver)requestDelegate);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return requestDelegate;
    }

    public DelegateService(@NotNull ImageLoader imageLoader, @NotNull BitmapReferenceCounter referenceCounter, @Nullable Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)imageLoader, (String)"imageLoader");
        Intrinsics.checkParameterIsNotNull((Object)referenceCounter, (String)"referenceCounter");
        this.imageLoader = imageLoader;
        this.referenceCounter = referenceCounter;
        this.logger = logger;
    }
}

