/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.graphics.Bitmap;
import android.util.SparseIntArray;
import androidx.annotation.VisibleForTesting;
import coil.bitmappool.BitmapPool;
import coil.collection.SparseIntArraySet;
import coil.memory.WeakMemoryCache;
import coil.util.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u00020\u00108\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\f\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcoil/memory/BitmapReferenceCounter;", "", "weakMemoryCache", "Lcoil/memory/WeakMemoryCache;", "bitmapPool", "Lcoil/bitmappool/BitmapPool;", "logger", "Lcoil/util/Logger;", "(Lcoil/memory/WeakMemoryCache;Lcoil/bitmappool/BitmapPool;Lcoil/util/Logger;)V", "counts", "Landroid/util/SparseIntArray;", "counts$annotations", "()V", "getCounts$coil_base_release", "()Landroid/util/SparseIntArray;", "invalidKeys", "Lcoil/collection/SparseIntArraySet;", "invalidKeys$annotations", "getInvalidKeys$coil_base_release", "()Lcoil/collection/SparseIntArraySet;", "decrement", "", "bitmap", "Landroid/graphics/Bitmap;", "increment", "", "invalidate", "Companion", "coil-base_release"})
public final class BitmapReferenceCounter {
    @NotNull
    private final SparseIntArray counts;
    @NotNull
    private final SparseIntArraySet invalidKeys;
    private final WeakMemoryCache weakMemoryCache;
    private final BitmapPool bitmapPool;
    private final Logger logger;
    private static final String TAG = "BitmapReferenceCounter";
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting
    public static /* synthetic */ void counts$annotations() {
    }

    @NotNull
    public final SparseIntArray getCounts$coil_base_release() {
        return this.counts;
    }

    @VisibleForTesting
    public static /* synthetic */ void invalidKeys$annotations() {
    }

    @NotNull
    public final SparseIntArraySet getInvalidKeys$coil_base_release() {
        return this.invalidKeys;
    }

    /*
     * WARNING - void declaration
     */
    public final void increment(@NotNull Bitmap bitmap) {
        block1: {
            void $this$log$iv;
            Logger $this$set$iv;
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            Bitmap $this$identityHashCode$iv = bitmap;
            boolean $i$f$getIdentityHashCode = false;
            int key = System.identityHashCode($this$identityHashCode$iv);
            int count = this.counts.get(key);
            int newCount = count + 1;
            SparseIntArray sparseIntArray = this.counts;
            int value$iv22 = newCount;
            boolean $i$f$set = false;
            $this$set$iv.put(key, value$iv22);
            Logger logger = this.logger;
            if (logger == null) break block1;
            $this$set$iv = logger;
            String value$iv22 = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var11_12 = tag$iv;
                void var10_13 = $this$log$iv;
                boolean bl = false;
                String string = "INCREMENT: [" + key + ", " + newCount + ']';
                var10_13.log((String)var11_12, n, string, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean decrement(@NotNull Bitmap bitmap) {
        Logger $this$set$iv;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Bitmap $this$identityHashCode$iv = bitmap;
        boolean $i$f$getIdentityHashCode = false;
        int key = System.identityHashCode($this$identityHashCode$iv);
        int count = this.counts.get(key);
        int newCount = count - 1;
        SparseIntArray sparseIntArray = this.counts;
        int value$iv2 = newCount;
        boolean $i$f$set = false;
        $this$set$iv.put(key, value$iv2);
        Logger logger = this.logger;
        if (logger != null) {
            void $this$log$iv;
            $this$set$iv = logger;
            String value$iv2 = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var11_13 = tag$iv;
                void var10_14 = $this$log$iv;
                boolean bl = false;
                String string = "DECREMENT: [" + key + ", " + newCount + ']';
                var10_14.log((String)var11_13, n, string, null);
            }
        }
        if (newCount <= 0) {
            boolean isValid;
            this.counts.delete(key);
            boolean bl = isValid = !this.invalidKeys.remove(key);
            if (isValid) {
                this.weakMemoryCache.invalidate(bitmap);
                this.bitmapPool.put(bitmap);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void invalidate(@NotNull Bitmap bitmap) {
        void $this$plusAssign$iv;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        SparseIntArraySet sparseIntArraySet = this.invalidKeys;
        Bitmap $this$identityHashCode$iv = bitmap;
        boolean $i$f$getIdentityHashCode = false;
        int element$iv = System.identityHashCode($this$identityHashCode$iv);
        boolean $i$f$plusAssign = false;
        $this$plusAssign$iv.add(element$iv);
    }

    public BitmapReferenceCounter(@NotNull WeakMemoryCache weakMemoryCache, @NotNull BitmapPool bitmapPool, @Nullable Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)weakMemoryCache, (String)"weakMemoryCache");
        Intrinsics.checkParameterIsNotNull((Object)bitmapPool, (String)"bitmapPool");
        this.weakMemoryCache = weakMemoryCache;
        this.bitmapPool = bitmapPool;
        this.logger = logger;
        this.counts = new SparseIntArray();
        this.invalidKeys = new SparseIntArraySet(0, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/memory/BitmapReferenceCounter$Companion;", "", "()V", "TAG", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

