/*
 * Decompiled with CFR 0.152.
 */
package coil;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import coil.ComponentRegistry;
import coil.DefaultRequestOptions;
import coil.EventListener;
import coil.ImageLoader;
import coil.RealImageLoader;
import coil.annotation.BuilderMarker;
import coil.annotation.ExperimentalCoilApi;
import coil.bitmappool.BitmapPool;
import coil.memory.BitmapReferenceCounter;
import coil.memory.EmptyWeakMemoryCache;
import coil.memory.MemoryCache;
import coil.memory.RealWeakMemoryCache;
import coil.memory.WeakMemoryCache;
import coil.request.CachePolicy;
import coil.size.Precision;
import coil.transition.CrossfadeTransition;
import coil.transition.Transition;
import coil.util.CoilUtils;
import coil.util.ContextsKt;
import coil.util.ExtensionsKt;
import coil.util.Logger;
import coil.util.Utils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0015J\u0010\u0010\u0007\u001a\u00020\u00002\b\b\u0001\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\t\u001a\u00020\u00002\b\b\u0001\u0010\u0019\u001a\u00020\bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u000bH\u0002J\u0014\u0010\n\u001a\u00020\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010!\u001a\u00020\u00002\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#\u00a2\u0006\u0002\b&H\u0086\bJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0015J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\u00002\b\u00100\u001a\u0004\u0018\u000101J\u0010\u0010/\u001a\u00020\u00002\b\b\u0001\u00102\u001a\u00020)J\u0010\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u000205H\u0007J\u0010\u00103\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u000fH\u0007J\u0010\u00107\u001a\u00020\u00002\b\u00100\u001a\u0004\u0018\u000101J\u0010\u00107\u001a\u00020\u00002\b\b\u0001\u00102\u001a\u00020)J\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u000e\u00108\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J\u000e\u00109\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J\u0014\u0010:\u001a\u00020\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020;0 J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010:\u001a\u00020;J\u0010\u0010<\u001a\u00020\u00002\b\u00100\u001a\u0004\u0018\u000101J\u0010\u0010<\u001a\u00020\u00002\b\b\u0001\u00102\u001a\u00020)J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010=\u001a\u00020>J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0015J\u0010\u0010?\u001a\u00020\u00002\u0006\u0010?\u001a\u00020@H\u0007R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcoil/ImageLoaderBuilder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "applicationContext", "kotlin.jvm.PlatformType", "availableMemoryPercentage", "", "bitmapPoolPercentage", "callFactory", "Lokhttp3/Call$Factory;", "defaults", "Lcoil/DefaultRequestOptions;", "eventListenerFactory", "Lcoil/EventListener$Factory;", "logger", "Lcoil/util/Logger;", "registry", "Lcoil/ComponentRegistry;", "trackWeakReferences", "", "allowHardware", "enable", "allowRgb565", "multiplier", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "build", "Lcoil/ImageLoader;", "buildDefaultCallFactory", "initializer", "Lkotlin/Function0;", "componentRegistry", "builder", "Lkotlin/Function1;", "Lcoil/ComponentRegistry$Builder;", "", "Lkotlin/ExtensionFunctionType;", "crossfade", "durationMillis", "", "diskCachePolicy", "policy", "Lcoil/request/CachePolicy;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "error", "drawable", "Landroid/graphics/drawable/Drawable;", "drawableResId", "eventListener", "listener", "Lcoil/EventListener;", "factory", "fallback", "memoryCachePolicy", "networkCachePolicy", "okHttpClient", "Lokhttp3/OkHttpClient;", "placeholder", "precision", "Lcoil/size/Precision;", "transition", "Lcoil/transition/Transition;", "coil-base_release"})
@BuilderMarker
public final class ImageLoaderBuilder {
    private final Context applicationContext;
    private Call.Factory callFactory;
    private EventListener.Factory eventListenerFactory;
    private ComponentRegistry registry;
    private Logger logger;
    private DefaultRequestOptions defaults;
    private double availableMemoryPercentage;
    private double bitmapPoolPercentage;
    private boolean trackWeakReferences;

    @NotNull
    public final ImageLoaderBuilder okHttpClient(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
        return this.callFactory((Call.Factory)okHttpClient);
    }

    @NotNull
    public final ImageLoaderBuilder okHttpClient(@NotNull Function0<? extends OkHttpClient> initializer) {
        Intrinsics.checkParameterIsNotNull(initializer, (String)"initializer");
        return this.callFactory(initializer);
    }

    @NotNull
    public final ImageLoaderBuilder callFactory(@NotNull Call.Factory callFactory) {
        Intrinsics.checkParameterIsNotNull((Object)callFactory, (String)"callFactory");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.callFactory = callFactory;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder callFactory(@NotNull Function0<? extends Call.Factory> initializer) {
        Intrinsics.checkParameterIsNotNull(initializer, (String)"initializer");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.callFactory = ExtensionsKt.lazyCallFactory(initializer);
        return imageLoaderBuilder;
    }

    @NotNull
    public final /* synthetic */ ImageLoaderBuilder componentRegistry(@NotNull Function1<? super ComponentRegistry.Builder, Unit> builder) {
        int $i$f$componentRegistry = 0;
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        ComponentRegistry.Builder builder2 = new ComponentRegistry.Builder();
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        builder.invoke((Object)builder2);
        ComponentRegistry.Builder builder3 = builder2;
        return imageLoaderBuilder.componentRegistry(builder3.build());
    }

    @NotNull
    public final ImageLoaderBuilder componentRegistry(@NotNull ComponentRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.registry = registry;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder availableMemoryPercentage(@FloatRange(from=0.0, to=1.0) double multiplier) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        double d = multiplier;
        boolean bl4 = d >= 0.0 && d <= 1.0;
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Multiplier must be within the range [0.0, 1.0].";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        $this$apply.availableMemoryPercentage = multiplier;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder bitmapPoolPercentage(@FloatRange(from=0.0, to=1.0) double multiplier) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        double d = multiplier;
        boolean bl4 = d >= 0.0 && d <= 1.0;
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Multiplier must be within the range [0.0, 1.0].";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        $this$apply.bitmapPoolPercentage = multiplier;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder dispatcher(@NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"dispatcher");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, dispatcher, null, null, null, false, false, null, null, null, null, null, null, 4094, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder allowHardware(boolean enable) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, enable, false, null, null, null, null, null, null, 4079, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder allowRgb565(boolean enable) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, enable, null, null, null, null, null, null, 4063, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder trackWeakReferences(boolean enable) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.trackWeakReferences = enable;
        return imageLoaderBuilder;
    }

    @ExperimentalCoilApi
    @NotNull
    public final ImageLoaderBuilder eventListener(@NotNull EventListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        return this.eventListener(EventListener.Factory.Companion.create(listener2));
    }

    @ExperimentalCoilApi
    @NotNull
    public final ImageLoaderBuilder eventListener(@NotNull EventListener.Factory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.eventListenerFactory = factory;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder crossfade(boolean enable) {
        return this.crossfade(enable ? 100 : 0);
    }

    @NotNull
    public final ImageLoaderBuilder crossfade(int durationMillis) {
        return this.transition(durationMillis > 0 ? (Transition)new CrossfadeTransition(durationMillis) : Transition.NONE);
    }

    @ExperimentalCoilApi
    @NotNull
    public final ImageLoaderBuilder transition(@NotNull Transition transition) {
        Intrinsics.checkParameterIsNotNull((Object)transition, (String)"transition");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, transition, null, null, false, false, null, null, null, null, null, null, 4093, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder precision(@NotNull Precision precision) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)precision), (String)"precision");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, precision, null, false, false, null, null, null, null, null, null, 4091, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder bitmapConfig(@NotNull Bitmap.Config bitmapConfig) {
        Intrinsics.checkParameterIsNotNull((Object)bitmapConfig, (String)"bitmapConfig");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, bitmapConfig, false, false, null, null, null, null, null, null, 4087, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder placeholder(@DrawableRes int drawableResId) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        DefaultRequestOptions defaultRequestOptions = $this$apply.defaults;
        Context context = $this$apply.applicationContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        $this$apply.defaults = DefaultRequestOptions.copy$default(defaultRequestOptions, null, null, null, null, false, false, ContextsKt.getDrawableCompat(context, drawableResId), null, null, null, null, null, 4031, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder placeholder(@Nullable Drawable drawable) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, false, drawable, null, null, null, null, null, 4031, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder error(@DrawableRes int drawableResId) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        DefaultRequestOptions defaultRequestOptions = $this$apply.defaults;
        Context context = $this$apply.applicationContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        $this$apply.defaults = DefaultRequestOptions.copy$default(defaultRequestOptions, null, null, null, null, false, false, null, ContextsKt.getDrawableCompat(context, drawableResId), null, null, null, null, 3967, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder error(@Nullable Drawable drawable) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, false, null, drawable, null, null, null, null, 3967, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder fallback(@DrawableRes int drawableResId) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        DefaultRequestOptions defaultRequestOptions = $this$apply.defaults;
        Context context = $this$apply.applicationContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        $this$apply.defaults = DefaultRequestOptions.copy$default(defaultRequestOptions, null, null, null, null, false, false, null, ContextsKt.getDrawableCompat(context, drawableResId), null, null, null, null, 3967, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder fallback(@Nullable Drawable drawable) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, false, null, drawable, null, null, null, null, 3967, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder memoryCachePolicy(@NotNull CachePolicy policy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)policy), (String)"policy");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, false, null, null, null, policy, null, null, 3583, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder diskCachePolicy(@NotNull CachePolicy policy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)policy), (String)"policy");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, false, null, null, null, null, policy, null, 3071, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder networkCachePolicy(@NotNull CachePolicy policy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)policy), (String)"policy");
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.defaults = DefaultRequestOptions.copy$default($this$apply.defaults, null, null, null, null, false, false, null, null, null, null, null, policy, 2047, null);
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoaderBuilder logger(@Nullable Logger logger) {
        ImageLoaderBuilder imageLoaderBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ImageLoaderBuilder $this$apply = imageLoaderBuilder;
        boolean bl3 = false;
        $this$apply.logger = logger;
        return imageLoaderBuilder;
    }

    @NotNull
    public final ImageLoader build() {
        ComponentRegistry componentRegistry;
        EventListener.Factory factory;
        Context context = this.applicationContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        long availableMemorySize = Utils.INSTANCE.calculateAvailableMemorySize(context, this.availableMemoryPercentage);
        long bitmapPoolSize = (long)(this.bitmapPoolPercentage * (double)availableMemorySize);
        int memoryCacheSize = (int)(availableMemorySize - bitmapPoolSize);
        BitmapPool bitmapPool = BitmapPool.Companion.create(bitmapPoolSize, this.logger);
        WeakMemoryCache weakMemoryCache = this.trackWeakReferences ? (WeakMemoryCache)new RealWeakMemoryCache() : (WeakMemoryCache)EmptyWeakMemoryCache.INSTANCE;
        BitmapReferenceCounter referenceCounter = new BitmapReferenceCounter(weakMemoryCache, bitmapPool, this.logger);
        MemoryCache memoryCache = MemoryCache.Companion.invoke(weakMemoryCache, referenceCounter, memoryCacheSize, this.logger);
        Context context2 = this.applicationContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"applicationContext");
        Call.Factory factory2 = this.callFactory;
        if (factory2 == null) {
            factory2 = this.buildDefaultCallFactory();
        }
        if ((factory = this.eventListenerFactory) == null) {
            factory = EventListener.Factory.NONE;
        }
        if ((componentRegistry = this.registry) == null) {
            componentRegistry = new ComponentRegistry();
        }
        return new RealImageLoader(context2, this.defaults, bitmapPool, referenceCounter, memoryCache, weakMemoryCache, factory2, factory, componentRegistry, this.logger);
    }

    private final Call.Factory buildDefaultCallFactory() {
        return ExtensionsKt.lazyCallFactory((Function0<? extends Call.Factory>)((Function0)new Function0<OkHttpClient>(this){
            final /* synthetic */ ImageLoaderBuilder this$0;

            public final OkHttpClient invoke() {
                OkHttpClient.Builder builder = new OkHttpClient.Builder();
                Context context = ImageLoaderBuilder.access$getApplicationContext$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
                OkHttpClient okHttpClient = builder.cache(CoilUtils.createDefaultCache(context)).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"OkHttpClient.Builder()\n \u2026xt))\n            .build()");
                return okHttpClient;
            }
            {
                this.this$0 = imageLoaderBuilder;
                super(0);
            }
        }));
    }

    public ImageLoaderBuilder(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.applicationContext = context.getApplicationContext();
        this.defaults = new DefaultRequestOptions(null, null, null, null, false, false, null, null, null, null, null, null, 4095, null);
        Context context2 = this.applicationContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"applicationContext");
        this.availableMemoryPercentage = Utils.INSTANCE.getDefaultAvailableMemoryPercentage(context2);
        this.bitmapPoolPercentage = Utils.INSTANCE.getDefaultBitmapPoolPercentage();
        this.trackWeakReferences = true;
    }

    public static final /* synthetic */ Context access$getApplicationContext$p(ImageLoaderBuilder $this) {
        return $this.applicationContext;
    }
}

