/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.systemtests;

import ch.lambdaj.Lambda;
import ch.lambdaj.group.Group;
import ch.lambdaj.group.GroupCondition;
import io.cloudslang.lang.runtime.events.LanguageEventData;
import io.cloudslang.lang.systemtests.AbstractAggregatorListener;
import io.cloudslang.lang.systemtests.StepData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class RunDataAggregatorListener
extends AbstractAggregatorListener {
    public Map<String, StepData> aggregate() {
        HashMap<String, StepData> stepsData = new HashMap<String, StepData>();
        Group groups = Lambda.group(this.getEvents(), (GroupCondition[])new GroupCondition[]{Lambda.by((Object)((LanguageEventData)Lambda.on(LanguageEventData.class)).getPath())});
        for (Group subGroup : groups.subgroups()) {
            StepData stepData = this.buildStepData(subGroup.findAll());
            stepsData.put(stepData.getPath(), stepData);
        }
        return stepsData;
    }

    private StepData buildStepData(List<LanguageEventData> data) {
        LanguageEventData outputsEvent;
        LanguageEventData inputsEvent;
        List<LanguageEventData> stepEvents = this.selectByStepType(data, LanguageEventData.StepType.STEP);
        List<LanguageEventData> executableEvents = this.selectByStepType(data, LanguageEventData.StepType.getExecutableTypes());
        boolean isStep = CollectionUtils.isNotEmpty(stepEvents);
        if (isStep) {
            inputsEvent = this.selectByEventType(stepEvents, "EVENT_ARGUMENT_END");
            outputsEvent = this.selectByEventType(stepEvents, "EVENT_OUTPUT_END");
        } else {
            inputsEvent = this.selectByEventType(executableEvents, "EVENT_INPUT_END");
            outputsEvent = this.selectByEventType(executableEvents, "EVENT_OUTPUT_END");
        }
        String path = inputsEvent.getPath();
        String stepName = inputsEvent.getStepName();
        Map inputs = isStep ? inputsEvent.getArguments() : inputsEvent.getInputs();
        Map outputs = outputsEvent == null ? null : outputsEvent.getOutputs();
        String result = outputsEvent == null ? null : (String)outputsEvent.get((Object)"RESULT");
        String executableName = executableEvents.get(0).getStepName();
        return new StepData(path, stepName, inputs, outputs, executableName, result);
    }

    private List<LanguageEventData> selectByStepType(List<LanguageEventData> data, LanguageEventData.StepType ... stepTypes) {
        ArrayList<LanguageEventData> result = new ArrayList<LanguageEventData>();
        for (LanguageEventData element : data) {
            boolean match = false;
            for (LanguageEventData.StepType typeToCheck : stepTypes) {
                if (!element.getStepType().equals((Object)typeToCheck)) continue;
                match = true;
            }
            if (!match) continue;
            result.add(element);
        }
        return result;
    }

    private LanguageEventData selectByEventType(List<LanguageEventData> data, String eventType) {
        return (LanguageEventData)Lambda.selectFirst(data, (Matcher)Lambda.having((Object)((LanguageEventData)Lambda.on(LanguageEventData.class)).getEventType(), (Matcher)Matchers.equalTo((Object)eventType)));
    }
}

