/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.systemtests;

import ch.lambdaj.Lambda;
import ch.lambdaj.group.Group;
import ch.lambdaj.group.GroupCondition;
import com.google.common.collect.Lists;
import io.cloudslang.lang.runtime.env.ReturnValues;
import io.cloudslang.lang.runtime.events.LanguageEventData;
import io.cloudslang.lang.systemtests.AbstractAggregatorListener;
import io.cloudslang.lang.systemtests.StepData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BranchAggregatorListener
extends AbstractAggregatorListener {
    public Map<String, List<StepData>> aggregate() {
        HashMap<String, List<StepData>> branchesDataByPath = new HashMap<String, List<StepData>>();
        Group groups = Lambda.group(this.getEvents(), (GroupCondition[])new GroupCondition[]{Lambda.by((Object)((LanguageEventData)Lambda.on(LanguageEventData.class)).getPath())});
        for (Group subGroup : groups.subgroups()) {
            List<StepData> branchesData = this.buildBranchesData(subGroup.findAll());
            branchesDataByPath.put(branchesData.get(0).getPath(), branchesData);
        }
        return branchesDataByPath;
    }

    private List<StepData> buildBranchesData(List<LanguageEventData> data) {
        ArrayList branches = Lists.newArrayList();
        for (LanguageEventData branchData : data) {
            String path = branchData.getPath();
            String stepName = branchData.getStepName();
            ReturnValues returnValues = (ReturnValues)branchData.get((Object)"branchReturnValues");
            branches.add(new StepData(path, stepName, new HashMap<String, Serializable>(), LanguageEventData.maskSensitiveValues((Map)returnValues.getOutputs()), null, returnValues.getResult()));
        }
        return branches;
    }
}

