/*
 * Decompiled with CFR 0.152.
 */
package io.cloudflight.cleancode.archunit.utils;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import io.cloudflight.cleancode.archunit.utils.ClassUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lio/cloudflight/cleancode/archunit/utils/AreKotlinClasses;", "Lcom/tngtech/archunit/base/DescribedPredicate;", "Lcom/tngtech/archunit/core/domain/JavaClass;", "()V", "test", "", "input", "Companion", "archunit-cleancode-verifier"})
public final class AreKotlinClasses
extends DescribedPredicate<JavaClass> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOG = LoggerFactory.getLogger(AreKotlinClasses.class);

    public AreKotlinClasses() {
        super("are kotlin classes", new Object[0]);
    }

    public boolean test(@NotNull JavaClass input) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            Class clazz = input.reflect();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"reflect(...)");
            bl = ClassUtilsKt.isKotlinClass(clazz);
        }
        catch (NoClassDefFoundError err) {
            LOG.error("Cannot detect if " + input + " is a KotlinClass due to " + err + ". Assuming it's not a Kotlin class");
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/cloudflight/cleancode/archunit/utils/AreKotlinClasses$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "archunit-cleancode-verifier"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

