/*
 * Decompiled with CFR 0.152.
 */
package io.cloudflight.cleancode.archunit.rules.springboot;

import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.MembersShouldConjunction;
import io.cloudflight.cleancode.archunit.ArchRuleWithId;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lio/cloudflight/cleancode/archunit/rules/springboot/SpringBootRuleSet;", "", "()V", "do_not_use_spring_value_annotation", "Lcom/tngtech/archunit/lang/ArchRule;", "getDo_not_use_spring_value_annotation", "()Lcom/tngtech/archunit/lang/ArchRule;", "NotUseSpringValueAnnotation", "archunit-cleancode-verifier"})
public final class SpringBootRuleSet {
    @ArchTest
    @NotNull
    private final ArchRule do_not_use_spring_value_annotation;

    public SpringBootRuleSet() {
        MembersShouldConjunction membersShouldConjunction = ArchRuleDefinition.members().should((ArchCondition)new NotUseSpringValueAnnotation());
        Intrinsics.checkNotNullExpressionValue((Object)membersShouldConjunction, (String)"should(...)");
        this.do_not_use_spring_value_annotation = ArchRuleWithId.Companion.archRuleWithId("springboot.context-no-value-annotation", (ArchRule)membersShouldConjunction);
    }

    @NotNull
    public final ArchRule getDo_not_use_spring_value_annotation() {
        return this.do_not_use_spring_value_annotation;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J%\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u000eJ9\u0010\u000f\u001a*\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\r0\r\u0018\u0001 \u0010*\u0014\u0012\u000e\b\u0001\u0012\n \u0010*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f*\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lio/cloudflight/cleancode/archunit/rules/springboot/SpringBootRuleSet$NotUseSpringValueAnnotation;", "Lcom/tngtech/archunit/lang/ArchCondition;", "Lcom/tngtech/archunit/core/domain/JavaMember;", "()V", "check", "", "item", "events", "Lcom/tngtech/archunit/lang/ConditionEvents;", "checkExistenceOfValueAnnotation", "", "Lcom/tngtech/archunit/lang/ConditionEvent;", "", "Ljava/lang/reflect/Parameter;", "([Ljava/lang/reflect/Parameter;Lcom/tngtech/archunit/core/domain/JavaMember;)Ljava/util/List;", "parameters", "kotlin.jvm.PlatformType", "(Lcom/tngtech/archunit/core/domain/JavaMember;)[Ljava/lang/reflect/Parameter;", "Companion", "archunit-cleancode-verifier"})
    @SourceDebugExtension(value={"SMAP\nSpringBootRuleSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootRuleSet.kt\nio/cloudflight/cleancode/archunit/rules/springboot/SpringBootRuleSet$NotUseSpringValueAnnotation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,66:1\n1855#2,2:67\n1549#2:72\n1620#2,3:73\n3792#3:69\n4307#3,2:70\n*S KotlinDebug\n*F\n+ 1 SpringBootRuleSet.kt\nio/cloudflight/cleancode/archunit/rules/springboot/SpringBootRuleSet$NotUseSpringValueAnnotation\n*L\n44#1:67,2\n63#1:72\n63#1:73,3\n62#1:69\n62#1:70,2\n*E\n"})
    private static final class NotUseSpringValueAnnotation
    extends ArchCondition<JavaMember> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final Class<Value> ANNOTATION_CLASS = Value.class;

        public NotUseSpringValueAnnotation() {
            super("use Spring Boot's @ConfigurationProperties instead of @org.springframework.beans.factory.annotation.Value", new Object[0]);
        }

        /*
         * WARNING - void declaration
         */
        public void check(@NotNull JavaMember item, @NotNull ConditionEvents events) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            try {
                if (item instanceof JavaConstructor || item instanceof JavaMethod) {
                    List<ConditionEvent> list;
                    Parameter[] parameterArray = this.parameters(item);
                    if (parameterArray != null && (list = this.checkExistenceOfValueAnnotation(parameterArray, item)) != null) {
                        void $this$forEach$iv;
                        Iterable iterable = list;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ConditionEvent it = (ConditionEvent)element$iv;
                            boolean bl = false;
                            events.add(it);
                        }
                    }
                } else if (item instanceof JavaField && item.isAnnotatedWith(ANNOTATION_CLASS)) {
                    events.add(SimpleConditionEvent.violated((Object)item, (String)(item + " uses @Value")));
                }
            }
            catch (NoClassDefFoundError ex) {
                LoggerFactory.getLogger(NotUseSpringValueAnnotation.class).error("Cannot check " + item + " due to " + ex);
            }
        }

        private final Parameter[] parameters(JavaMember $this$parameters) {
            Object object = $this$parameters instanceof JavaMethod ? (JavaMethod)$this$parameters : null;
            if (object == null || (object = object.reflect()) == null || (object = ((Executable)object).getParameters()) == null) {
                Object object2 = $this$parameters instanceof JavaConstructor ? (JavaConstructor)$this$parameters : null;
                object = object2 != null && (object2 = object2.reflect()) != null ? ((Executable)object2).getParameters() : null;
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final List<ConditionEvent> checkExistenceOfValueAnnotation(Parameter[] $this$checkExistenceOfValueAnnotation, JavaMember item) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Parameter[] $this$filter$iv = $this$checkExistenceOfValueAnnotation;
            boolean $i$f$filter = false;
            Parameter[] parameterArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Parameter element$iv$iv : $this$filterTo$iv$iv) {
                void it = element$iv$iv;
                boolean bl = false;
                if (!it.isAnnotationPresent(ANNOTATION_CLASS)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Parameter element$iv$iv;
                element$iv$iv = (Parameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SimpleConditionEvent.violated((Object)item, (String)(item + " uses @Value")));
            }
            return (List)destination$iv$iv;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/cloudflight/cleancode/archunit/rules/springboot/SpringBootRuleSet$NotUseSpringValueAnnotation$Companion;", "", "()V", "ANNOTATION_CLASS", "Ljava/lang/Class;", "Lorg/springframework/beans/factory/annotation/Value;", "archunit-cleancode-verifier"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

