/*
 * Decompiled with CFR 0.152.
 */
package io.cloudflight.cleancode.archunit.rules.spring;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.ThrowsClause;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.ClassesShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.MethodsShouldConjunction;
import io.cloudflight.cleancode.archunit.ArchRuleWithId;
import io.cloudflight.cleancode.archunit.rules.spring.SpringClassUtilsKt;
import io.cloudflight.cleancode.archunit.rules.spring.TransactionalHelper;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.cache.annotation.Cacheable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0005\t\n\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRules;", "", "()V", "transactional_methods_should_not_throw_exceptions", "Lcom/tngtech/archunit/lang/ArchRule;", "getTransactional_methods_should_not_throw_exceptions", "()Lcom/tngtech/archunit/lang/ArchRule;", "transactional_should_never_go_on_class_level", "getTransactional_should_never_go_on_class_level", "AreTransactional", "CacheableHelper", "NotBeCacheable", "NotBeTransactionalClass", "NotThrowExceptions", "archunit-cleancode-verifier"})
public final class SpringTransactionalRules {
    @ArchTest
    @NotNull
    private final ArchRule transactional_methods_should_not_throw_exceptions;
    @ArchTest
    @NotNull
    private final ArchRule transactional_should_never_go_on_class_level;

    public SpringTransactionalRules() {
        MethodsShouldConjunction methodsShouldConjunction = ArchRuleDefinition.methods().that((DescribedPredicate)new AreTransactional()).should((ArchCondition)new NotThrowExceptions());
        Intrinsics.checkNotNullExpressionValue((Object)methodsShouldConjunction, (String)"should(...)");
        this.transactional_methods_should_not_throw_exceptions = ArchRuleWithId.Companion.archRuleWithId("spring.tx-do-not-throw-exceptions", (ArchRule)methodsShouldConjunction);
        ClassesShouldConjunction classesShouldConjunction = ArchRuleDefinition.classes().should((ArchCondition)new NotBeTransactionalClass());
        Intrinsics.checkNotNullExpressionValue((Object)classesShouldConjunction, (String)"should(...)");
        this.transactional_should_never_go_on_class_level = ArchRuleWithId.Companion.archRuleWithId("spring.tx-no-transactional-on-classlevel", (ArchRule)classesShouldConjunction);
    }

    @NotNull
    public final ArchRule getTransactional_methods_should_not_throw_exceptions() {
        return this.transactional_methods_should_not_throw_exceptions;
    }

    @NotNull
    public final ArchRule getTransactional_should_never_go_on_class_level() {
        return this.transactional_should_never_go_on_class_level;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRules$AreTransactional;", "Lcom/tngtech/archunit/base/DescribedPredicate;", "Lcom/tngtech/archunit/core/domain/JavaMethod;", "()V", "test", "", "input", "archunit-cleancode-verifier"})
    public static final class AreTransactional
    extends DescribedPredicate<JavaMethod> {
        public AreTransactional() {
            super("are @Transactional", new Object[0]);
        }

        public boolean test(@NotNull JavaMethod input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return !input.getModifiers().contains(JavaModifier.STATIC) && !input.getModifiers().contains(JavaModifier.PRIVATE) && TransactionalHelper.isTransactional$default(TransactionalHelper.INSTANCE, (JavaCodeUnit)input, false, false, 6, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\bJ\u001b\u0010\r\u001a\u0004\u0018\u00010\b*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u000e*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\f\u0010\u0012\u001a\u00020\b*\u00020\nH\u0002J\f\u0010\u0013\u001a\u00020\b*\u00020\nH\u0002\u00a8\u0006\u0015"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRules$CacheableHelper;", "", "()V", "ifArchUnitVerifierPluginContainsOwnerGetAllSubClassesOfOwner", "", "Lcom/tngtech/archunit/core/domain/JavaClass;", "owner", "isCacheable", "", "codeUnit", "Lcom/tngtech/archunit/core/domain/JavaCodeUnit;", "checkOwner", "checkSubClasses", "checkOtherImplementationsIfCacheable", "Lcom/tngtech/archunit/core/domain/JavaMethod;", "(Lcom/tngtech/archunit/core/domain/JavaMethod;Z)Ljava/lang/Boolean;", "getOverriddenMethodFromSubclass", "subClass", "isAnnotatedOrMetaAnnotatedWithCacheable", "isOwnerAnnotatedOrMetaAnnotatedWithCacheable", "CacheableAnnotation", "archunit-cleancode-verifier"})
    @SourceDebugExtension(value={"SMAP\nSpringTransactionalRules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringTransactionalRules.kt\nio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRules$CacheableHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1#2:146\n1747#3,3:147\n*S KotlinDebug\n*F\n+ 1 SpringTransactionalRules.kt\nio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRules$CacheableHelper\n*L\n125#1:147,3\n*E\n"})
    public static final class CacheableHelper {
        @NotNull
        public static final CacheableHelper INSTANCE = new CacheableHelper();

        private CacheableHelper() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isCacheable(@NotNull JavaCodeUnit codeUnit, boolean checkOwner, boolean checkSubClasses) {
            JavaCodeUnit javaCodeUnit;
            Intrinsics.checkNotNullParameter((Object)codeUnit, (String)"codeUnit");
            if (this.isAnnotatedOrMetaAnnotatedWithCacheable(codeUnit)) {
                return true;
            }
            if (checkOwner && this.isOwnerAnnotatedOrMetaAnnotatedWithCacheable(codeUnit)) {
                return true;
            }
            JavaCodeUnit it = javaCodeUnit = codeUnit;
            boolean bl = false;
            if (!checkSubClasses) return false;
            if (!(it instanceof JavaMethod)) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            JavaCodeUnit javaCodeUnit2 = javaCodeUnit;
            JavaCodeUnit javaCodeUnit3 = javaCodeUnit2;
            if (javaCodeUnit3 == null) return false;
            JavaCodeUnit it2 = javaCodeUnit3;
            boolean bl3 = false;
            javaCodeUnit = (JavaMethod)it2;
            Boolean bl4 = this.checkOtherImplementationsIfCacheable((JavaMethod)javaCodeUnit, checkOwner);
            if (bl4 == null) return false;
            boolean bl5 = bl4;
            return bl5;
        }

        public static /* synthetic */ boolean isCacheable$default(CacheableHelper cacheableHelper, JavaCodeUnit javaCodeUnit, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return cacheableHelper.isCacheable(javaCodeUnit, bl, bl2);
        }

        private final boolean isAnnotatedOrMetaAnnotatedWithCacheable(JavaCodeUnit $this$isAnnotatedOrMetaAnnotatedWithCacheable) {
            return $this$isAnnotatedOrMetaAnnotatedWithCacheable.isAnnotatedWith((DescribedPredicate)new CacheableAnnotation()) || $this$isAnnotatedOrMetaAnnotatedWithCacheable.isMetaAnnotatedWith((DescribedPredicate)new CacheableAnnotation());
        }

        private final boolean isOwnerAnnotatedOrMetaAnnotatedWithCacheable(JavaCodeUnit $this$isOwnerAnnotatedOrMetaAnnotatedWithCacheable) {
            return $this$isOwnerAnnotatedOrMetaAnnotatedWithCacheable.getOwner().isAnnotatedWith((DescribedPredicate)new CacheableAnnotation()) || $this$isOwnerAnnotatedOrMetaAnnotatedWithCacheable.getOwner().isMetaAnnotatedWith((DescribedPredicate)new CacheableAnnotation());
        }

        /*
         * WARNING - void declaration
         */
        private final Boolean checkOtherImplementationsIfCacheable(JavaMethod $this$checkOtherImplementationsIfCacheable, boolean checkOwner) {
            Boolean bl;
            JavaClass javaClass = $this$checkOtherImplementationsIfCacheable.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)javaClass, (String)"getOwner(...)");
            Set<JavaClass> set = this.ifArchUnitVerifierPluginContainsOwnerGetAllSubClassesOfOwner(javaClass);
            if (set != null) {
                boolean bl2;
                block7: {
                    void $this$any$iv;
                    Iterable iterable = set;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl3;
                            JavaClass subClass = (JavaClass)element$iv;
                            boolean bl4 = false;
                            JavaMethod javaMethod = INSTANCE.getOverriddenMethodFromSubclass((JavaCodeUnit)$this$checkOtherImplementationsIfCacheable, subClass);
                            if (javaMethod != null) {
                                JavaMethod it = javaMethod;
                                boolean bl5 = false;
                                bl3 = CacheableHelper.isCacheable$default(INSTANCE, (JavaCodeUnit)it, checkOwner, false, 4, null);
                            } else {
                                bl3 = false;
                            }
                            if (!bl3) continue;
                            bl2 = true;
                            break block7;
                        }
                        bl2 = false;
                    }
                }
                bl = bl2;
            } else {
                bl = null;
            }
            return bl;
        }

        private final JavaMethod getOverriddenMethodFromSubclass(JavaCodeUnit $this$getOverriddenMethodFromSubclass, JavaClass subClass) {
            Object v1;
            block1: {
                Set set = subClass.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getMethods(...)");
                Iterable iterable = set;
                for (Object t : iterable) {
                    JavaMethod it = (JavaMethod)t;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)$this$getOverriddenMethodFromSubclass.getName()) && Intrinsics.areEqual((Object)HasName.Utils.namesOf((Iterable)it.getRawParameterTypes()), (Object)HasName.Utils.namesOf((Iterable)$this$getOverriddenMethodFromSubclass.getRawParameterTypes())))) continue;
                    v1 = t;
                    break block1;
                }
                v1 = null;
            }
            return v1;
        }

        private final Set<JavaClass> ifArchUnitVerifierPluginContainsOwnerGetAllSubClassesOfOwner(JavaClass owner) {
            return owner.getAllSubclasses();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRules$CacheableHelper$CacheableAnnotation;", "Lcom/tngtech/archunit/base/DescribedPredicate;", "Lcom/tngtech/archunit/core/domain/JavaAnnotation;", "()V", "test", "", "input", "archunit-cleancode-verifier"})
        public static final class CacheableAnnotation
        extends DescribedPredicate<JavaAnnotation<?>> {
            public CacheableAnnotation() {
                super("", new Object[0]);
            }

            public boolean test(@NotNull JavaAnnotation<?> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                return SpringClassUtilsKt.toAnnotation(input, Cacheable.class) != null;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRules$NotBeCacheable;", "Lcom/tngtech/archunit/lang/ArchCondition;", "Lcom/tngtech/archunit/core/domain/JavaMethod;", "()V", "check", "", "item", "events", "Lcom/tngtech/archunit/lang/ConditionEvents;", "archunit-cleancode-verifier"})
    private static final class NotBeCacheable
    extends ArchCondition<JavaMethod> {
        public NotBeCacheable() {
            super("not be annotated with @Cacheable", new Object[0]);
        }

        public void check(@NotNull JavaMethod item, @NotNull ConditionEvents events) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            if (CacheableHelper.isCacheable$default(CacheableHelper.INSTANCE, (JavaCodeUnit)item, false, false, 6, null)) {
                events.add(SimpleConditionEvent.violated((Object)item, (String)(item + " annotated with @Transactional must not be annotated with @Cacheable")));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRules$NotBeTransactionalClass;", "Lcom/tngtech/archunit/lang/ArchCondition;", "Lcom/tngtech/archunit/core/domain/JavaClass;", "()V", "check", "", "item", "events", "Lcom/tngtech/archunit/lang/ConditionEvents;", "archunit-cleancode-verifier"})
    public static final class NotBeTransactionalClass
    extends ArchCondition<JavaClass> {
        public NotBeTransactionalClass() {
            super("not be annotated with @Transactional", new Object[0]);
        }

        public void check(@NotNull JavaClass item, @NotNull ConditionEvents events) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            if (TransactionalHelper.INSTANCE.isTransactional(item)) {
                events.add(SimpleConditionEvent.violated((Object)item, (String)(item + " should not be annotated with @Transactional")));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRules$NotThrowExceptions;", "Lcom/tngtech/archunit/lang/ArchCondition;", "Lcom/tngtech/archunit/core/domain/JavaMethod;", "()V", "check", "", "item", "events", "Lcom/tngtech/archunit/lang/ConditionEvents;", "archunit-cleancode-verifier"})
    public static final class NotThrowExceptions
    extends ArchCondition<JavaMethod> {
        public NotThrowExceptions() {
            super("not throw exceptions", new Object[0]);
        }

        public void check(@NotNull JavaMethod item, @NotNull ConditionEvents events) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            ThrowsClause throwsClause = item.getThrowsClause();
            Intrinsics.checkNotNullExpressionValue((Object)throwsClause, (String)"getThrowsClause(...)");
            if (CollectionsKt.any((Iterable)((Iterable)throwsClause))) {
                events.add(SimpleConditionEvent.violated((Object)item, (String)(item + " is @Transactional but throws exceptions")));
            }
        }
    }
}

