/*
 * Decompiled with CFR 0.152.
 */
package io.cloudflight.cleancode.archunit.rules.spring;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.MethodsShouldConjunction;
import io.cloudflight.cleancode.archunit.ArchRuleWithId;
import io.cloudflight.cleancode.archunit.rules.spring.AreTransactional;
import io.cloudflight.cleancode.archunit.rules.spring.BeDefaultMethod;
import io.cloudflight.cleancode.archunit.rules.spring.BeMemberOfInnerOrAnonymousClass;
import io.cloudflight.cleancode.archunit.rules.spring.JavaMethodHelper;
import io.cloudflight.cleancode.archunit.rules.spring.TransactionalHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jpa.repository.JpaRepository;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0004\t\n\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\r"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRepositoryRules;", "", "()V", "methods_that_are_transactional_should_access_other_transactional_methods_or_repositories", "Lcom/tngtech/archunit/lang/ArchRule;", "getMethods_that_are_transactional_should_access_other_transactional_methods_or_repositories", "()Lcom/tngtech/archunit/lang/ArchRule;", "repository_methods_should_only_be_accessed_by_transactional_methods", "getRepository_methods_should_only_be_accessed_by_transactional_methods", "AccessJpaRepositoryMethods", "BeNonPublic", "BeTransactional", "CallOtherTransactionalOrRepositoryMethods", "archunit-cleancode-verifier"})
public final class SpringTransactionalRepositoryRules {
    @ArchTest
    @NotNull
    private final ArchRule repository_methods_should_only_be_accessed_by_transactional_methods;
    @ArchTest
    @NotNull
    private final ArchRule methods_that_are_transactional_should_access_other_transactional_methods_or_repositories;

    public SpringTransactionalRepositoryRules() {
        MethodsShouldConjunction methodsShouldConjunction = ArchRuleDefinition.methods().that((DescribedPredicate)new AccessJpaRepositoryMethods()).should((ArchCondition)new BeTransactional()).orShould((ArchCondition)new BeNonPublic()).orShould((ArchCondition)new BeMemberOfInnerOrAnonymousClass()).orShould((ArchCondition)new BeDefaultMethod());
        Intrinsics.checkNotNullExpressionValue((Object)methodsShouldConjunction, (String)"orShould(...)");
        this.repository_methods_should_only_be_accessed_by_transactional_methods = ArchRuleWithId.Companion.archRuleWithId("spring.tx-repository-only-from-transactional-methods", (ArchRule)methodsShouldConjunction);
        MethodsShouldConjunction methodsShouldConjunction2 = ArchRuleDefinition.methods().that((DescribedPredicate)new AreTransactional()).should((ArchCondition)new CallOtherTransactionalOrRepositoryMethods());
        Intrinsics.checkNotNullExpressionValue((Object)methodsShouldConjunction2, (String)"should(...)");
        this.methods_that_are_transactional_should_access_other_transactional_methods_or_repositories = ArchRuleWithId.Companion.archRuleWithId("spring.tx-transactional-methods-should-access-other-transactional-methods-or-repositories", (ArchRule)methodsShouldConjunction2);
    }

    @NotNull
    public final ArchRule getRepository_methods_should_only_be_accessed_by_transactional_methods() {
        return this.repository_methods_should_only_be_accessed_by_transactional_methods;
    }

    @NotNull
    public final ArchRule getMethods_that_are_transactional_should_access_other_transactional_methods_or_repositories() {
        return this.methods_that_are_transactional_should_access_other_transactional_methods_or_repositories;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRepositoryRules$AccessJpaRepositoryMethods;", "Lcom/tngtech/archunit/base/DescribedPredicate;", "Lcom/tngtech/archunit/core/domain/JavaMethod;", "()V", "test", "", "input", "archunit-cleancode-verifier"})
    @SourceDebugExtension(value={"SMAP\nSpringTransactionalRepositoryRules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringTransactionalRepositoryRules.kt\nio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRepositoryRules$AccessJpaRepositoryMethods\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1747#2,3:96\n*S KotlinDebug\n*F\n+ 1 SpringTransactionalRepositoryRules.kt\nio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRepositoryRules$AccessJpaRepositoryMethods\n*L\n52#1:96,3\n*E\n"})
    public static final class AccessJpaRepositoryMethods
    extends DescribedPredicate<JavaMethod> {
        public AccessJpaRepositoryMethods() {
            super("access repository methods", new Object[0]);
        }

        public boolean test(@NotNull JavaMethod input) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Set set = input.getAccessesFromSelf();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAccessesFromSelf(...)");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JavaAccess it = (JavaAccess)element$iv;
                        boolean bl2 = false;
                        if (!it.getTarget().getOwner().isAssignableTo(JpaRepository.class)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRepositoryRules$BeNonPublic;", "Lcom/tngtech/archunit/lang/ArchCondition;", "Lcom/tngtech/archunit/core/domain/JavaMethod;", "()V", "check", "", "item", "events", "Lcom/tngtech/archunit/lang/ConditionEvents;", "archunit-cleancode-verifier"})
    public static final class BeNonPublic
    extends ArchCondition<JavaMethod> {
        public BeNonPublic() {
            super("be non-public and only be accessed by transactional methods", new Object[0]);
        }

        public void check(@NotNull JavaMethod item, @NotNull ConditionEvents events) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            if (item.getModifiers().contains(JavaModifier.PUBLIC)) {
                events.add(SimpleConditionEvent.violated((Object)item, (String)(item + " should be @Transactional as it is a public method")));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRepositoryRules$BeTransactional;", "Lcom/tngtech/archunit/lang/ArchCondition;", "Lcom/tngtech/archunit/core/domain/JavaMethod;", "()V", "check", "", "item", "events", "Lcom/tngtech/archunit/lang/ConditionEvents;", "archunit-cleancode-verifier"})
    public static final class BeTransactional
    extends ArchCondition<JavaMethod> {
        public BeTransactional() {
            super("be annotated with @Transactional", new Object[0]);
        }

        public void check(@NotNull JavaMethod item, @NotNull ConditionEvents events) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            if (!TransactionalHelper.isTransactional$default(TransactionalHelper.INSTANCE, (JavaCodeUnit)item, false, false, 6, null)) {
                events.add(SimpleConditionEvent.violated((Object)item, (String)(item + " should be annotated with @Transactional as it accesses a repository method")));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u0002H\u0002\u00a8\u0006\u000b"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRepositoryRules$CallOtherTransactionalOrRepositoryMethods;", "Lcom/tngtech/archunit/lang/ArchCondition;", "Lcom/tngtech/archunit/core/domain/JavaMethod;", "()V", "check", "", "item", "events", "Lcom/tngtech/archunit/lang/ConditionEvents;", "createEvent", "Lcom/tngtech/archunit/lang/ConditionEvent;", "archunit-cleancode-verifier"})
    @SourceDebugExtension(value={"SMAP\nSpringTransactionalRepositoryRules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringTransactionalRepositoryRules.kt\nio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRepositoryRules$CallOtherTransactionalOrRepositoryMethods\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1360#2:96\n1446#2,5:97\n1#3:102\n*S KotlinDebug\n*F\n+ 1 SpringTransactionalRepositoryRules.kt\nio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalRepositoryRules$CallOtherTransactionalOrRepositoryMethods\n*L\n82#1:96\n82#1:97,5\n*E\n"})
    private static final class CallOtherTransactionalOrRepositoryMethods
    extends ArchCondition<JavaMethod> {
        public CallOtherTransactionalOrRepositoryMethods() {
            super("call other methods that are @Transactional or repository methods", new Object[0]);
        }

        /*
         * WARNING - void declaration
         */
        public void check(@NotNull JavaMethod item, @NotNull ConditionEvents events) {
            JavaAccess javaAccess;
            Object v1;
            block3: {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter((Object)events, (String)"events");
                Iterable $this$flatMap$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)item), (Iterable)JavaMethodHelper.collectTransitiveCalls$default(JavaMethodHelper.INSTANCE, item, false, 2, null));
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    JavaCodeUnit it = (JavaCodeUnit)element$iv$iv;
                    boolean bl = false;
                    Set set = it.getAccessesFromSelf();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAccessesFromSelf(...)");
                    Iterable list$iv$iv = set;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                Iterable iterable2 = (List)destination$iv$iv;
                for (Object e : iterable2) {
                    JavaAccess javaMethodCall = (JavaAccess)e;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)javaMethodCall);
                    if (!TransactionalHelper.INSTANCE.isTransactionalFunctionOrInRepositoryClass(javaMethodCall)) continue;
                    v1 = e;
                    break block3;
                }
                v1 = null;
            }
            if ((javaAccess = (JavaAccess)v1) == null) {
                events.add(this.createEvent(item));
                javaAccess = Unit.INSTANCE;
            }
        }

        private final ConditionEvent createEvent(JavaMethod $this$createEvent) {
            ConditionEvent conditionEvent = SimpleConditionEvent.violated((Object)$this$createEvent, (String)($this$createEvent + " calls no other @Transactional method and also no repository method"));
            Intrinsics.checkNotNullExpressionValue((Object)conditionEvent, (String)"violated(...)");
            return conditionEvent;
        }
    }
}

