/*
 * Decompiled with CFR 0.152.
 */
package io.cloudflight.cleancode.archunit.rules.spring;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.MethodsShouldConjunction;
import io.cloudflight.cleancode.archunit.ArchRuleWithId;
import io.cloudflight.cleancode.archunit.rules.spring.JavaMethodHelper;
import io.cloudflight.cleancode.archunit.rules.spring.NotBeTransactional;
import io.cloudflight.cleancode.archunit.rules.spring.TransactionalHelper;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalControllerRules;", "", "()V", "controller_methods_should_never_be_transactional", "Lcom/tngtech/archunit/lang/ArchRule;", "getController_methods_should_never_be_transactional", "()Lcom/tngtech/archunit/lang/ArchRule;", "controller_methods_should_not_access_more_than_one_transactional_method", "getController_methods_should_not_access_more_than_one_transactional_method", "ArePublicAndDeclaredInSpringControllers", "NotAccessMoreThanOneTransactionalMethod", "archunit-cleancode-verifier"})
public final class SpringTransactionalControllerRules {
    @ArchTest
    @NotNull
    private final ArchRule controller_methods_should_never_be_transactional;
    @ArchTest
    @NotNull
    private final ArchRule controller_methods_should_not_access_more_than_one_transactional_method;

    public SpringTransactionalControllerRules() {
        MethodsShouldConjunction methodsShouldConjunction = ArchRuleDefinition.methods().that((DescribedPredicate)new ArePublicAndDeclaredInSpringControllers()).should((ArchCondition)new NotBeTransactional());
        Intrinsics.checkNotNullExpressionValue((Object)methodsShouldConjunction, (String)"should(...)");
        this.controller_methods_should_never_be_transactional = ArchRuleWithId.Companion.archRuleWithId("spring.tx-controller-methods-should-not-be-transactional", (ArchRule)methodsShouldConjunction);
        MethodsShouldConjunction methodsShouldConjunction2 = ArchRuleDefinition.methods().that((DescribedPredicate)new ArePublicAndDeclaredInSpringControllers()).should((ArchCondition)new NotAccessMoreThanOneTransactionalMethod());
        Intrinsics.checkNotNullExpressionValue((Object)methodsShouldConjunction2, (String)"should(...)");
        this.controller_methods_should_not_access_more_than_one_transactional_method = ArchRuleWithId.Companion.archRuleWithId("spring.tx-controller-methods-should-not-access-more-than-one-transactional-method", (ArchRule)methodsShouldConjunction2);
    }

    @NotNull
    public final ArchRule getController_methods_should_never_be_transactional() {
        return this.controller_methods_should_never_be_transactional;
    }

    @NotNull
    public final ArchRule getController_methods_should_not_access_more_than_one_transactional_method() {
        return this.controller_methods_should_not_access_more_than_one_transactional_method;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalControllerRules$ArePublicAndDeclaredInSpringControllers;", "Lcom/tngtech/archunit/base/DescribedPredicate;", "Lcom/tngtech/archunit/core/domain/JavaMethod;", "()V", "test", "", "input", "archunit-cleancode-verifier"})
    private static final class ArePublicAndDeclaredInSpringControllers
    extends DescribedPredicate<JavaMethod> {
        public ArePublicAndDeclaredInSpringControllers() {
            super("are public and declared in spring controllers", new Object[0]);
        }

        public boolean test(@NotNull JavaMethod input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return input.getModifiers().contains(JavaModifier.PUBLIC) && (input.getOwner().isAnnotatedWith(RestController.class) || input.getOwner().isMetaAnnotatedWith(RestController.class) || input.getOwner().isAnnotatedWith(Controller.class) || input.getOwner().isMetaAnnotatedWith(Controller.class));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalControllerRules$NotAccessMoreThanOneTransactionalMethod;", "Lcom/tngtech/archunit/lang/ArchCondition;", "Lcom/tngtech/archunit/core/domain/JavaMethod;", "()V", "check", "", "item", "events", "Lcom/tngtech/archunit/lang/ConditionEvents;", "archunit-cleancode-verifier"})
    @SourceDebugExtension(value={"SMAP\nSpringTransactionalControllerRules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringTransactionalControllerRules.kt\nio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalControllerRules$NotAccessMoreThanOneTransactionalMethod\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1774#2,4:88\n*S KotlinDebug\n*F\n+ 1 SpringTransactionalControllerRules.kt\nio/cloudflight/cleancode/archunit/rules/spring/SpringTransactionalControllerRules$NotAccessMoreThanOneTransactionalMethod\n*L\n68#1:88,4\n*E\n"})
    private static final class NotAccessMoreThanOneTransactionalMethod
    extends ArchCondition<JavaMethod> {
        public NotAccessMoreThanOneTransactionalMethod() {
            super("not access more than one transactional method", new Object[0]);
        }

        /*
         * WARNING - void declaration
         */
        public void check(@NotNull JavaMethod item, @NotNull ConditionEvents events) {
            int transactionCount;
            void $this$count$iv;
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            Iterable iterable = JavaMethodHelper.INSTANCE.collectTransitiveCalls(item, true);
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v0 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    JavaCodeUnit it = (JavaCodeUnit)element$iv;
                    boolean bl = false;
                    if (!TransactionalHelper.INSTANCE.isTransactional(it, true, true) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v0 = transactionCount = count$iv;
            }
            if (transactionCount > 1) {
                events.add(SimpleConditionEvent.violated((Object)item, (String)(item + " calls " + transactionCount + " (more than one) other @Transactional methods")));
            }
        }
    }
}

