/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.xml;

import java.util.ArrayList;
import java.util.Collection;

final class XMLConstants {
    static final String CE_NAMESPACE = "http://cloudevents.io/xmlformat/V1";
    static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    static final String XS_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    static final String CE_ATTR_STRING = "ce:string";
    static final String CE_ATTR_BOOLEAN = "ce:boolean";
    static final String CE_ATTR_INTEGER = "ce:integer";
    static final String CE_ATTR_URI = "ce:uri";
    static final String CE_ATTR_URI_REF = "ce:uriRef";
    static final String CE_ATTR_BINARY = "ce:binary";
    static final String CE_ATTR_TIMESTAMP = "ce:timestamp";
    static final String CE_DATA_ATTR_BINARY = "xs:base64Binary";
    static final String CE_DATA_ATTR_TEXT = "xs:string";
    static final String CE_DATA_ATTR_XML = "xs:any";
    static final String XSI_TYPE = "xsi:type";
    static final String XML_DATA_ELEMENT = "data";
    static final String XML_ROOT_ELEMENT = "event";
    static final Collection<String> CE_ATTR_LIST = new ArrayList<String>(){
        {
            this.add(XMLConstants.CE_ATTR_STRING);
            this.add(XMLConstants.CE_ATTR_BOOLEAN);
            this.add(XMLConstants.CE_ATTR_INTEGER);
            this.add(XMLConstants.CE_ATTR_TIMESTAMP);
            this.add(XMLConstants.CE_ATTR_URI);
            this.add(XMLConstants.CE_ATTR_URI_REF);
            this.add(XMLConstants.CE_ATTR_BINARY);
        }
    };
    static final Collection<String> CE_DATA_ATTRS = new ArrayList<String>(){
        {
            this.add(XMLConstants.CE_DATA_ATTR_TEXT);
            this.add(XMLConstants.CE_DATA_ATTR_BINARY);
            this.add(XMLConstants.CE_DATA_ATTR_XML);
        }
    };

    private XMLConstants() {
    }

    static boolean isCloudEventAttributeType(String type) {
        return CE_ATTR_LIST.contains(type);
    }

    static boolean isValidDataType(String type) {
        return CE_DATA_ATTRS.contains(type);
    }
}

