/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.xml;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventReader;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;
import io.cloudevents.types.Time;
import io.cloudevents.xml.OccurrenceTracker;
import io.cloudevents.xml.XMLCloudEventData;
import io.cloudevents.xml.XMLUtils;
import java.net.URI;
import java.util.Base64;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XMLDeserializer
implements CloudEventReader {
    private final Document xmlDocument;
    private final OccurrenceTracker ceAttributeTracker = new OccurrenceTracker();

    XMLDeserializer(Document doc) {
        this.xmlDocument = doc;
    }

    public <W extends CloudEventWriter<R>, R> R read(CloudEventWriterFactory<W, R> writerFactory, CloudEventDataMapper<? extends CloudEventData> mapper) throws CloudEventRWException {
        Element root = this.xmlDocument.getDocumentElement();
        this.checkValidRootElement(root);
        String specVer = root.getAttribute("specversion");
        if (specVer == null) {
            throw CloudEventRWException.newInvalidSpecVersion((String)"null - Missing XML attribute");
        }
        SpecVersion specVersion = SpecVersion.parse((String)specVer);
        CloudEventWriter writer = writerFactory.create(specVersion);
        NodeList nodes = root.getChildNodes();
        Element dataElement = null;
        block18: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element e = (Element)node;
            this.ensureValidContextAttribute(e);
            String attrName = e.getLocalName();
            String attrType = this.extractAttributeType(e);
            String attrValue = e.getTextContent();
            if (specVersion.getAllAttributes().contains(attrName)) {
                writer.withContextAttribute(attrName, attrValue);
                continue;
            }
            if ("data".equals(attrName)) {
                dataElement = e;
                continue;
            }
            switch (attrType) {
                case "ce:string": {
                    writer.withContextAttribute(attrName, attrValue);
                    continue block18;
                }
                case "ce:integer": {
                    writer.withContextAttribute(attrName, Integer.valueOf(attrValue));
                    continue block18;
                }
                case "ce:timestamp": {
                    writer.withContextAttribute(attrName, Time.parseTime((String)attrValue));
                    continue block18;
                }
                case "ce:boolean": {
                    writer.withContextAttribute(attrName, Boolean.valueOf(attrValue));
                    continue block18;
                }
                case "ce:uri": {
                    writer.withContextAttribute(attrName, URI.create(attrValue));
                    continue block18;
                }
                case "ce:uriRef": {
                    writer.withContextAttribute(attrName, URI.create(attrValue));
                    continue block18;
                }
                case "ce:binary": {
                    writer.withContextAttribute(attrName, Base64.getDecoder().decode(attrValue));
                }
            }
        }
        if (dataElement != null) {
            return (R)writer.end(this.processData(dataElement));
        }
        return (R)writer.end();
    }

    private static Element findFirstElement(Element e) {
        NodeList nodeList = e.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    private CloudEventData processData(Element data) throws CloudEventRWException {
        String attrType;
        TextCloudEventData retVal = null;
        switch (attrType = this.extractAttributeType(data)) {
            case "xs:string": {
                retVal = new TextCloudEventData(data.getTextContent());
                break;
            }
            case "xs:base64Binary": {
                String eData = data.getTextContent();
                retVal = BytesCloudEventData.wrap((byte[])Base64.getDecoder().decode(eData));
                break;
            }
            case "xs:any": {
                try {
                    this.ensureValidDataElement(data);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    Document newDoc = dbf.newDocumentBuilder().newDocument();
                    Element eventData = XMLDeserializer.findFirstElement(data);
                    Element newRoot = newDoc.createElementNS(eventData.getNamespaceURI(), eventData.getLocalName());
                    newDoc.appendChild(newRoot);
                    NodeList nodesToCopy = eventData.getChildNodes();
                    for (int i = 0; i < nodesToCopy.getLength(); ++i) {
                        Node n = nodesToCopy.item(i);
                        if (n.getNodeType() != 1) continue;
                        Node newNode = newDoc.importNode(n, true);
                        newRoot.appendChild(newNode);
                    }
                    newDoc.normalizeDocument();
                    retVal = XMLCloudEventData.wrap(newDoc);
                    break;
                }
                catch (ParserConfigurationException e) {
                    throw CloudEventRWException.newDataConversion((Throwable)e, null, null);
                }
            }
        }
        return retVal;
    }

    private void checkValidRootElement(Element e) throws CloudEventRWException {
        if (!"event".equals(e.getLocalName())) {
            throw CloudEventRWException.newInvalidDataType((String)e.getLocalName(), (String[])new String[]{"event"});
        }
        if (!"http://cloudevents.io/xmlformat/V1".equalsIgnoreCase(e.getNamespaceURI())) {
            throw CloudEventRWException.newInvalidDataType((String)e.getNamespaceURI(), (String[])new String[]{"Namespace: http://cloudevents.io/xmlformat/V1"});
        }
    }

    private void ensureValidDataElement(Element dataEl) throws CloudEventRWException {
        int childCount = XMLUtils.countOfChildElements(dataEl);
        if (childCount != 1) {
            throw CloudEventRWException.newInvalidDataType((String)("data has " + childCount + " children"), (String[])new String[]{"1 expected"});
        }
        String xsiType = dataEl.getAttribute("xsi:type");
        if (xsiType == null) {
            throw CloudEventRWException.newInvalidDataType((String)"NULL", (String[])new String[]{"xsi:type oneOf [xs:base64Binary, xs:string, xs:any]"});
        }
    }

    private void ensureValidContextAttribute(Element el) throws CloudEventRWException {
        String localName = el.getLocalName();
        if (!"http://cloudevents.io/xmlformat/V1".equals(el.getNamespaceURI())) {
            String allowedTxt = el.getLocalName() + " Expected namespace: " + "http://cloudevents.io/xmlformat/V1";
            throw CloudEventRWException.newInvalidDataType((String)el.getNamespaceURI(), (String[])new String[]{allowedTxt});
        }
        if (!this.allLowerCase(localName)) {
            throw CloudEventRWException.newInvalidDataType((String)localName, (String[])new String[]{" context atttribute names MUST be lowercase"});
        }
        if (!"data".equals(localName) && XMLUtils.countOfChildElements(el) != 0) {
            throw CloudEventRWException.newInvalidDataType((String)el.getLocalName(), (String[])new String[]{"Unexpected child element(s)"});
        }
        if (!this.ceAttributeTracker.trackOccurrence(localName)) {
            throw CloudEventRWException.newOther((String)(localName + ": Attribute appeared more than once"));
        }
    }

    private String extractAttributeType(Element e) {
        Attr a = e.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (a != null) {
            return a.getValue();
        }
        return null;
    }

    private boolean allLowerCase(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public class TextCloudEventData
    implements CloudEventData {
        private final String text;

        TextCloudEventData(String text) {
            this.text = text;
        }

        public byte[] toBytes() {
            return this.text.getBytes();
        }
    }
}

