/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl.expressions;

import io.cloudevents.CloudEvent;
import io.cloudevents.sql.EvaluationRuntime;
import io.cloudevents.sql.ExceptionFactory;
import io.cloudevents.sql.impl.ExpressionInternal;
import io.cloudevents.sql.impl.ExpressionInternalVisitor;
import io.cloudevents.sql.impl.expressions.BaseExpression;
import io.cloudevents.sql.impl.runtime.EvaluationResult;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.misc.Interval;

public class LikeExpression
extends BaseExpression {
    private final ExpressionInternal internal;
    private final Pattern pattern;

    public LikeExpression(Interval expressionInterval, String expressionText, ExpressionInternal internal, String pattern) {
        super(expressionInterval, expressionText);
        this.internal = internal;
        this.pattern = this.convertLikePatternToRegex(pattern);
    }

    @Override
    public EvaluationResult evaluate(EvaluationRuntime runtime, CloudEvent event, ExceptionFactory exceptionFactory) {
        EvaluationResult result = this.castToString(exceptionFactory, this.internal.evaluate(runtime, event, exceptionFactory));
        return result.copyWithValue(this.pattern.matcher((String)result.value()).matches());
    }

    private Pattern convertLikePatternToRegex(String pattern) {
        StringBuilder builder = new StringBuilder();
        builder.append("^\\Q");
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == '\\' && i < pattern.length() - 1) {
                if (pattern.charAt(i + 1) == '%') {
                    builder.append('%');
                    ++i;
                    continue;
                }
                if (pattern.charAt(i + 1) == '_') {
                    builder.append('_');
                    ++i;
                    continue;
                }
            }
            if (pattern.charAt(i) == '_') {
                builder.append("\\E.\\Q");
                continue;
            }
            if (pattern.charAt(i) == '%') {
                builder.append("\\E.*\\Q");
                continue;
            }
            builder.append(pattern.charAt(i));
        }
        builder.append("\\E$");
        return Pattern.compile(builder.toString());
    }

    @Override
    public <T> T visit(ExpressionInternalVisitor<T> visitor) {
        return visitor.visitLikeExpression(this);
    }
}

