/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl.expressions;

import io.cloudevents.CloudEvent;
import io.cloudevents.sql.EvaluationRuntime;
import io.cloudevents.sql.ExceptionFactory;
import io.cloudevents.sql.Type;
import io.cloudevents.sql.impl.ExpressionInternal;
import io.cloudevents.sql.impl.expressions.BaseBinaryExpression;
import io.cloudevents.sql.impl.runtime.EvaluationContextImpl;
import io.cloudevents.sql.impl.runtime.EvaluationResult;
import io.cloudevents.sql.impl.runtime.TypeCastingProvider;
import java.util.Objects;
import java.util.function.BiFunction;
import org.antlr.v4.runtime.misc.Interval;

public class ComparisonExpression
extends BaseBinaryExpression {
    private final Comparison comparison;

    public ComparisonExpression(Interval expressionInterval, String expressionText, ExpressionInternal leftOperand, ExpressionInternal rightOperand, Comparison comparison) {
        super(expressionInterval, expressionText, leftOperand, rightOperand);
        this.comparison = comparison;
    }

    @Override
    public EvaluationResult evaluate(EvaluationRuntime runtime, CloudEvent event, ExceptionFactory exceptionFactory) {
        EvaluationResult left = this.getLeftOperand().evaluate(runtime, event, exceptionFactory);
        EvaluationResult right = this.getRightOperand().evaluate(runtime, event, exceptionFactory);
        if (left.isMissingAttributeException() || right.isMissingAttributeException()) {
            return left.wrapExceptions(right).copyWithDefaultValueForType(Type.BOOLEAN);
        }
        left = TypeCastingProvider.cast(new EvaluationContextImpl(this.expressionInterval(), this.expressionText(), exceptionFactory), left, Type.fromValue(right.value()));
        return new EvaluationResult(this.comparison.evaluate(left.value(), right.value()), null, left, right);
    }

    public static enum Comparison {
        EQUALS(Objects::equals),
        NOT_EQUALS((x, y) -> !Objects.equals(x, y));

        private final BiFunction<Object, Object, Boolean> fn;

        private Comparison(BiFunction<Object, Object, Boolean> fn) {
            this.fn = fn;
        }

        boolean evaluate(Object a, Object b) {
            return this.fn.apply(a, b);
        }
    }
}

