/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl.expressions;

import io.cloudevents.CloudEvent;
import io.cloudevents.sql.EvaluationException;
import io.cloudevents.sql.EvaluationRuntime;
import io.cloudevents.sql.Function;
import io.cloudevents.sql.impl.ExceptionThrower;
import io.cloudevents.sql.impl.ExpressionInternal;
import io.cloudevents.sql.impl.ExpressionInternalVisitor;
import io.cloudevents.sql.impl.expressions.BaseExpression;
import io.cloudevents.sql.impl.runtime.EvaluationContextImpl;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.misc.Interval;

public class FunctionInvocationExpression
extends BaseExpression {
    private final String functionName;
    private final List<ExpressionInternal> arguments;

    public FunctionInvocationExpression(Interval expressionInterval, String expressionText, String functionName, List<ExpressionInternal> arguments) {
        super(expressionInterval, expressionText);
        this.functionName = functionName.toUpperCase();
        this.arguments = arguments;
    }

    @Override
    public Object evaluate(EvaluationRuntime runtime, CloudEvent event, ExceptionThrower thrower) {
        Function function;
        EvaluationContextImpl context = new EvaluationContextImpl(this.expressionInterval(), this.expressionText(), thrower);
        try {
            function = runtime.resolveFunction(this.functionName, this.arguments.size());
        }
        catch (Exception e) {
            thrower.throwException(EvaluationException.cannotDispatchFunction(this.expressionInterval(), this.expressionText(), this.functionName, e));
            return "";
        }
        ArrayList<Object> computedArguments = new ArrayList<Object>(this.arguments.size());
        for (int i = 0; i < this.arguments.size(); ++i) {
            ExpressionInternal expr = this.arguments.get(i);
            Object computed = expr.evaluate(runtime, event, thrower);
            Object casted = runtime.cast(context, computed, function.typeOfParameter(i));
            computedArguments.add(casted);
        }
        return function.invoke(context, runtime, event, computedArguments);
    }

    @Override
    public <T> T visit(ExpressionInternalVisitor<T> visitor) {
        return visitor.visitFunctionInvocationExpression(this);
    }
}

