/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl;

import io.cloudevents.sql.ParseException;
import io.cloudevents.sql.Type;
import io.cloudevents.sql.generated.CESQLParserBaseVisitor;
import io.cloudevents.sql.generated.CESQLParserParser;
import io.cloudevents.sql.impl.ExpressionInternal;
import io.cloudevents.sql.impl.LiteralUtils;
import io.cloudevents.sql.impl.expressions.AccessAttributeExpression;
import io.cloudevents.sql.impl.expressions.AndExpression;
import io.cloudevents.sql.impl.expressions.DifferenceExpression;
import io.cloudevents.sql.impl.expressions.DivisionExpression;
import io.cloudevents.sql.impl.expressions.EqualExpression;
import io.cloudevents.sql.impl.expressions.ExistsExpression;
import io.cloudevents.sql.impl.expressions.FunctionInvocationExpression;
import io.cloudevents.sql.impl.expressions.InExpression;
import io.cloudevents.sql.impl.expressions.IntegerComparisonBinaryExpression;
import io.cloudevents.sql.impl.expressions.LikeExpression;
import io.cloudevents.sql.impl.expressions.ModuleExpression;
import io.cloudevents.sql.impl.expressions.MultiplicationExpression;
import io.cloudevents.sql.impl.expressions.NegateExpression;
import io.cloudevents.sql.impl.expressions.NotExpression;
import io.cloudevents.sql.impl.expressions.OrExpression;
import io.cloudevents.sql.impl.expressions.SumExpression;
import io.cloudevents.sql.impl.expressions.ValueExpression;
import io.cloudevents.sql.impl.expressions.XorExpression;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;

public class ExpressionTranslatorVisitor
extends CESQLParserBaseVisitor<ExpressionInternal> {
    @Override
    public ExpressionInternal visitCesql(CESQLParserParser.CesqlContext ctx) {
        return (ExpressionInternal)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public ExpressionInternal visitBooleanLiteral(CESQLParserParser.BooleanLiteralContext ctx) {
        if (ctx.TRUE() != null) {
            return new ValueExpression(ctx.getSourceInterval(), ctx.getText(), true);
        }
        return new ValueExpression(ctx.getSourceInterval(), ctx.getText(), false);
    }

    @Override
    public ExpressionInternal visitIntegerLiteral(CESQLParserParser.IntegerLiteralContext ctx) {
        try {
            return ValueExpression.fromIntegerLiteral(ctx.INTEGER_LITERAL());
        }
        catch (RuntimeException e) {
            throw ParseException.cannotParseValue((ParseTree)ctx, Type.INTEGER, e);
        }
    }

    @Override
    public ExpressionInternal visitStringLiteral(CESQLParserParser.StringLiteralContext ctx) {
        try {
            if (ctx.DQUOTED_STRING_LITERAL() != null) {
                return ValueExpression.fromDQuotedStringLiteral(ctx.DQUOTED_STRING_LITERAL());
            }
            return ValueExpression.fromSQuotedStringLiteral(ctx.SQUOTED_STRING_LITERAL());
        }
        catch (RuntimeException e) {
            throw ParseException.cannotParseValue((ParseTree)ctx, Type.STRING, e);
        }
    }

    @Override
    public ExpressionInternal visitSubExpression(CESQLParserParser.SubExpressionContext ctx) {
        return (ExpressionInternal)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public ExpressionInternal visitExistsExpression(CESQLParserParser.ExistsExpressionContext ctx) {
        return new ExistsExpression(ctx.getSourceInterval(), ctx.getText(), ctx.identifier().getText());
    }

    @Override
    public ExpressionInternal visitUnaryLogicExpression(CESQLParserParser.UnaryLogicExpressionContext ctx) {
        ExpressionInternal internal = (ExpressionInternal)this.visit((ParseTree)ctx.expression());
        return new NotExpression(ctx.getSourceInterval(), ctx.getText(), internal);
    }

    @Override
    public ExpressionInternal visitUnaryNumericExpression(CESQLParserParser.UnaryNumericExpressionContext ctx) {
        ExpressionInternal internal = (ExpressionInternal)this.visit((ParseTree)ctx.expression());
        return new NegateExpression(ctx.getSourceInterval(), ctx.getText(), internal);
    }

    @Override
    public ExpressionInternal visitIdentifier(CESQLParserParser.IdentifierContext ctx) {
        return new AccessAttributeExpression(ctx.getSourceInterval(), ctx.getText(), ctx.getText());
    }

    @Override
    public ExpressionInternal visitInExpression(CESQLParserParser.InExpressionContext ctx) {
        ExpressionInternal leftExpression = (ExpressionInternal)this.visit((ParseTree)ctx.expression());
        List<ExpressionInternal> setExpressions = ctx.setExpression().expression().stream().map(arg_0 -> ((ExpressionTranslatorVisitor)this).visit(arg_0)).collect(Collectors.toList());
        InExpression inExpression = new InExpression(ctx.getSourceInterval(), ctx.getText(), leftExpression, setExpressions);
        return ctx.NOT() != null ? new NotExpression(ctx.getSourceInterval(), ctx.getText(), inExpression) : inExpression;
    }

    @Override
    public ExpressionInternal visitBinaryMultiplicativeExpression(CESQLParserParser.BinaryMultiplicativeExpressionContext ctx) {
        ExpressionInternal leftExpression = (ExpressionInternal)this.visit((ParseTree)ctx.expression(0));
        ExpressionInternal rightExpression = (ExpressionInternal)this.visit((ParseTree)ctx.expression(1));
        if (ctx.STAR() != null) {
            return new MultiplicationExpression(ctx.getSourceInterval(), ctx.getText(), leftExpression, rightExpression);
        }
        if (ctx.DIVIDE() != null) {
            return new DivisionExpression(ctx.getSourceInterval(), ctx.getText(), leftExpression, rightExpression);
        }
        return new ModuleExpression(ctx.getSourceInterval(), ctx.getText(), leftExpression, rightExpression);
    }

    @Override
    public ExpressionInternal visitBinaryAdditiveExpression(CESQLParserParser.BinaryAdditiveExpressionContext ctx) {
        ExpressionInternal leftExpression = (ExpressionInternal)this.visit((ParseTree)ctx.expression(0));
        ExpressionInternal rightExpression = (ExpressionInternal)this.visit((ParseTree)ctx.expression(1));
        if (ctx.PLUS() != null) {
            return new SumExpression(ctx.getSourceInterval(), ctx.getText(), leftExpression, rightExpression);
        }
        return new DifferenceExpression(ctx.getSourceInterval(), ctx.getText(), leftExpression, rightExpression);
    }

    @Override
    public ExpressionInternal visitBinaryComparisonExpression(CESQLParserParser.BinaryComparisonExpressionContext ctx) {
        ExpressionInternal leftExpression = (ExpressionInternal)this.visit((ParseTree)ctx.expression(0));
        ExpressionInternal rightExpression = (ExpressionInternal)this.visit((ParseTree)ctx.expression(1));
        if (ctx.EQUAL() != null) {
            return new EqualExpression(ctx.getSourceInterval(), ctx.getText(), leftExpression, rightExpression);
        }
        if (ctx.NOT_EQUAL() != null || ctx.LESS_GREATER() != null) {
            return new NotExpression(ctx.getSourceInterval(), ctx.getText(), new EqualExpression(ctx.getSourceInterval(), ctx.getText(), leftExpression, rightExpression));
        }
        IntegerComparisonBinaryExpression.Operation op = ctx.LESS() != null ? IntegerComparisonBinaryExpression.Operation.LESS : (ctx.LESS_OR_EQUAL() != null ? IntegerComparisonBinaryExpression.Operation.LESS_OR_EQUAL : (ctx.GREATER() != null ? IntegerComparisonBinaryExpression.Operation.GREATER : IntegerComparisonBinaryExpression.Operation.GREATER_OR_EQUAL));
        return new IntegerComparisonBinaryExpression(ctx.getSourceInterval(), ctx.getText(), leftExpression, rightExpression, op);
    }

    @Override
    public ExpressionInternal visitBinaryLogicExpression(CESQLParserParser.BinaryLogicExpressionContext ctx) {
        ExpressionInternal leftExpression = (ExpressionInternal)this.visit((ParseTree)ctx.expression(0));
        ExpressionInternal rightExpression = (ExpressionInternal)this.visit((ParseTree)ctx.expression(1));
        if (ctx.AND() != null) {
            return new AndExpression(ctx.getSourceInterval(), ctx.getText(), leftExpression, rightExpression);
        }
        if (ctx.OR() != null) {
            return new OrExpression(ctx.getSourceInterval(), ctx.getText(), leftExpression, rightExpression);
        }
        return new XorExpression(ctx.getSourceInterval(), ctx.getText(), leftExpression, rightExpression);
    }

    @Override
    public ExpressionInternal visitLikeExpression(CESQLParserParser.LikeExpressionContext ctx) {
        ExpressionInternal leftExpression = (ExpressionInternal)this.visit((ParseTree)ctx.expression());
        LikeExpression likeExpression = new LikeExpression(ctx.getSourceInterval(), ctx.getText(), leftExpression, ctx.stringLiteral().DQUOTED_STRING_LITERAL() != null ? LiteralUtils.parseDQuotedStringLiteral(ctx.stringLiteral().DQUOTED_STRING_LITERAL()) : LiteralUtils.parseSQuotedStringLiteral(ctx.stringLiteral().SQUOTED_STRING_LITERAL()));
        return ctx.NOT() != null ? new NotExpression(ctx.getSourceInterval(), ctx.getText(), likeExpression) : likeExpression;
    }

    @Override
    public ExpressionInternal visitFunctionInvocationExpression(CESQLParserParser.FunctionInvocationExpressionContext ctx) {
        List<ExpressionInternal> parameters = ctx.functionParameterList().expression().stream().map(arg_0 -> ((ExpressionTranslatorVisitor)this).visit(arg_0)).collect(Collectors.toList());
        return new FunctionInvocationExpression(ctx.getSourceInterval(), ctx.getText(), ctx.functionIdentifier().getText(), parameters);
    }
}

