/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.rocketmq;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.core.message.impl.BaseGenericBinaryMessageReaderImpl;
import io.cloudevents.rocketmq.RocketmqConstants;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiConsumer;

final class RocketmqBinaryMessageReader
extends BaseGenericBinaryMessageReaderImpl<String, Object> {
    private final String contentType;
    private final Map<String, String> messageProperties;

    RocketmqBinaryMessageReader(SpecVersion specVersion, Map<String, String> messageProperties, String contentType, byte[] body) {
        super(specVersion, body != null && !Arrays.equals(RocketmqConstants.EMPTY_BODY, body) && body.length > 0 ? BytesCloudEventData.wrap((byte[])body) : null);
        this.contentType = contentType;
        this.messageProperties = messageProperties;
    }

    protected boolean isContentTypeHeader(String key) {
        return key.equals("CE_contenttype");
    }

    protected boolean isCloudEventsHeader(String key) {
        int prefixLength = "CE_".length();
        return key.length() > prefixLength && key.startsWith("CE_");
    }

    protected String toCloudEventsKey(String key) {
        return key.substring("CE_".length());
    }

    protected void forEachHeader(BiConsumer<String, Object> fn) {
        if (this.contentType != null) {
            fn.accept("CE_contenttype", this.contentType);
        }
        this.messageProperties.forEach((k, v) -> {
            if (k != null && v != null) {
                fn.accept((String)k, v);
            }
        });
    }

    protected String toCloudEventsValue(Object value) {
        return value.toString();
    }
}

