/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.rocketmq;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.message.MessageReader;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.core.message.impl.GenericStructuredMessageReader;
import io.cloudevents.core.message.impl.MessageUtils;
import io.cloudevents.rocketmq.RocketmqBinaryMessageReader;
import io.cloudevents.rocketmq.RocketmqConstants;
import io.cloudevents.rocketmq.RocketmqMessageWriter;
import io.cloudevents.rw.CloudEventWriter;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageView;

public class RocketMqMessageFactory {
    private RocketMqMessageFactory() {
    }

    public static MessageReader createReader(MessageView message) {
        ByteBuffer byteBuffer = message.getBody();
        byte[] body = new byte[byteBuffer.remaining()];
        byteBuffer.get(body);
        Map properties = message.getProperties();
        String contentType = (String)properties.get("CE_contenttype");
        return RocketMqMessageFactory.createReader(contentType, properties, body);
    }

    public static MessageReader createReader(String contentType, Map<String, String> properties, byte[] body) {
        return MessageUtils.parseStructuredOrBinaryMessage(() -> contentType, format -> new GenericStructuredMessageReader(format, body), () -> (String)properties.get(RocketmqConstants.MESSAGE_PROPERTY_SPEC_VERSION), sv -> new RocketmqBinaryMessageReader((SpecVersion)sv, properties, contentType, body));
    }

    public static MessageWriter<CloudEventWriter<Message>, Message> createWriter(String topic) {
        return new RocketmqMessageWriter(topic);
    }
}

