/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.protobuf;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventContext;
import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.CloudEventUtils;
import io.cloudevents.protobuf.ProtoCloudEventData;
import io.cloudevents.protobuf.ProtoSupport;
import io.cloudevents.rw.CloudEventContextReader;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.v1.proto.CloudEvent;
import java.net.URI;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class ProtoSerializer {
    ProtoSerializer() {
    }

    public static io.cloudevents.v1.proto.CloudEvent toProto(CloudEvent ce) throws InvalidProtocolBufferException {
        CloudEvent.Builder builder = io.cloudevents.v1.proto.CloudEvent.newBuilder();
        builder.setSpecVersion(ce.getSpecVersion().toString());
        ProtoCloudEventWriter protoCloudEventWriter = new ProtoCloudEventWriter(builder, ce.getSpecVersion());
        CloudEventContextReader cloudEventContextReader = CloudEventUtils.toContextReader((CloudEventContext)ce);
        cloudEventContextReader.readContext((CloudEventContextWriter)protoCloudEventWriter);
        CloudEventData data = ce.getData();
        if (data != null) {
            return protoCloudEventWriter.end(data);
        }
        return protoCloudEventWriter.end();
    }

    public static class ProtoCloudEventWriter
    implements CloudEventWriter<io.cloudevents.v1.proto.CloudEvent> {
        private static final Map<String, Descriptors.FieldDescriptor> attributeToFieldNumV1;
        private static final Map<SpecVersion, Map<String, Descriptors.FieldDescriptor>> versionToAttrs;
        private final CloudEvent.Builder protoBuilder;
        private final Map<String, Descriptors.FieldDescriptor> requiredAttributeNumberMap;

        public ProtoCloudEventWriter(CloudEvent.Builder protoBuilder, SpecVersion spec) {
            this.protoBuilder = protoBuilder;
            this.requiredAttributeNumberMap = versionToAttrs.get(spec);
            if (this.requiredAttributeNumberMap == null) {
                throw CloudEventRWException.newInvalidSpecVersion((String)spec.toString());
            }
        }

        private boolean setRequiredField(String name, Object value) {
            Descriptors.FieldDescriptor fieldDescriptor = this.requiredAttributeNumberMap.get(name);
            if (fieldDescriptor == null) {
                return false;
            }
            this.protoBuilder.setField(fieldDescriptor, value);
            return true;
        }

        public CloudEventContextWriter withContextAttribute(String name, String value) throws CloudEventRWException {
            if (!this.setRequiredField(name, value)) {
                this.protoBuilder.putAttributes(name, CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(value).build());
            }
            return this;
        }

        public CloudEventContextWriter withContextAttribute(String name, URI value) throws CloudEventRWException {
            if (!this.setRequiredField(name, value.toString())) {
                CloudEvent.CloudEventAttributeValue.Builder builder = CloudEvent.CloudEventAttributeValue.newBuilder();
                if (value.isAbsolute()) {
                    this.protoBuilder.putAttributes(name, builder.setCeUri(value.toString()).build());
                } else {
                    this.protoBuilder.putAttributes(name, builder.setCeUriRef(value.toString()).build());
                }
            }
            return this;
        }

        public CloudEventContextWriter withContextAttribute(String name, OffsetDateTime value) throws CloudEventRWException {
            Instant instant = value.toInstant();
            Timestamp ts = Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
            if (!this.setRequiredField(name, ts)) {
                this.protoBuilder.putAttributes(name, CloudEvent.CloudEventAttributeValue.newBuilder().setCeTimestamp(ts).build());
            }
            return this;
        }

        public CloudEventContextWriter withContextAttribute(String name, Number value) throws CloudEventRWException {
            if (value instanceof Integer) {
                return this.withContextAttribute(name, (Integer)value);
            }
            return this.withContextAttribute(name, value.toString());
        }

        public CloudEventContextWriter withContextAttribute(String name, Boolean value) throws CloudEventRWException {
            if (!this.setRequiredField(name, value)) {
                this.protoBuilder.putAttributes(name, CloudEvent.CloudEventAttributeValue.newBuilder().setCeBoolean(value).build());
            }
            return this;
        }

        public CloudEventContextWriter withContextAttribute(String name, byte[] value) throws CloudEventRWException {
            if (!this.setRequiredField(name, value)) {
                CloudEvent.CloudEventAttributeValue.Builder builder = CloudEvent.CloudEventAttributeValue.newBuilder().setCeBytes(ByteString.copyFrom((byte[])value));
                this.protoBuilder.putAttributes(name, builder.build());
            }
            return this;
        }

        public CloudEventContextWriter withContextAttribute(String name, Integer value) throws CloudEventRWException {
            if (!this.setRequiredField(name, value)) {
                CloudEvent.CloudEventAttributeValue.Builder builder = CloudEvent.CloudEventAttributeValue.newBuilder();
                builder.setCeInteger(value);
                this.protoBuilder.putAttributes(name, builder.build());
            }
            return this;
        }

        public io.cloudevents.v1.proto.CloudEvent end(CloudEventData data) throws CloudEventRWException {
            if (data != null) {
                String dataContentType = null;
                Map<String, CloudEvent.CloudEventAttributeValue> attributesMap = this.protoBuilder.getAttributesMap();
                CloudEvent.CloudEventAttributeValue attrVal = attributesMap.get("datacontenttype");
                if (attrVal != null && attrVal.hasCeString()) {
                    dataContentType = attrVal.getCeString();
                }
                if (data instanceof ProtoCloudEventData) {
                    ProtoCloudEventData protoData = (ProtoCloudEventData)data;
                    Message m = protoData.getMessage();
                    if (m != null) {
                        if (m instanceof Any) {
                            this.protoBuilder.setProtoData((Any)m);
                        } else {
                            this.protoBuilder.setProtoData(Any.pack((Message)m));
                        }
                    }
                } else if (Objects.equals(dataContentType, "application/protobuf")) {
                    Any dataAsAny = null;
                    try {
                        dataAsAny = Any.parseFrom((byte[])data.toBytes());
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw CloudEventRWException.newDataConversion((Throwable)e, (String)"byte[]", (String)"com.google.protobuf.Any");
                    }
                    this.protoBuilder.setProtoData(dataAsAny);
                } else if (ProtoSupport.isTextContent(dataContentType)) {
                    this.protoBuilder.setTextDataBytes(ByteString.copyFrom((byte[])data.toBytes()));
                } else {
                    ByteString byteString = ByteString.copyFrom((byte[])data.toBytes());
                    this.protoBuilder.setBinaryData(byteString);
                }
            }
            return this.protoBuilder.build();
        }

        public io.cloudevents.v1.proto.CloudEvent end() throws CloudEventRWException {
            return this.protoBuilder.build();
        }

        static {
            HashMap<String, Descriptors.FieldDescriptor> tmp = new HashMap<String, Descriptors.FieldDescriptor>();
            tmp.put("id", io.cloudevents.v1.proto.CloudEvent.getDescriptor().findFieldByNumber(1));
            tmp.put("source", io.cloudevents.v1.proto.CloudEvent.getDescriptor().findFieldByNumber(2));
            tmp.put("type", io.cloudevents.v1.proto.CloudEvent.getDescriptor().findFieldByNumber(4));
            tmp.put("specversion", io.cloudevents.v1.proto.CloudEvent.getDescriptor().findFieldByNumber(3));
            attributeToFieldNumV1 = Collections.unmodifiableMap(tmp);
            HashMap<SpecVersion, Map<String, Descriptors.FieldDescriptor>> tmpMap = new HashMap<SpecVersion, Map<String, Descriptors.FieldDescriptor>>();
            tmpMap.put(SpecVersion.V1, attributeToFieldNumV1);
            tmpMap.put(SpecVersion.V03, attributeToFieldNumV1);
            versionToAttrs = Collections.unmodifiableMap(tmpMap);
        }
    }
}

