/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.http.vertx.impl;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.core.message.impl.BaseGenericBinaryMessageReaderImpl;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import java.util.Objects;
import java.util.function.BiConsumer;

public class BinaryVertxMessageReaderImpl
extends BaseGenericBinaryMessageReaderImpl<String, String> {
    private final MultiMap headers;

    public BinaryVertxMessageReaderImpl(SpecVersion version, MultiMap headers, Buffer body) {
        super(version, body != null && body.length() > 0 ? new BytesCloudEventData(body.getBytes()) : null);
        Objects.requireNonNull(headers);
        this.headers = headers;
    }

    protected boolean isContentTypeHeader(String key) {
        return key.equalsIgnoreCase(HttpHeaders.CONTENT_TYPE.toString());
    }

    protected boolean isCloudEventsHeader(String key) {
        return key.length() > 3 && key.substring(0, "ce-".length()).toLowerCase().startsWith("ce-");
    }

    protected String toCloudEventsKey(String key) {
        return key.substring("ce-".length()).toLowerCase();
    }

    protected void forEachHeader(BiConsumer<String, String> fn) {
        this.headers.forEach(e -> fn.accept((String)e.getKey(), (String)e.getValue()));
    }

    protected String toCloudEventsValue(String value) {
        return value;
    }
}

