/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.http.impl;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.message.impl.BaseGenericBinaryMessageReaderImpl;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class HttpMessageReader
extends BaseGenericBinaryMessageReaderImpl<String, String> {
    private final Consumer<BiConsumer<String, String>> forEachHeader;

    public HttpMessageReader(SpecVersion version, Consumer<BiConsumer<String, String>> forEachHeader, byte[] body) {
        super(version, body);
        this.forEachHeader = forEachHeader;
    }

    protected boolean isContentTypeHeader(String key) {
        return "Content-Type".equalsIgnoreCase(key);
    }

    protected boolean isCloudEventsHeader(String key) {
        return key != null && key.length() > 3 && key.substring(0, "ce-".length()).toLowerCase().startsWith("ce-");
    }

    protected String toCloudEventsKey(String key) {
        return key.substring("ce-".length()).toLowerCase();
    }

    protected void forEachHeader(BiConsumer<String, String> fn) {
        this.forEachHeader.accept(fn);
    }

    protected String toCloudEventsValue(String value) {
        return value;
    }
}

