/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.impl;

import io.cloudevents.CloudEventContext;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventContextReader;
import io.cloudevents.rw.CloudEventExtensionsWriter;

public class CloudEventContextReaderAdapter
implements CloudEventContextReader {
    private final CloudEventContext event;

    public CloudEventContextReaderAdapter(CloudEventContext event) {
        this.event = event;
    }

    public void readAttributes(CloudEventAttributesWriter writer) throws RuntimeException {
        writer.withAttribute("id", this.event.getId());
        writer.withAttribute("source", this.event.getSource());
        writer.withAttribute("type", this.event.getType());
        if (this.event.getDataContentType() != null) {
            writer.withAttribute("datacontenttype", this.event.getDataContentType());
        }
        if (this.event.getDataSchema() != null) {
            writer.withAttribute("dataschema", this.event.getDataSchema());
        }
        if (this.event.getSubject() != null) {
            writer.withAttribute("subject", this.event.getSubject());
        }
        if (this.event.getTime() != null) {
            writer.withAttribute("time", this.event.getTime());
        }
    }

    public void readExtensions(CloudEventExtensionsWriter writer) throws RuntimeException {
        for (String key : this.event.getExtensionNames()) {
            Object value = this.event.getExtension(key);
            if (value instanceof String) {
                writer.withExtension(key, (String)value);
                continue;
            }
            if (value instanceof Number) {
                writer.withExtension(key, (Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                writer.withExtension(key, (Boolean)value);
                continue;
            }
            throw new IllegalStateException("Illegal value inside extensions map: " + key + " " + value);
        }
    }
}

