/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.v1;

import io.cloudevents.core.v1.CloudEventBuilder;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.types.Time;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;

class V03ToV1AttributesConverter
implements CloudEventAttributesWriter {
    private final CloudEventBuilder builder;

    V03ToV1AttributesConverter(CloudEventBuilder builder) {
        this.builder = builder;
    }

    public void setAttribute(String name, String value) throws CloudEventRWException {
        switch (name) {
            case "id": {
                this.builder.withId(value);
                return;
            }
            case "source": {
                try {
                    this.builder.withSource(new URI(value));
                }
                catch (URISyntaxException e) {
                    throw CloudEventRWException.newInvalidAttributeValue((String)"source", (Object)value, (Throwable)e);
                }
                return;
            }
            case "type": {
                this.builder.withType(value);
                return;
            }
            case "datacontenttype": {
                this.builder.withDataContentType(value);
                return;
            }
            case "schemaurl": {
                try {
                    this.builder.withDataSchema(new URI(value));
                }
                catch (URISyntaxException e) {
                    throw CloudEventRWException.newInvalidAttributeValue((String)"dataschema", (Object)value, (Throwable)e);
                }
                return;
            }
            case "subject": {
                this.builder.withSubject(value);
                return;
            }
            case "time": {
                try {
                    this.builder.withTime(Time.parseTime((String)value));
                }
                catch (DateTimeParseException e) {
                    throw CloudEventRWException.newInvalidAttributeValue((String)"time", (Object)value, (Throwable)e);
                }
                return;
            }
        }
        throw CloudEventRWException.newInvalidAttributeName((String)name);
    }

    public void setAttribute(String name, URI value) throws CloudEventRWException {
        switch (name) {
            case "source": {
                this.builder.withSource(value);
                return;
            }
            case "schemaurl": {
                this.builder.withDataSchema(value);
                return;
            }
        }
        throw CloudEventRWException.newInvalidAttributeType((String)name, URI.class);
    }

    public void setAttribute(String name, OffsetDateTime value) throws CloudEventRWException {
        if ("time".equals(name)) {
            this.builder.withTime(value);
            return;
        }
        throw CloudEventRWException.newInvalidAttributeType((String)name, OffsetDateTime.class);
    }
}

