/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.message;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.Encoding;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.core.message.StructuredMessageReader;
import io.cloudevents.core.message.StructuredMessageWriter;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventExtensionsWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventReader;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface MessageReader
extends StructuredMessageReader,
CloudEventReader {
    public <V extends CloudEventWriter<R>, R> R read(CloudEventWriterFactory<V, R> var1) throws CloudEventRWException, IllegalStateException;

    public void readAttributes(CloudEventAttributesWriter var1) throws CloudEventRWException, IllegalStateException;

    public void readExtensions(CloudEventExtensionsWriter var1) throws CloudEventRWException, IllegalStateException;

    @Override
    public <T> T read(StructuredMessageWriter<T> var1) throws CloudEventRWException, IllegalStateException;

    public Encoding getEncoding();

    default public <BV extends CloudEventWriter<R>, R> R visit(MessageWriter<BV, R> visitor) throws CloudEventRWException, IllegalStateException {
        switch (this.getEncoding()) {
            case BINARY: {
                return this.read((CloudEventWriterFactory)visitor);
            }
            case STRUCTURED: {
                return (R)this.read((StructuredMessageWriter)visitor);
            }
        }
        throw new IllegalStateException("Unknown encoding");
    }

    @Override
    default public CloudEvent toEvent() throws CloudEventRWException, IllegalStateException {
        switch (this.getEncoding()) {
            case BINARY: {
                return (CloudEvent)this.read(CloudEventBuilder::fromSpecVersion);
            }
            case STRUCTURED: {
                return this.read(EventFormat::deserialize);
            }
        }
        throw new IllegalStateException("Unknown encoding");
    }
}

