/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.v02;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.cloudevents.Attributes;
import io.cloudevents.json.ZonedDateTimeDeserializer;
import io.cloudevents.v02.ContextAttributes;
import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class AttributesImpl
implements Attributes {
    @NotBlank
    private final String type;
    @NotBlank
    @Pattern(regexp="0\\.2")
    private final @NotBlank @Pattern(regexp="0\\.2") String specversion;
    @NotNull
    private final URI source;
    @NotBlank
    private final String id;
    private final ZonedDateTime time;
    private final URI schemaurl;
    private final String contenttype;

    AttributesImpl(String type, String specversion, URI source, String id, ZonedDateTime time, URI schemaurl, String contenttype) {
        this.type = type;
        this.specversion = specversion;
        this.source = source;
        this.id = id;
        this.time = time;
        this.schemaurl = schemaurl;
        this.contenttype = contenttype;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getSpecversion() {
        return this.specversion;
    }

    public URI getSource() {
        return this.source;
    }

    @JsonDeserialize(using=ZonedDateTimeDeserializer.class)
    public Optional<ZonedDateTime> getTime() {
        return Optional.ofNullable(this.time);
    }

    public Optional<URI> getSchemaurl() {
        return Optional.ofNullable(this.schemaurl);
    }

    public Optional<String> getContenttype() {
        return Optional.ofNullable(this.contenttype);
    }

    @Override
    public Optional<String> getMediaType() {
        return this.getContenttype();
    }

    @JsonCreator
    public static AttributesImpl build(@JsonProperty(value="id") String id, @JsonProperty(value="source") URI source, @JsonProperty(value="specversion") String specversion, @JsonProperty(value="type") String type, @JsonProperty(value="time") ZonedDateTime time, @JsonProperty(value="schemaurl") URI schemaurl, @JsonProperty(value="contenttype") String contenttype) {
        return new AttributesImpl(type, specversion, source, id, time, schemaurl, contenttype);
    }

    public static AttributesImpl unmarshal(Map<String, String> attributes) {
        String type = attributes.get(ContextAttributes.type.name());
        ZonedDateTime time = Optional.ofNullable(attributes.get(ContextAttributes.time.name())).map(t -> ZonedDateTime.parse(t, DateTimeFormatter.ISO_ZONED_DATE_TIME)).orElse(null);
        String specversion = attributes.get(ContextAttributes.specversion.name());
        URI source = URI.create(attributes.get(ContextAttributes.source.name()));
        URI schemaurl = Optional.ofNullable(attributes.get(ContextAttributes.schemaurl.name())).map(schema -> URI.create(schema)).orElse(null);
        String id = attributes.get(ContextAttributes.id.name());
        String contenttype = attributes.get(ContextAttributes.contenttype.name());
        return AttributesImpl.build(id, source, specversion, type, time, schemaurl, contenttype);
    }

    public static Map<String, String> marshal(AttributesImpl attributes) {
        Objects.requireNonNull(attributes);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(ContextAttributes.type.name(), attributes.getType());
        result.put(ContextAttributes.specversion.name(), attributes.getSpecversion());
        result.put(ContextAttributes.source.name(), attributes.getSource().toString());
        result.put(ContextAttributes.id.name(), attributes.getId());
        attributes.getTime().ifPresent(value -> result.put(ContextAttributes.time.name(), value.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)));
        attributes.getSchemaurl().ifPresent(schema -> result.put(ContextAttributes.schemaurl.name(), schema.toString()));
        attributes.getContenttype().ifPresent(ct -> result.put(ContextAttributes.contenttype.name(), (String)ct));
        return result;
    }
}

