/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.extensions;

import io.cloudevents.extensions.InMemoryFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public interface ExtensionFormat {
    public InMemoryFormat memory();

    public Map<String, String> transport();

    public static ExtensionFormat of(final InMemoryFormat inMemory, String key, String value) {
        final HashMap<String, String> transport = new HashMap<String, String>();
        transport.put(key, value);
        return new ExtensionFormat(){

            @Override
            public InMemoryFormat memory() {
                return inMemory;
            }

            @Override
            public Map<String, String> transport() {
                return Collections.unmodifiableMap(transport);
            }
        };
    }

    @SafeVarargs
    public static ExtensionFormat of(final InMemoryFormat inMemory, Map.Entry<String, String> ... transport) {
        Objects.requireNonNull(inMemory);
        Objects.requireNonNull(transport);
        final Map<String, String> transports = Arrays.asList(transport).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new ExtensionFormat(){

            @Override
            public InMemoryFormat memory() {
                return inMemory;
            }

            @Override
            public Map<String, String> transport() {
                return transports;
            }
        };
    }

    public static Map<String, String> marshal(Collection<ExtensionFormat> extensions) {
        return extensions.stream().map(ExtensionFormat::transport).flatMap(t -> t.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

