/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.ServerSentEvent;
import io.clientcore.core.http.models.ServerSentEventListener;
import io.clientcore.core.implementation.utils.ServerSentEventHelper;
import io.clientcore.core.models.ServerSentResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;

public final class ServerSentEventUtils {
    private static final String DEFAULT_EVENT = "message";
    private static final HttpHeaderName LAST_EVENT_ID = HttpHeaderName.fromString("Last-Event-Id");

    private ServerSentEventUtils() {
    }

    public static boolean isTextEventStreamContentType(String contentType) {
        if (contentType != null) {
            return "text/event-stream".regionMatches(true, 0, contentType, 0, "text/event-stream".length());
        }
        return false;
    }

    public static ServerSentResult processTextEventStream(InputStream inputStream, ServerSentEventListener listener) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            ServerSentResult serverSentResult = ServerSentEventUtils.processBuffer(reader, listener);
            return serverSentResult;
        }
    }

    public static boolean attemptRetry(ServerSentResult serverSentResult, HttpRequest httpRequest) {
        if (ServerSentEventUtils.shouldDefaultRetry(serverSentResult.getRetryAfter())) {
            long millis;
            if (serverSentResult.getException() != null) {
                return false;
            }
            if (serverSentResult.getLastEventId() != null) {
                httpRequest.getHeaders().set(LAST_EVENT_ID, serverSentResult.getLastEventId());
            }
            if ((millis = serverSentResult.getRetryAfter().toMillis()) > 0L) {
                try {
                    Thread.sleep(serverSentResult.getRetryAfter().toMillis());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    private static boolean shouldDefaultRetry(Duration retryAfter) {
        return retryAfter != null;
    }

    private static boolean isEndOfBlock(StringBuilder sb) {
        return sb.lastIndexOf("\n\n") >= 0;
    }

    private static ServerSentResult processBuffer(BufferedReader reader, ServerSentEventListener listener) {
        ServerSentEvent event = null;
        ArrayList<String> allCollectedData = new ArrayList<String>();
        try {
            String line;
            StringBuilder collectedData = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                collectedData.append(line).append("\n");
                if (!ServerSentEventUtils.isEndOfBlock(collectedData)) continue;
                String temp = collectedData.toString();
                allCollectedData.add(temp.trim().replace("data: ", ""));
                event = ServerSentEventUtils.processLines(collectedData.toString().split("\n"));
                if (!Objects.equals(event.getEvent(), DEFAULT_EVENT) || event.getData() != null) {
                    listener.onEvent(event);
                }
                collectedData = new StringBuilder();
            }
            listener.onClose();
        }
        catch (IOException e) {
            return new ServerSentResult(e, event != null ? event.getId() : null, event != null ? ServerSentEventHelper.getRetryAfter(event) : null, null);
        }
        return new ServerSentResult(null, event.getId(), ServerSentEventHelper.getRetryAfter(event), allCollectedData);
    }

    private static ServerSentEvent processLines(String[] lines) {
        ArrayList<String> eventData = null;
        ServerSentEvent event = new ServerSentEvent();
        block12: for (String line : lines) {
            int idx = line.indexOf(58);
            if (idx == 0) {
                ServerSentEventHelper.setComment(event, line.substring(1).trim());
                continue;
            }
            String field = line.substring(0, idx < 0 ? lines.length : idx).trim().toLowerCase();
            String value = idx < 0 ? "" : line.substring(idx + 1).trim();
            switch (field) {
                case "event": {
                    ServerSentEventHelper.setEvent(event, value);
                    continue block12;
                }
                case "data": {
                    if (eventData == null) {
                        eventData = new ArrayList<String>();
                    }
                    eventData.add(value);
                    continue block12;
                }
                case "id": {
                    if (value.isEmpty()) continue block12;
                    ServerSentEventHelper.setId(event, value);
                    continue block12;
                }
                case "retry": {
                    if (value.isEmpty() || !ServerSentEventUtils.isDigitsOnly(value)) continue block12;
                    ServerSentEventHelper.setRetryAfter(event, Duration.ofMillis(Long.parseLong(value)));
                    continue block12;
                }
            }
        }
        if (event.getEvent() == null) {
            ServerSentEventHelper.setEvent(event, DEFAULT_EVENT);
        }
        if (eventData != null) {
            ServerSentEventHelper.setData(event, eventData);
        }
        return event;
    }

    private static boolean isDigitsOnly(String str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

